/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectScopeManager;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOnlyMergableOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class SafeUpdateOperation
extends CVSSubscriberOperation {
    private boolean promptBeforeUpdate = false;
    private SyncInfoSet skipped = new SyncInfoSet();

    protected SafeUpdateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, boolean promptBeforeUpdate) {
        super(configuration, elements);
        this.promptBeforeUpdate = promptBeforeUpdate;
    }

    public boolean shouldRun() {
        return this.promptIfNeeded();
    }

    @Override
    protected void run(Map projectSyncInfos, IProject project, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            Object[] resources = this.getIResourcesFrom(((SyncInfoSet)projectSyncInfos.get(project)).getSyncInfos());
            ResourceMapping[] selectedMappings = Utils.getResourceMappings((Object[])resources);
            SingleProjectSubscriberContext context = new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, project);
            SingleProjectScopeManager manager = new SingleProjectScopeManager(this.getJobName(), selectedMappings, (ResourceMappingContext)context, true, project);
            manager.initialize(null);
            EclipseSynchronizer.getInstance().run(this.getUpdateRule(manager), monitor1 -> {
                try {
                    this.runWithProjectRule(project, (SyncInfoSet)projectSyncInfos.get(project), monitor1);
                }
                catch (TeamException e) {
                    throw CVSException.wrapException((CoreException)((Object)((Object)((Object)e))));
                }
            }, Policy.subMonitorFor(monitor, 100));
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private ISchedulingRule getUpdateRule(SynchronizationScopeManager manager) {
        Object rule = null;
        ResourceMapping[] mappings = manager.getScope().getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            IProject[] mappingProjects = mapping.getProjects();
            int j = 0;
            while (j < mappingProjects.length) {
                rule = rule == null ? mappingProjects[j] : MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)mappingProjects[j]);
                ++j;
            }
            ++i;
        }
        return rule;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.skipped.clear();
        super.run(monitor);
        try {
            this.handleFailedUpdates(monitor);
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void runWithProjectRule(IProject project, SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, 100);
            this.removeKnownFailureCases(syncSet);
            this.safeUpdate(project, syncSet, Policy.subMonitorFor(monitor, 100));
            syncSet.rejectNodes(new FastSyncInfoFilter(){

                public boolean select(SyncInfo info) {
                    return SafeUpdateOperation.this.skipped.getSyncInfo(info.getLocal()) != null;
                }
            });
            this.updated(syncSet.getResources());
        }
        finally {
            monitor.done();
        }
    }

    private SyncInfoSet removeKnownFailureCases(SyncInfoSet syncSet) {
        FastSyncInfoFilter failFilter = this.getKnownFailureCases();
        SyncInfo[] willFail = syncSet.getNodes(failFilter);
        syncSet.rejectNodes(failFilter);
        int i = 0;
        while (i < willFail.length) {
            SyncInfo info = willFail[i];
            this.skipped.add(info);
            ++i;
        }
        return syncSet;
    }

    private void handleFailedUpdates(IProgressMonitor monitor) throws TeamException {
        if (!this.skipped.isEmpty()) {
            if (this.getOverwriteLocalChanges()) {
                if (this.promptForOverwrite(this.skipped)) {
                    this.overwriteUpdate(this.skipped, monitor);
                    if (!this.skipped.isEmpty()) {
                        this.updated(this.skipped.getResources());
                    }
                }
            } else {
                this.warnAboutFailedResources(this.skipped);
            }
        }
    }

    protected boolean getOverwriteLocalChanges() {
        return false;
    }

    protected void safeUpdate(IProject project, SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        ArrayList<SyncInfo> updateShallow = new ArrayList<SyncInfo>();
        HashSet<SyncInfo> parentCreationElements = new HashSet<SyncInfo>();
        ArrayList<SyncInfo> updateDeletions = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            SyncInfo changedNode = changed[i];
            SyncInfo parent = this.getParent(changedNode);
            if (parent != null && this.isOutOfSync(parent)) {
                parentCreationElements.add(parent);
            }
            IResource resource = changedNode.getLocal();
            int kind = changedNode.getKind();
            boolean willBeAttempted = false;
            if (resource.getType() == 1) {
                block1 : switch (kind & 0xC) {
                    case 8: {
                        switch (kind & 3) {
                            case 2: {
                                updateDeletions.add(changedNode);
                                willBeAttempted = true;
                                break block1;
                            }
                        }
                        updateShallow.add(changedNode);
                        willBeAttempted = true;
                        break;
                    }
                    case 12: {
                        switch (kind & 3) {
                            case 3: {
                                updateShallow.add(changedNode);
                                willBeAttempted = true;
                            }
                        }
                    }
                }
                if (!willBeAttempted) {
                    this.skipped.add(syncSet.getSyncInfo(resource));
                }
            } else if (this.isOutOfSync(changedNode)) {
                parentCreationElements.add(changedNode);
            }
            ++i;
        }
        try {
            monitor.beginTask(null, 100);
            if (updateDeletions.size() > 0) {
                this.runUpdateDeletions(updateDeletions.toArray(new SyncInfo[updateDeletions.size()]), Policy.subMonitorFor(monitor, 25));
            }
            if (parentCreationElements.size() > 0) {
                this.makeInSync(parentCreationElements.toArray(new SyncInfo[parentCreationElements.size()]), Policy.subMonitorFor(monitor, 25));
            }
            if (updateShallow.size() > 0) {
                this.runSafeUpdate(project, updateShallow.toArray(new SyncInfo[updateShallow.size()]), Policy.subMonitorFor(monitor, 50));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void overwriteUpdate(SyncInfoSet var1, IProgressMonitor var2) throws TeamException;

    protected FastSyncInfoFilter getKnownFailureCases() {
        return new FastSyncInfoFilter.OrSyncInfoFilter(new FastSyncInfoFilter[]{new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{FastSyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)1), new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return info.getLocal().getType() == 1;
            }
        }}), new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{FastSyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)3), new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                if (info.getLocal().getType() == 1) {
                    try {
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)info.getLocal()));
                        byte[] syncBytes = cvsFile.getSyncBytes();
                        return syncBytes == null || ResourceSyncInfo.isAddition((byte[])syncBytes);
                    }
                    catch (CVSException e) {
                        CVSUIPlugin.log((CoreException)((Object)e));
                    }
                }
                return false;
            }
        }}), new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{FastSyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)3), new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                IResourceVariant remote = info.getRemote();
                IResourceVariant base = info.getBase();
                if (info.getLocal().exists()) {
                    return base != null && remote == null;
                }
                return base != null && remote != null && !base.equals((Object)remote);
            }
        }}), new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{FastSyncInfoFilter.getDirectionAndChangeFilter((int)12, (int)3), new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                IResource local = info.getLocal();
                if (local.getType() == 1) {
                    try {
                        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)local));
                        byte[] syncBytes = file.getSyncBytes();
                        if (syncBytes != null) {
                            return ResourceSyncInfo.isBinary((byte[])syncBytes);
                        }
                    }
                    catch (CVSException e) {
                        CVSProviderPlugin.log((CoreException)((Object)e));
                        return true;
                    }
                }
                return false;
            }
        }}), new FastSyncInfoFilter.SyncInfoDirectionFilter(4)});
    }

    protected void warnAboutFailedResources(SyncInfoSet syncSet) {
        TeamUIPlugin.getStandardDisplay().syncExec(() -> MessageDialog.openInformation((Shell)this.getShell(), (String)CVSUIMessages.SafeUpdateAction_warnFilesWithConflictsTitle, (String)CVSUIMessages.SafeUpdateAction_warnFilesWithConflictsDescription));
    }

    protected abstract void runUpdateDeletions(SyncInfo[] var1, IProgressMonitor var2) throws TeamException;

    protected abstract void runSafeUpdate(IProject var1, SyncInfo[] var2, IProgressMonitor var3) throws TeamException;

    protected void safeUpdate(IProject project, IResource[] resources, Command.LocalOption[] localOptions, IProgressMonitor monitor) throws TeamException {
        try {
            UpdateOnlyMergableOperation operation = new UpdateOnlyMergableOperation(this.getPart(), project, resources, localOptions);
            operation.run(monitor);
            this.addSkippedFiles(operation.getSkippedFiles());
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Policy.cancelOperation();
        }
    }

    protected abstract void updated(IResource[] var1) throws TeamException;

    private void addSkippedFiles(IFile[] files) {
        SyncInfoSet set = this.getSyncInfoSet();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            this.skipped.add(set.getSyncInfo((IResource)file));
            ++i;
        }
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.UpdateAction_update;
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return NLS.bind((String)CVSUIMessages.UpdateAction_jobName, (Object[])new String[]{Integer.valueOf(syncSet.size()).toString()});
    }

    private boolean promptIfNeeded() {
        SyncInfoSet set = this.getSyncInfoSet();
        boolean[] result = new boolean[]{true};
        if (this.getPromptBeforeUpdate()) {
            TeamUIPlugin.getStandardDisplay().syncExec(() -> {
                String sizeString = Integer.toString(set.size());
                String message = set.size() > 1 ? NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateSeveral, (Object[])new String[]{sizeString}) : NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateOne, (Object[])new String[]{sizeString});
                blArray[0] = MessageDialog.openQuestion((Shell)this.getShell(), (String)NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateTitle, (Object[])new String[]{sizeString}), (String)message);
            });
        }
        return result[0];
    }

    public boolean getPromptBeforeUpdate() {
        return this.promptBeforeUpdate;
    }
}

