/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openacc.internal.fortran.editorHelp;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.help.IHelpResource;
import org.eclipse.photran.ui.IFortranAPIHelpProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenACCFortranHelpProvider
implements IFortranAPIHelpProvider {
    private static final String OPENACC_PLUGIN_ID = "org.eclipse.ptp.pldt.openacc.ui";
    private static final Pattern OPENACC_DIRECTIVE_PREFIX_PATTERN = Pattern.compile("(^[Cc*]|[ \\t]*!)\\$acc([ \\t]+end)?([ \\t]+parallel)?[ \\t]*");
    private static final String OPENACC_DIRECTIVE_REGEX_FORMAT = "(^[Cc*]|[ \\t]*!)\\$acc([ \\t]+end)?([ \\t]+parallel)?[ \\t]+%s.*";
    private final Set<String> procedures = new HashSet<String>(32);
    private final Set<String> directives = new HashSet<String>(32);

    public OpenACCFortranHelpProvider() {
        this.procedures.add("acc_get_num_devices");
        this.procedures.add("acc_set_device_type");
        this.procedures.add("acc_get_device_type");
        this.procedures.add("acc_set_device_num");
        this.procedures.add("acc_get_device_num");
        this.procedures.add("acc_async_test");
        this.procedures.add("acc_async_test_all");
        this.procedures.add("acc_async_wait");
        this.procedures.add("acc_async_wait_all");
        this.procedures.add("acc_init");
        this.procedures.add("acc_shutdown");
        this.procedures.add("acc_on_device");
        this.procedures.add("acc_malloc");
        this.procedures.add("acc_free");
        this.directives.add("parallel");
        this.directives.add("kernels");
        this.directives.add("data");
        this.directives.add("host_data");
        this.directives.add("loop");
        this.directives.add("cache");
        this.directives.add("declare");
        this.directives.add("update");
        this.directives.add("wait");
    }

    public IHelpResource[] getHelpResources(ITextEditor fortranEditor, String apiName, String precedingText) {
        String fname = apiName.toLowerCase();
        if (this.procedures.contains(fname)) {
            return this.getHelpResourceForFilename(fname);
        }
        if (OPENACC_DIRECTIVE_PREFIX_PATTERN.matcher(precedingText).find()) {
            if (this.directives.contains(fname)) {
                return this.getHelpResourceForFilename("pragma_acc_" + fname);
            }
            for (String directive : this.directives) {
                if (!precedingText.matches(String.format(OPENACC_DIRECTIVE_REGEX_FORMAT, directive))) continue;
                return this.getHelpResourceForFilename("pragma_acc_" + directive);
            }
        }
        return null;
    }

    private IHelpResource[] getHelpResourceForFilename(final String filename) {
        return new IHelpResource[]{new IHelpResource(){

            public String getHref() {
                return String.format("/%s/html/%s.html", OpenACCFortranHelpProvider.OPENACC_PLUGIN_ID, filename);
            }

            public String getLabel() {
                return filename;
            }
        }};
    }
}

