/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.gem.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.gem.GemPlugin;
import org.eclipse.ptp.internal.gem.util.Envelope;
import org.eclipse.ptp.internal.gem.util.GemUtilities;
import org.eclipse.ptp.internal.gem.util.InternalIssueOrderSorter;
import org.eclipse.ptp.internal.gem.util.ProgramOrderSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transitions {
    private final ArrayList<ArrayList<Envelope>> transitionList = new ArrayList();
    private final ArrayList<HashMap<String, Envelope>> errorCalls = new ArrayList();
    private HashMap<Integer, String> irrelevantBarriers = null;
    private HashMap<Integer, Envelope> resourceLeaks = null;
    private HashMap<Integer, String> typeMismatches = null;
    private ArrayList<Integer> deadlockInterleavings;
    private int numRanks;
    public int currentInterleaving;
    public int currentTransitionIndex;
    private int deadlockIndex;
    private boolean deadlock;
    private boolean assertionViolation;
    private boolean resourceLeak;
    private boolean fib;

    public Transitions(IFile logFile) throws ParseException {
        this.errorCalls.add(null);
        this.numRanks = -1;
        this.deadlock = false;
        this.assertionViolation = false;
        this.resourceLeak = false;
        this.parseLogFile(logFile);
    }

    public synchronized boolean deadlockInterleaving() {
        if (!this.deadlock) {
            return false;
        }
        this.currentInterleaving = this.deadlockInterleavings.get(this.deadlockIndex) - 1;
        this.currentTransitionIndex = -1;
        ++this.deadlockIndex;
        this.deadlockIndex %= this.deadlockInterleavings.size();
        return true;
    }

    public ArrayList<Envelope> getCollectiveTransitions(Envelope env) {
        if (env.getIssueIndex() < 0) {
            return null;
        }
        return env.getCommunicator_matches();
    }

    public int getCurrentInterleaving() {
        return this.currentInterleaving + 1;
    }

    public synchronized Envelope getCurrentTransition() {
        if (this.currentInterleaving < 0 || this.currentInterleaving >= this.transitionList.size() || this.currentTransitionIndex < 0 || this.currentTransitionIndex >= this.transitionList.get(this.currentInterleaving).size()) {
            return null;
        }
        return this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex);
    }

    public int getCurrentTransitionIndex() {
        return this.currentTransitionIndex;
    }

    public ArrayList<Integer> getDeadlockInterleavings() {
        return this.deadlockInterleavings;
    }

    public ArrayList<HashMap<String, Envelope>> getErrorCalls() {
        return this.errorCalls;
    }

    public synchronized Envelope getFirstTransition(int rank) {
        boolean valid = true;
        if (rank < 0 || rank > this.numRanks) {
            valid = false;
        }
        int size = this.transitionList.get(this.currentInterleaving).size();
        int i = 0;
        while (i < size) {
            Envelope env = this.transitionList.get(this.currentInterleaving).get(i);
            if (!valid || env.getRank() == rank) {
                this.currentTransitionIndex = i;
                return env;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Envelope> getInterleavingEnvelopes(int interleaving) {
        if (interleaving < 1 || interleaving > this.getTotalInterleavings()) {
            return null;
        }
        return this.transitionList.get(interleaving - 1);
    }

    public HashMap<Integer, String> getIrrelevantBarriers() {
        return this.irrelevantBarriers;
    }

    public synchronized Envelope getLastTransition(int rank) {
        int size;
        boolean valid = true;
        if (rank < 0 || rank > this.numRanks) {
            valid = false;
        }
        int i = size = this.transitionList.get(this.currentInterleaving).size() - 1;
        while (i >= 0) {
            Envelope env = this.transitionList.get(this.currentInterleaving).get(i);
            if (!valid || env.getRank() == rank) {
                this.currentTransitionIndex = i;
                return env;
            }
            --i;
        }
        return null;
    }

    public Envelope getMatchingTransition(Envelope env) {
        if (env.getIssueIndex() < 0) {
            return null;
        }
        return env.getMatch_envelope();
    }

    public synchronized Envelope getNextTransition(int rank) {
        if (this.currentTransitionIndex + 1 >= this.transitionList.get(this.currentInterleaving).size()) {
            return null;
        }
        if (rank < 0 || rank >= this.numRanks) {
            ++this.currentTransitionIndex;
            return this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex);
        }
        int end = this.transitionList.get(this.currentInterleaving).size();
        int i = this.currentTransitionIndex + 1;
        while (i < end) {
            Envelope e = this.transitionList.get(this.currentInterleaving).get(i);
            if (e.getRank() == rank) {
                this.currentTransitionIndex = i;
                return e;
            }
            ++i;
        }
        return null;
    }

    public int getNumRanks() {
        return this.numRanks;
    }

    public synchronized Envelope getPreviousTransition(int rank) {
        if (this.currentTransitionIndex <= 0) {
            return null;
        }
        if (rank < 0 || rank >= this.numRanks) {
            --this.currentTransitionIndex;
            return this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex);
        }
        int i = this.currentTransitionIndex - 1;
        while (i >= 0) {
            Envelope env = this.transitionList.get(this.currentInterleaving).get(i);
            if (env.getRank() == rank) {
                this.currentTransitionIndex = i;
                return env;
            }
            --i;
        }
        return null;
    }

    public String getRanksInvolved(int[] totalRanksInvolved) {
        Envelope currentEnvelope = this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex);
        int rank = currentEnvelope.getRank();
        String result = Integer.toString(rank);
        int currentLineNumber = currentEnvelope.getLinenumber();
        int i = this.currentTransitionIndex;
        int size = this.transitionList.get(this.currentInterleaving).size();
        int numRanksInvloved = 1;
        ++i;
        while (i < size) {
            Envelope env = this.transitionList.get(this.currentInterleaving).get(i);
            if (currentLineNumber != env.getLinenumber()) break;
            ++numRanksInvloved;
            result = String.valueOf(result) + "," + env.getRank();
            ++i;
        }
        totalRanksInvolved[0] = numRanksInvloved;
        return result;
    }

    public HashMap<Integer, Envelope> getResourceLeaks() {
        return this.resourceLeaks;
    }

    public int getTotalInterleavings() {
        return this.transitionList.size();
    }

    public ArrayList<ArrayList<Envelope>> getTransitionList() {
        return this.transitionList;
    }

    public HashMap<Integer, String> getTypeMismatches() {
        return this.typeMismatches;
    }

    public boolean hasAssertion() {
        return this.assertionViolation;
    }

    public boolean hasDeadlock() {
        return this.deadlock;
    }

    public boolean hasError() {
        if (this.assertionViolation || this.deadlock) {
            return true;
        }
        for (HashMap<String, Envelope> currentHash : this.errorCalls) {
            if (currentHash == null || currentHash.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFIB() {
        return this.fib;
    }

    public synchronized boolean hasNextInterleaving() {
        return this.currentInterleaving + 1 < this.transitionList.size();
    }

    public synchronized boolean hasNextTransition() {
        return this.currentTransitionIndex + 1 < this.transitionList.get(this.currentInterleaving).size();
    }

    public synchronized boolean hasPreviousInterleaving() {
        return this.currentInterleaving != 0;
    }

    public boolean hasPreviousTransition() {
        return this.currentTransitionIndex > 0;
    }

    public boolean hasResourceLeak() {
        return this.resourceLeak;
    }

    public synchronized boolean hasValidNextTransition(int rank) {
        if (this.currentTransitionIndex == -1) {
            try {
                this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex + 1);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        int tempIndex = this.currentTransitionIndex;
        while (tempIndex < this.transitionList.get(this.currentInterleaving).size()) {
            int line2;
            int line1 = this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex).getLinenumber();
            if (line1 == (line2 = this.transitionList.get(this.currentInterleaving).get(tempIndex).getLinenumber())) {
                ++tempIndex;
                continue;
            }
            if (rank == -1 || this.transitionList.get(this.currentInterleaving).get(tempIndex).getRank() == rank) {
                return true;
            }
            ++tempIndex;
        }
        return false;
    }

    public boolean hasValidPreviousTransition(int rank) {
        int tempIndex = this.currentTransitionIndex - 1;
        while (tempIndex >= 0) {
            int line1 = this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex).getLinenumber();
            int line2 = this.transitionList.get(this.currentInterleaving).get(tempIndex).getLinenumber();
            boolean collective = this.transitionList.get(this.currentInterleaving).get(this.currentTransitionIndex).isCollective();
            if (line1 == line2 && rank == -1 && collective) {
                --tempIndex;
                continue;
            }
            if (rank == -1 || this.transitionList.get(this.currentInterleaving).get(tempIndex).getRank() == rank) {
                return true;
            }
            --tempIndex;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void parseLogFile(IFile logFile) {
        block20: {
            p2pMatches = new HashMap<String, Envelope>();
            collectiveMatches = new HashMap<String, ArrayList>();
            issueOrders = new HashMap<Integer, Integer>();
            collectiveCount = new ArrayList<HashMap<K, V>>();
            scanner = null;
            line = null;
            interleaving = -1;
            fileReadSuccess = false;
            try {
                scanner = new Scanner(logFile.getContents());
                if (!scanner.hasNextLine()) {
                    return;
                }
                line = scanner.nextLine();
                try {
                    this.numRanks = Integer.parseInt(line);
                    fileReadSuccess = true;
                }
                catch (NumberFormatException e) {
                    GemUtilities.logExceptionDetail(e);
                }
                if (fileReadSuccess) {
                    i = 0;
                    while (i < this.numRanks) {
                        collectiveCount.add(new HashMap<K, V>());
                        ++i;
                    }
                }
                if (!scanner.hasNext()) ** GOTO lbl29
                {
lbl29:
                    // 1 sources

                    if (this.transitionList.size() == 0) {
                        this.transitionList.add(new ArrayList<E>());
                    }
                    str = GemPlugin.getDefault().getPreferenceStore().getString("stepOrderPreference");
                    size = this.transitionList.size();
                    if (str.equals("issueOrder")) {
                        k = 0;
                        while (k < size) {
                            Collections.sort((List)this.transitionList.get(k), new InternalIssueOrderSorter());
                            ++k;
                        }
                    } else {
                        l = 0;
                        while (l < size) {
                            Collections.sort((List)this.transitionList.get(l), new ProgramOrderSorter());
                            ++l;
                        }
                    }
                    this.currentInterleaving = 0;
                    this.currentTransitionIndex = -1;
                    break block20;
                }
                catch (CoreException ce) {
                    GemUtilities.logExceptionDetail((Exception)ce);
                    break block20;
                }
                catch (ParseException pe) {
                    GemUtilities.logExceptionDetail(pe);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    public synchronized Envelope setCurrentTransition(Envelope env) {
        if (env == null) {
            return null;
        }
        if (env.getInterleaving() - 1 < 0 || env.getInterleaving() - 1 >= this.transitionList.size()) {
            return null;
        }
        int i = 0;
        while (i < this.transitionList.get(env.getInterleaving() - 1).size()) {
            if (this.transitionList.get(env.getInterleaving() - 1).get(i) == env) {
                this.currentInterleaving = env.getInterleaving() - 1;
                this.currentTransitionIndex = i;
                return env;
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean setNextInterleaving() {
        if (this.currentInterleaving + 1 >= this.transitionList.size()) {
            return false;
        }
        ++this.currentInterleaving;
        this.currentTransitionIndex = -1;
        return true;
    }

    public synchronized boolean setPreviousInterleaving() {
        if (this.currentInterleaving == 0) {
            return false;
        }
        --this.currentInterleaving;
        this.currentTransitionIndex = -1;
        return true;
    }
}

