/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.sourcelookup;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourceMappingSourceContainerDialog
extends ElementTreeSelectionDialog {
    public static String EMPTY_STRING = "";
    private Text fPathText;
    private String fPath = EMPTY_STRING;
    private IContainer fContainer = null;
    private final IRemoteConnection fRemoteConnection;

    public ResourceMappingSourceContainerDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, IRemoteConnection conn) {
        super(parent, labelProvider, contentProvider);
        this.fRemoteConnection = conn;
        this.setTitle(Messages.ResourceMappingSourceContainerDialog_0);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IFolder) && !(selection[i] instanceof IProject)) {
                        return new Status(4, "org.eclipse.ptp.debug.ui", -1, Messages.ResourceMappingSourceContainerDialog_1, null);
                    }
                    ++i;
                }
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.ptp.debug.ui", -1, Messages.ResourceMappingSourceContainerDialog_2, null);
                }
                ResourceMappingSourceContainerDialog.this.fContainer = (IContainer)selection[0];
                if (ResourceMappingSourceContainerDialog.this.fPathText.getText().equals(EMPTY_STRING)) {
                    return new Status(4, "org.eclipse.ptp.debug.ui", -1, Messages.ResourceMappingSourceContainerDialog_3, null);
                }
                return new Status(0, "org.eclipse.ptp.debug.ui", 0, EMPTY_STRING, null);
            }
        };
        this.setValidator(validator);
        this.setDoubleClickSelects(true);
        this.setAllowMultiple(false);
        this.setMessage(Messages.ResourceMappingSourceContainerDialog_4);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IFolder)) {
                    if (element instanceof IProject) {
                        return ((IProject)element).isAccessible();
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public IContainer getContainer() {
        return this.fContainer;
    }

    public IPath getPath() {
        return new Path(this.fPath);
    }

    private String browseDirectory() {
        if (this.fRemoteConnection != null) {
            IRemoteUIFileService fileService = (IRemoteUIFileService)this.fRemoteConnection.getConnectionType().getService(IRemoteUIFileService.class);
            if (fileService != null) {
                IRemoteConnection conn = this.getRemoteConnection(this.fContainer.getProject());
                if (conn != null) {
                    fileService.setConnection(conn);
                } else {
                    fileService.showConnections(true);
                }
                return fileService.browseDirectory(this.getShell(), Messages.ResourceMappingSourceContainerDialog_5, this.fPathText.getText(), 0);
            }
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setText(Messages.ResourceMappingSourceContainerDialog_5);
            dialog.setFilterPath(this.fPathText.getText());
            return dialog.open();
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection(IProject project) {
        IRemoteUIConnectionService connUIService;
        if (!this.fRemoteConnection.isOpen() && (connUIService = (IRemoteUIConnectionService)this.fRemoteConnection.getConnectionType().getService(IRemoteUIConnectionService.class)) != null) {
            connUIService.openConnectionWithProgress(this.getShell(), null, this.fRemoteConnection);
        }
        return this.fRemoteConnection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentc = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentc, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Font font = parentc.getFont();
        composite.setFont(font);
        Label label = new Label(composite, 0);
        label.setText(Messages.ResourceMappingSourceContainerDialog_6);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fPathText = new Text(composite, 2052);
        this.fPathText.setText(EMPTY_STRING);
        this.fPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceMappingSourceContainerDialog.this.fPath = ResourceMappingSourceContainerDialog.this.fPathText.getText();
                ResourceMappingSourceContainerDialog.this.updateOKStatus();
            }
        });
        data = new GridData(768);
        this.fPathText.setLayoutData((Object)data);
        Button button = new Button(composite, 8);
        button.setFont(font);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = ResourceMappingSourceContainerDialog.this.browseDirectory();
                if (path != null) {
                    ResourceMappingSourceContainerDialog.this.fPathText.setText(path);
                }
            }
        });
        return parentc;
    }
}

