/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSBasedHover
implements ITextHover,
ITextHoverExtension {
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
    private static final LocationListener HYPER_LINK_LISTENER = new LocationListener(){

        public void changing(LocationEvent event) {
            if (!"about:blank".equals(event.location)) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                LSPEclipseUtils.open(event.location, page, null);
                event.doit = false;
            }
        }

        public void changed(LocationEvent event) {
        }
    };
    private List<CompletableFuture<?>> requests;
    private List<Hover> hoverResults;
    private IRegion lastRegion;
    private ITextViewer textViewer;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        if (!hoverRegion.equals(this.lastRegion) || !textViewer.equals(this.textViewer) || this.requests == null) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        try {
            CompletableFuture.allOf(this.requests.toArray(new CompletableFuture[this.requests.size()])).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        String result = "";
        if (this.hoverResults != null && !this.hoverResults.isEmpty()) {
            result = String.valueOf(result) + this.hoverResults.stream().filter(Objects::nonNull).map(LSBasedHover::getHoverString).filter(Objects::nonNull).collect(Collectors.joining("\n\n"));
        }
        if (result.isEmpty()) {
            return null;
        }
        result = MARKDOWN_PARSER.parseToHtml(result);
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        Color background = colorRegistry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND");
        String style = "<style TYPE='text/css'>html { font-family: " + JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName() + "; " + "font-size: " + Integer.toString(JFaceResources.getDefaultFontDescriptor().getFontData()[0].getHeight()) + "pt; " + (background != null ? "background-color: " + LSBasedHover.toHTMLrgb(background.getRGB()) + "; " : "") + (foreground != null ? "color: " + LSBasedHover.toHTMLrgb(foreground.getRGB()) + "; " : "") + " }</style>";
        int headIndex = result.indexOf("<head>");
        StringBuilder builder = new StringBuilder(result.length() + style.length());
        builder.append(result.substring(0, headIndex + "<head>".length()));
        builder.append(style);
        builder.append(result.substring(headIndex + "<head>".length()));
        return builder.toString();
    }

    protected static @Nullable String getHoverString(@NonNull Hover hover) {
        Either hoverContent = hover.getContents();
        if (hoverContent.isLeft()) {
            List contents = (List)hoverContent.getLeft();
            if (contents == null || contents.isEmpty()) {
                return null;
            }
            return contents.stream().map(content -> {
                if (content.isLeft()) {
                    return (String)content.getLeft();
                }
                if (content.isRight()) {
                    MarkedString markedString = (MarkedString)content.getRight();
                    if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                        return String.format("```%s\n%s\n```", markedString.getLanguage(), markedString.getValue());
                    }
                    return markedString.getValue();
                }
                return "";
            }).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining("\n\n"));
        }
        return ((MarkupContent)hoverContent.getRight()).getValue();
    }

    private static @NonNull String toHTMLrgb(RGB rgb) {
        StringBuilder builder = new StringBuilder(7);
        builder.append('#');
        LSBasedHover.appendAsHexString(builder, rgb.red);
        LSBasedHover.appendAsHexString(builder, rgb.green);
        LSBasedHover.appendAsHexString(builder, rgb.blue);
        return builder.toString();
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null) {
            return null;
        }
        Region res = null;
        this.initiateHoverRequest(textViewer, offset);
        try {
            CompletableFuture.allOf(this.requests.toArray(new CompletableFuture[this.requests.size()])).get(800L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e1) {
            LanguageServerPlugin.logError(e1);
        }
        IDocument document = textViewer.getDocument();
        if (!this.hoverResults.isEmpty()) {
            res = new Region(0, document.getLength());
            for (Hover hover : this.hoverResults) {
                int rangeOffset = offset;
                int rangeLength = 0;
                if (hover != null && hover.getRange() != null) {
                    try {
                        Range range = hover.getRange();
                        rangeOffset = LSPEclipseUtils.toOffset(range.getStart(), document);
                        rangeLength = LSPEclipseUtils.toOffset(range.getEnd(), document) - rangeOffset;
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                        res = new Region(offset, 1);
                    }
                }
                res = new Region(Math.max(res.getOffset(), rangeOffset), Math.min(res.getLength(), rangeLength));
            }
        } else {
            res = new Region(offset, 1);
        }
        this.lastRegion = res;
        this.textViewer = textViewer;
        return res;
    }

    private void initiateHoverRequest(@NonNull ITextViewer viewer, int offset) {
        this.textViewer = viewer;
        ArrayList requests = new ArrayList();
        IDocument document = viewer.getDocument();
        this.hoverResults = this.getHoverResults(document, offset, requests);
        this.requests = requests;
    }

    private List<Hover> getHoverResults(@NonNull IDocument document, int offset, List<CompletableFuture<?>> requests) {
        List<@NonNull LanguageServiceAccessor.LSPDocumentInfo> docInfos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, capabilities -> Boolean.TRUE.equals(capabilities.getHoverProvider()));
        List<Hover> hoverResults = Collections.synchronizedList(new ArrayList(docInfos.size()));
        for (LanguageServiceAccessor.LSPDocumentInfo info : docInfos) {
            info.getInitializedLanguageClient().thenAccept(languageServer -> {
                try {
                    CompletableFuture hover = languageServer.getTextDocumentService().hover(LSPEclipseUtils.toTextDocumentPosistionParams(info.getFileUri(), offset, info.getDocument()));
                    requests.add((CompletableFuture<?>)hover.thenAccept(hoverResults::add));
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            });
        }
        return hoverResults;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }

    private static class FocusableBrowserInformationControl
    extends BrowserInformationControl {
        public FocusableBrowserInformationControl(Shell parent) {
            super(parent, "org.eclipse.jface.defaultfont", EditorsUI.getTooltipAffordanceString());
        }

        protected void createContent(Composite parent) {
            super.createContent(parent);
            Browser b = (Browser)parent.getChildren()[0];
            b.addProgressListener(ProgressListener.completedAdapter(event -> {
                if (this.getInput() == null) {
                    return;
                }
                Browser browser = (Browser)event.getSource();
                @Nullable Point constraints = this.getSizeConstraints();
                Point hint = this.computeSizeHint();
                this.setSize(hint.x, hint.y);
                browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"nowrap\"");
                Double width = 20.0 + (Double)browser.evaluate("return document.body.scrollWidth;");
                if (constraints != null && (double)constraints.x < width) {
                    width = constraints.x;
                }
                this.setSize(width.intValue(), hint.y);
                browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"normal\"");
                Double height = (Double)browser.evaluate("return document.body.scrollHeight;");
                if (constraints != null && (double)constraints.y < height) {
                    height = constraints.y;
                }
                if (Platform.getPreferencesService().getBoolean("org.eclipse.ui.editors", "showTextHoverAffordance", true, null)) {
                    FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
                    height = (double)fontDatas[0].getHeight() + height;
                }
                this.setSize(width.intValue(), height.intValue());
            }));
            b.setJavascriptEnabled(true);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    BrowserInformationControl res = new BrowserInformationControl(parent, "org.eclipse.jface.defaultfont", true);
                    res.addLocationListener(HYPER_LINK_LISTENER);
                    return res;
                }
            };
        }
    }
}

