/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.wizards.pages;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.ui.wizards.pages.GrammarGroup;
import org.eclipse.ldt.ui.wizards.pages.LuaExecutionEnvironmentGroup;
import org.eclipse.ldt.ui.wizards.pages.Messages;
import org.eclipse.swt.widgets.Composite;

public class LuaProjectSettingsPage
extends ProjectWizardFirstPage
implements Observer {
    private LuaExecutionEnvironmentGroup luaExecutionEnvironmentGroup;
    private GrammarGroup grammarGroup;

    public LuaProjectSettingsPage() {
        this.setTitle(Messages.LuaProjecSettingsPageLabel);
    }

    protected boolean supportInterpreter() {
        return false;
    }

    protected ProjectWizardFirstPage.LocationGroup createLocationGroup() {
        return new LuaLocationGroup();
    }

    protected void createCustomGroups(Composite composite) {
        this.luaExecutionEnvironmentGroup = this.createExecutionEnvironmentGroup(composite);
        this.grammarGroup = this.createGrammarGroup(composite);
        String defaultGrammar = LuaGrammarManager.getDefaultGrammarFor((LuaExecutionEnvironment)this.getExecutionEnvironment()).getName();
        this.grammarGroup.setDefaultGrammar(defaultGrammar);
    }

    protected GrammarGroup createGrammarGroup(Composite composite) {
        return new GrammarGroup(composite);
    }

    protected LuaExecutionEnvironmentGroup createExecutionEnvironmentGroup(Composite composite) {
        return new LuaExecutionEnvironmentGroup(composite);
    }

    public LuaExecutionEnvironment getExecutionEnvironment() {
        if (this.luaExecutionEnvironmentGroup != null) {
            return this.luaExecutionEnvironmentGroup.getSelectedLuaExecutionEnvironment();
        }
        return null;
    }

    public String getGrammar() {
        if (this.grammarGroup != null) {
            return this.grammarGroup.getSelectedGrammar();
        }
        return null;
    }

    public boolean hasToCreateMain() {
        return this.hasToCreateTemplate();
    }

    public boolean hasToCreateTemplate() {
        return this.luaExecutionEnvironmentGroup != null && this.luaExecutionEnvironmentGroup.hasToCreateMain();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.fLocationGroup.addObserver((Observer)this);
        this.luaExecutionEnvironmentGroup.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                LuaExecutionEnvironment ee = LuaProjectSettingsPage.this.getExecutionEnvironment();
                LuaProjectSettingsPage.this.grammarGroup.setDefaultGrammar(LuaGrammarManager.getDefaultGrammarFor((LuaExecutionEnvironment)ee).getName());
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && (!this.fLocationGroup.isExternalProject() || !this.isCurrentPage());
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete() && this.getNextPage() != null;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.getContainer().updateButtons();
    }

    public class LuaLocationGroup
    extends ProjectWizardFirstPage.LocationGroup {
        public LuaLocationGroup() {
            super((ProjectWizardFirstPage)LuaProjectSettingsPage.this);
        }

        protected void createEnvironmentControls(Composite group, int numColumns) {
        }
    }
}

