/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal.launchconfiguration.attach;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.ui.launchConfigurations.ScriptLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.debug.ui.internal.Activator;
import org.eclipse.ldt.debug.ui.internal.launchconfiguration.attach.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LuaAttachMainTab
extends ScriptLaunchConfigurationTab {
    private static final String DEFAULT_IDEKEY = "luaidekey";
    private static final String DEFAULT_REPLACE_PATH = "";
    private static final String DEFAULT_MAPPING_TYPE = "local";
    private Text txtIdeKey;
    private Text txtTimeout;
    private Button btnLocalResolution;
    private Button btnModuleResolution;
    private Button btnReplacePathResolution;
    private Label lblReplacePath;
    private Text txtReplacePath;
    private SelectionListener sourceMappingSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            LuaAttachMainTab.this.updateSouceMappingUI();
            LuaAttachMainTab.this.scheduleUpdateJob();
        }
    };
    private ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            LuaAttachMainTab.this.scheduleUpdateJob();
        }
    };

    public LuaAttachMainTab(String mode) {
        super(mode);
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.remoteTab_title;
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("icons/obj16/lua_attach_maintab.gif");
    }

    private int getDefaultRemoteTimeout() {
        return DLTKDebugPlugin.getConnectionTimeout() * 3;
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        this.txtIdeKey.setText(LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"dbgp_session_id", (String)DEFAULT_IDEKEY));
        this.txtTimeout.setText(Integer.toString(LaunchConfigurationUtils.getConnectionTimeout((ILaunchConfiguration)config, (int)this.getDefaultRemoteTimeout()) / 1000));
        String mappingType = LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"source_mapping_type", (String)DEFAULT_MAPPING_TYPE);
        this.selectSourceMapping(mappingType);
        this.txtReplacePath.setText(LaunchConfigurationUtils.getString((ILaunchConfiguration)config, (String)"remoteWorkingDir", (String)DEFAULT_REPLACE_PATH));
    }

    private void selectSourceMapping(String mappingType) {
        if (mappingType.equals("module")) {
            this.btnModuleResolution.setSelection(true);
        } else if (mappingType.equals("replace_path")) {
            this.btnReplacePathResolution.setSelection(true);
        } else {
            this.btnLocalResolution.setSelection(true);
        }
        this.updateSouceMappingUI();
    }

    private void updateSouceMappingUI() {
        boolean selection = this.btnReplacePathResolution.getSelection();
        this.txtReplacePath.setEnabled(selection);
        this.lblReplacePath.setEnabled(selection);
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        int timeout;
        config.setAttribute("dbgp_session_id", this.txtIdeKey.getText().trim());
        try {
            timeout = Integer.parseInt(this.txtTimeout.getText().trim());
        }
        catch (NumberFormatException e) {
            timeout = this.getDefaultRemoteTimeout() / 1000;
        }
        config.setAttribute("dbpg_waiting_timeout", timeout * 1000);
        String sourceMapping = this.getSelectedSourceMapping();
        config.setAttribute("source_mapping_type", sourceMapping);
        config.setAttribute("remoteWorkingDir", this.txtReplacePath.getText().trim());
    }

    private String getSelectedSourceMapping() {
        if (this.btnModuleResolution.getSelection()) {
            return "module";
        }
        if (this.btnReplacePathResolution.getSelection()) {
            return "replace_path";
        }
        return DEFAULT_MAPPING_TYPE;
    }

    protected boolean validate() {
        return super.validate() && this.validateIdeKey();
    }

    public boolean canSave() {
        return this.validate();
    }

    protected boolean validateIdeKey() {
        String key = this.txtIdeKey.getText().trim();
        if (key.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.remoteError_ideKeyEmpty);
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        this.createClientInfo(comp);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.doCreateControl(comp);
        this.createVerticalSpacer(comp, 1);
        this.createDebugOptionsGroup(comp);
        this.createCustomSections(comp);
        Dialog.applyDialogFont((Control)comp);
    }

    protected void createClientInfo(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        Link lnkDocumentation = new Link(comp, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)lnkDocumentation);
        lnkDocumentation.setText(NLS.bind((String)Messages.LuaAttachMainTab_client_info_description, (Object)"debugger.lua"));
        lnkDocumentation.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if ("debugger.lua".equals(event.text)) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    String selectedDirPath = directoryDialog.open();
                    if (selectedDirPath != null) {
                        File destDir = new File(selectedDirPath);
                        try {
                            URL debuggerEntry = org.eclipse.ldt.debug.core.internal.Activator.getDefault().getBundle().getEntry("script/external");
                            File debuggerFolder = new File(FileLocator.toFileURL((URL)debuggerEntry).getFile());
                            File debuggerFile = new File(debuggerFolder, "debugger.lua");
                            FileUtils.copyFileToDirectory((File)debuggerFile, (File)destDir, (boolean)true);
                            if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.LuaAttachMainTab_copy_done_title, (String)NLS.bind((String)Messages.LuaAttachMainTab_copy_done_question, (Object)"debugger.lua"))) {
                                Program.launch((String)destDir.toString());
                            }
                        }
                        catch (IOException e) {
                            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.LuaAttachMainTab_copy_failed_title, null, (IStatus)new Status(2, "org.eclipse.ldt.debug.ui", NLS.bind((String)Messages.LuaAttachMainTab_copy_failed_description, (Object)"debugger.lua"), (Throwable)e));
                        }
                    }
                } else {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.ldt.doc.user/help/LDT/User_Area/User_Guides/User_Guide_1.4/Tasks.html#Attach_session");
                }
            }
        });
    }

    protected void doCreateControl(Composite composite) {
        Group grpConnectionProperties = new Group(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)grpConnectionProperties);
        grpConnectionProperties.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_connection_properties_group);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)grpConnectionProperties);
        Label lblIdekey = new Label((Composite)grpConnectionProperties, 0);
        GridDataFactory.swtDefaults().applyTo((Control)lblIdekey);
        lblIdekey.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_idekey_label);
        this.txtIdeKey = new Text((Composite)grpConnectionProperties, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtIdeKey);
        this.txtIdeKey.addModifyListener(this.textModifyListener);
        Label lblTimeout = new Label((Composite)grpConnectionProperties, 0);
        lblTimeout.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_timeout_label);
        GridDataFactory.swtDefaults().applyTo((Control)lblTimeout);
        this.txtTimeout = new Text((Composite)grpConnectionProperties, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.txtTimeout);
        this.txtTimeout.addModifyListener(this.textModifyListener);
        Group grpSourceMapping = new Group(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)grpSourceMapping);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)grpSourceMapping);
        grpSourceMapping.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_sourcemapping_group);
        int hident = 40;
        GridDataFactory generalInfoGridDataFactory = GridDataFactory.swtDefaults().grab(true, false).span(2, 1);
        GridDataFactory radiobuttonGridDataFactory = generalInfoGridDataFactory.copy().indent(10, 0);
        GridDataFactory infoGridDataFactory = GridDataFactory.fillDefaults().grab(true, false).span(2, 1).indent(hident, 0);
        Font italicfont = this.getInformationFont();
        Label lblsourcemappingintro = new Label((Composite)grpSourceMapping, 0);
        generalInfoGridDataFactory.applyTo((Control)lblsourcemappingintro);
        lblsourcemappingintro.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_documentation_intro);
        this.btnLocalResolution = new Button((Composite)grpSourceMapping, 16);
        radiobuttonGridDataFactory.applyTo((Control)this.btnLocalResolution);
        this.btnLocalResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_localresolution_radiobutton);
        this.btnLocalResolution.addSelectionListener(this.sourceMappingSelectionListener);
        Text txtLocalResolution = new Text((Composite)grpSourceMapping, 64);
        infoGridDataFactory.applyTo((Control)txtLocalResolution);
        txtLocalResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_localresolution_textinfo);
        txtLocalResolution.setFont(italicfont);
        txtLocalResolution.setBackground(lblsourcemappingintro.getBackground());
        txtLocalResolution.setEnabled(false);
        this.btnModuleResolution = new Button((Composite)grpSourceMapping, 16);
        radiobuttonGridDataFactory.applyTo((Control)this.btnModuleResolution);
        this.btnModuleResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_moduleresolution_radiobutton);
        this.btnModuleResolution.addSelectionListener(this.sourceMappingSelectionListener);
        Text txtModuleResolution = new Text((Composite)grpSourceMapping, 64);
        infoGridDataFactory.applyTo((Control)txtModuleResolution);
        txtModuleResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_moduleresolution_textinfo);
        txtModuleResolution.setFont(italicfont);
        txtModuleResolution.setBackground(lblsourcemappingintro.getBackground());
        txtModuleResolution.setEnabled(false);
        this.btnReplacePathResolution = new Button((Composite)grpSourceMapping, 16);
        this.btnReplacePathResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_replacepathresolution_radiobutton);
        radiobuttonGridDataFactory.applyTo((Control)this.btnReplacePathResolution);
        this.btnReplacePathResolution.addSelectionListener(this.sourceMappingSelectionListener);
        Text txtReplacePathResolution = new Text((Composite)grpSourceMapping, 64);
        infoGridDataFactory.applyTo((Control)txtReplacePathResolution);
        txtReplacePathResolution.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_replacepathresolution_textinfo);
        txtReplacePathResolution.setFont(italicfont);
        txtReplacePathResolution.setBackground(lblsourcemappingintro.getBackground());
        txtReplacePathResolution.setEnabled(false);
        this.lblReplacePath = new Label((Composite)grpSourceMapping, 0);
        GridDataFactory.swtDefaults().indent(hident, 0).applyTo((Control)this.lblReplacePath);
        this.lblReplacePath.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_path_label);
        this.txtReplacePath = new Text((Composite)grpSourceMapping, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.txtReplacePath);
        this.txtReplacePath.addModifyListener(this.textModifyListener);
        Link lnkDocumentation = new Link((Composite)grpSourceMapping, 0);
        generalInfoGridDataFactory.applyTo((Control)lnkDocumentation);
        lnkDocumentation.setText(org.eclipse.ldt.debug.ui.internal.Messages.LuaAttachMainTab_documentation_link);
        lnkDocumentation.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.ldt.doc.user/help/LDT/User_Area/User_Guides/User_Guide_1.4/Concepts.html#Source_Mapping");
            }
        });
    }

    private Font getInformationFont() {
        Font italic;
        Font textFont = JFaceResources.getTextFont();
        if (textFont == null) {
            return JFaceResources.getDefaultFont();
        }
        if (textFont.getFontData().length > 0 && (italic = JFaceResources.getFontRegistry().getItalic(textFont.getFontData()[0].getName())) != null) {
            return italic;
        }
        return textFont;
    }

    protected String getNatureID() {
        return LuaLanguageToolkit.getDefault().getNatureId();
    }
}

