/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.IteratorChain;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;

public class CompCheck {
    private Map<Long, Set<String>> m_mustMap = new HashMap<Long, Set<String>>();
    private Map<Long, Set<String>> m_mustMapNoProp = new HashMap<Long, Set<String>>();
    private List<ITestSuitePO> m_suites;
    private IAUTMainPO m_aut;
    private IProblem m_autProblem;
    private Map<Long, IProblem> m_autProblems;

    public CompCheck(List<ITestSuitePO> suites) {
        this.m_suites = suites;
    }

    public void traverse() {
        System.currentTimeMillis();
        for (ITestSuitePO ts : this.m_suites) {
            IAUTMainPO aut = ts.getAut();
            if (aut == null) continue;
            this.traverseImpl(ts);
            this.getProblematicGuids(ts);
        }
    }

    private void traverseImpl(INodePO node) {
        Iterator<INodePO> it = node.getAllNodeIter();
        while (it.hasNext()) {
            INodePO next = it.next();
            if (this.getId(next) == null || this.m_mustMap.containsKey(this.getId(next)) || next instanceof ICapPO) continue;
            this.traverseImpl(next);
        }
        HashSet<String> nodeGuids = new HashSet<String>();
        HashSet<String> nodeGuidsNoProp = new HashSet<String>();
        Long id = this.getId(node);
        Iterator<INodePO> it2 = node.getAllNodeIter();
        while (it2.hasNext()) {
            this.handleNext(nodeGuids, nodeGuidsNoProp, it2.next());
        }
        this.m_mustMap.put(id, nodeGuids);
        this.m_mustMapNoProp.put(id, nodeGuidsNoProp);
    }

    private void handleNext(Set<String> nodeGuids, Set<String> nodeGuidsNoProp, INodePO child) {
        String guid;
        if (!child.isActive()) {
            return;
        }
        if (child instanceof IExecTestCasePO) {
            this.handleExecTestCasePO(nodeGuids, nodeGuidsNoProp, (IExecTestCasePO)child);
        } else if (child instanceof ICapPO && this.isRelevant((ICapPO)child) && (guid = ((ICapPO)child).getComponentName()) != null) {
            nodeGuids.add(CompNameManager.getInstance().resolveGuid(guid));
        }
    }

    private void handleExecTestCasePO(Set<String> guids, Set<String> guidsNoProp, IExecTestCasePO child) {
        ISpecTestCasePO childSpecTC = child.getSpecTestCase();
        if (childSpecTC != null) {
            Set<String> childSpecGuids = this.m_mustMap.get(childSpecTC.getId());
            for (String guid : childSpecGuids) {
                ICompNamesPairPO pair = child.getCompNamesPair(guid);
                if (pair == null) {
                    guids.add(guid);
                    continue;
                }
                if (pair.isPropagated()) {
                    guids.add(CompNameManager.getInstance().resolveGuid(pair.getSecondName()));
                    continue;
                }
                guidsNoProp.add(CompNameManager.getInstance().resolveGuid(pair.getSecondName()));
            }
            guidsNoProp.addAll((Collection<String>)this.m_mustMapNoProp.get(childSpecTC.getId()));
        }
    }

    private Long getId(INodePO node) {
        if (node instanceof IExecTestCasePO) {
            ISpecTestCasePO specTC = ((IExecTestCasePO)node).getSpecTestCase();
            if (specTC != null) {
                return specTC.getId();
            }
            return null;
        }
        return node.getId();
    }

    public void addProblems() {
        this.m_autProblems = new HashMap<Long, IProblem>();
        for (ITestSuitePO ts : this.m_suites) {
            Set<String> problems;
            this.m_aut = ts.getAut();
            if (this.m_aut == null) continue;
            this.m_autProblem = this.m_autProblems.get(this.m_aut.getId());
            if (this.m_autProblem == null) {
                this.m_autProblem = ProblemFactory.createIncompleteObjectMappingProblem(this.m_aut);
                this.m_autProblems.put(this.m_aut.getId(), this.m_autProblem);
            }
            if ((problems = this.getProblematicGuids(ts)).isEmpty()) continue;
            this.addProblemsImpl(ts, problems);
        }
    }

    private void addProblemsImpl(INodePO node, Set<String> problemGuids) {
        if (problemGuids.size() == 0 || !node.isActive()) {
            return;
        }
        node.addProblem(this.m_autProblem);
        Iterator<INodePO> it = node.getAllNodeIter();
        while (it.hasNext()) {
            INodePO child = it.next();
            if (!(child instanceof IExecTestCasePO)) continue;
            this.addProblemsImpl(child, this.problemHandleExecTC((IExecTestCasePO)child, problemGuids));
        }
    }

    private Set<String> problemHandleExecTC(IExecTestCasePO child, Set<String> problemGuids) {
        ISpecTestCasePO spec = child.getSpecTestCase();
        HashSet<String> result = new HashSet<String>();
        if (spec == null) {
            return result;
        }
        for (String guid : this.m_mustMapNoProp.get(spec.getId())) {
            if (!problemGuids.contains(guid)) continue;
            result.add(guid);
        }
        for (String guid : this.m_mustMap.get(spec.getId())) {
            ICompNamesPairPO pair = child.getCompNamesPair(guid);
            if (pair == null && problemGuids.contains(guid)) {
                result.add(guid);
                continue;
            }
            if (pair == null || pair.isPropagated() || !problemGuids.contains(pair.getSecondName())) continue;
            child.addProblem(this.m_autProblem);
        }
        return result;
    }

    private Set<String> getProblematicGuids(ITestSuitePO ts) {
        HashSet<String> problemGuids = new HashSet<String>();
        IAUTMainPO aut = ts.getAut();
        IteratorChain it = new IteratorChain(this.m_mustMap.get(ts.getId()).iterator(), this.m_mustMapNoProp.get(ts.getId()).iterator());
        while (it.hasNext()) {
            String guid = (String)it.next();
            IComponentIdentifier id = null;
            try {
                id = aut.getObjMap().getTechnicalName(guid);
            }
            catch (LogicComponentNotManagedException logicComponentNotManagedException) {}
            if (id != null) continue;
            problemGuids.add(guid);
        }
        return problemGuids;
    }

    private boolean isRelevant(ICapPO cap) {
        Component metaComponentType = cap.getMetaComponentType();
        return !(metaComponentType instanceof ConcreteComponent) || !((ConcreteComponent)metaComponentType).hasDefaultMapping();
    }

    public Map<Long, Set<String>> getCompNamesToMap() {
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(this.m_suites.size());
        for (ITestSuitePO ts : this.m_suites) {
            if (ts.getAut() == null) continue;
            result.put(ts.getId(), this.m_mustMap.get(ts.getId()));
            result.put(ts.getId(), this.m_mustMapNoProp.get(ts.getId()));
        }
        return result;
    }
}

