/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IUserSettings;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>User Settings</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#getReporterId <em>Reporter Id</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#getReporterName <em>Reporter Name</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#getReporterEmail <em>Reporter Email</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#isAnonymizeMessages <em>Anonymize Messages</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#isAnonymizeStackTraces <em>Anonymize Stack Traces</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.UserSettingsImpl#isDisableAutomaticWiringAnalysis <em>Disable Automatic Wiring Analysis</em>}</li>
 * </ul>
 *
 * @generated
 */
public class UserSettingsImpl extends MinimalEObjectImpl.Container implements IUserSettings {
	/**
	 * The default value of the '{@link #getReporterId() <em>Reporter Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterId()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterId() <em>Reporter Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterId()
	 * @generated
	 * @ordered
	 */
	protected String reporterId = REPORTER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getReporterName() <em>Reporter Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterName()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterName() <em>Reporter Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterName()
	 * @generated
	 * @ordered
	 */
	protected String reporterName = REPORTER_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReporterEmail() <em>Reporter Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterEmail()
	 * @generated
	 * @ordered
	 */
	protected static final String REPORTER_EMAIL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getReporterEmail() <em>Reporter Email</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReporterEmail()
	 * @generated
	 * @ordered
	 */
	protected String reporterEmail = REPORTER_EMAIL_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnonymizeMessages() <em>Anonymize Messages</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeMessages()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANONYMIZE_MESSAGES_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAnonymizeMessages() <em>Anonymize Messages</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeMessages()
	 * @generated
	 * @ordered
	 */
	protected boolean anonymizeMessages = ANONYMIZE_MESSAGES_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnonymizeStackTraces() <em>Anonymize Stack Traces</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeStackTraces()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANONYMIZE_STACK_TRACES_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isAnonymizeStackTraces() <em>Anonymize Stack Traces</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymizeStackTraces()
	 * @generated
	 * @ordered
	 */
	protected boolean anonymizeStackTraces = ANONYMIZE_STACK_TRACES_EDEFAULT;

	/**
	 * The default value of the '{@link #isDisableAutomaticWiringAnalysis() <em>Disable Automatic Wiring Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableAutomaticWiringAnalysis()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDisableAutomaticWiringAnalysis() <em>Disable Automatic Wiring Analysis</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDisableAutomaticWiringAnalysis()
	 * @generated
	 * @ordered
	 */
	protected boolean disableAutomaticWiringAnalysis = DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UserSettingsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IModelPackage.Literals.USER_SETTINGS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterId() {
		return reporterId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterId(String newReporterId) {
		String oldReporterId = reporterId;
		reporterId = newReporterId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__REPORTER_ID, oldReporterId, reporterId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterName() {
		return reporterName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterName(String newReporterName) {
		String oldReporterName = reporterName;
		reporterName = newReporterName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__REPORTER_NAME, oldReporterName, reporterName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getReporterEmail() {
		return reporterEmail;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReporterEmail(String newReporterEmail) {
		String oldReporterEmail = reporterEmail;
		reporterEmail = newReporterEmail;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__REPORTER_EMAIL, oldReporterEmail, reporterEmail));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnonymizeMessages() {
		return anonymizeMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymizeMessages(boolean newAnonymizeMessages) {
		boolean oldAnonymizeMessages = anonymizeMessages;
		anonymizeMessages = newAnonymizeMessages;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES, oldAnonymizeMessages, anonymizeMessages));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnonymizeStackTraces() {
		return anonymizeStackTraces;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymizeStackTraces(boolean newAnonymizeStackTraces) {
		boolean oldAnonymizeStackTraces = anonymizeStackTraces;
		anonymizeStackTraces = newAnonymizeStackTraces;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES, oldAnonymizeStackTraces, anonymizeStackTraces));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDisableAutomaticWiringAnalysis() {
		return disableAutomaticWiringAnalysis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisableAutomaticWiringAnalysis(boolean newDisableAutomaticWiringAnalysis) {
		boolean oldDisableAutomaticWiringAnalysis = disableAutomaticWiringAnalysis;
		disableAutomaticWiringAnalysis = newDisableAutomaticWiringAnalysis;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS, oldDisableAutomaticWiringAnalysis, disableAutomaticWiringAnalysis));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IModelPackage.USER_SETTINGS__REPORTER_ID:
				return getReporterId();
			case IModelPackage.USER_SETTINGS__REPORTER_NAME:
				return getReporterName();
			case IModelPackage.USER_SETTINGS__REPORTER_EMAIL:
				return getReporterEmail();
			case IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES:
				return isAnonymizeMessages();
			case IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES:
				return isAnonymizeStackTraces();
			case IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				return isDisableAutomaticWiringAnalysis();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IModelPackage.USER_SETTINGS__REPORTER_ID:
				setReporterId((String)newValue);
				return;
			case IModelPackage.USER_SETTINGS__REPORTER_NAME:
				setReporterName((String)newValue);
				return;
			case IModelPackage.USER_SETTINGS__REPORTER_EMAIL:
				setReporterEmail((String)newValue);
				return;
			case IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES:
				setAnonymizeMessages((Boolean)newValue);
				return;
			case IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES:
				setAnonymizeStackTraces((Boolean)newValue);
				return;
			case IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				setDisableAutomaticWiringAnalysis((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IModelPackage.USER_SETTINGS__REPORTER_ID:
				setReporterId(REPORTER_ID_EDEFAULT);
				return;
			case IModelPackage.USER_SETTINGS__REPORTER_NAME:
				setReporterName(REPORTER_NAME_EDEFAULT);
				return;
			case IModelPackage.USER_SETTINGS__REPORTER_EMAIL:
				setReporterEmail(REPORTER_EMAIL_EDEFAULT);
				return;
			case IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES:
				setAnonymizeMessages(ANONYMIZE_MESSAGES_EDEFAULT);
				return;
			case IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES:
				setAnonymizeStackTraces(ANONYMIZE_STACK_TRACES_EDEFAULT);
				return;
			case IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				setDisableAutomaticWiringAnalysis(DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IModelPackage.USER_SETTINGS__REPORTER_ID:
				return REPORTER_ID_EDEFAULT == null ? reporterId != null : !REPORTER_ID_EDEFAULT.equals(reporterId);
			case IModelPackage.USER_SETTINGS__REPORTER_NAME:
				return REPORTER_NAME_EDEFAULT == null ? reporterName != null : !REPORTER_NAME_EDEFAULT.equals(reporterName);
			case IModelPackage.USER_SETTINGS__REPORTER_EMAIL:
				return REPORTER_EMAIL_EDEFAULT == null ? reporterEmail != null : !REPORTER_EMAIL_EDEFAULT.equals(reporterEmail);
			case IModelPackage.USER_SETTINGS__ANONYMIZE_MESSAGES:
				return anonymizeMessages != ANONYMIZE_MESSAGES_EDEFAULT;
			case IModelPackage.USER_SETTINGS__ANONYMIZE_STACK_TRACES:
				return anonymizeStackTraces != ANONYMIZE_STACK_TRACES_EDEFAULT;
			case IModelPackage.USER_SETTINGS__DISABLE_AUTOMATIC_WIRING_ANALYSIS:
				return disableAutomaticWiringAnalysis != DISABLE_AUTOMATIC_WIRING_ANALYSIS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (reporterId: ");
		result.append(reporterId);
		result.append(", reporterName: ");
		result.append(reporterName);
		result.append(", reporterEmail: ");
		result.append(reporterEmail);
		result.append(", anonymizeMessages: ");
		result.append(anonymizeMessages);
		result.append(", anonymizeStackTraces: ");
		result.append(anonymizeStackTraces);
		result.append(", disableAutomaticWiringAnalysis: ");
		result.append(disableAutomaticWiringAnalysis);
		result.append(')');
		return result.toString();
	}

} //UserSettingsImpl
