/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;

public class NatTableDropListener
implements DropTargetListener {
    private final NatTable natTable;
    private final NatTableWidget natTableWidget;

    public NatTableDropListener(NatTable fNatTable, NatTableWidget natTableWidget) {
        this.natTable = fNatTable;
        this.natTableWidget = natTableWidget;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        IStructuredSelection structuredSelection = null;
        if (data instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)data;
        }
        Point point = this.natTableWidget.toControl(event.x, event.y);
        IGridElement gridElement = this.getSelectedGridElementAndSelect(point);
        Column column = null;
        Row row = null;
        if (gridElement != null) {
            column = gridElement.getColumn();
            row = gridElement.getRow();
        }
        event.detail = this.natTableWidget.getController().canBeDropped(structuredSelection, row, column) ? 1 : 0;
    }

    protected IGridElement getSelectedGridElementAndSelect(Point point) {
        IGridElement result = null;
        List<PositionCoordinate> selectedCellsPos = this.natTableWidget.getSelectedCellsPositionCoordinates();
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        SelectionLayer selectionLayer = this.natTableWidget.getBodyLayer().getSelectionLayer();
        if (cellPosition == null) {
            if (selectedCellsPos.size() != 0) {
                selectionLayer.clear();
                this.natTable.redraw();
            }
        } else {
            result = this.getGridElement(cellPosition);
            if (selectedCellsPos.size() != 1 || !selectedCellsPos.get(0).equals((Object)cellPosition)) {
                int columnPos = cellPosition.getColumnPosition();
                int rowPos = cellPosition.getRowPosition();
                selectionLayer.selectCell(columnPos, rowPos, false, false);
                this.natTable.redraw();
            }
        }
        return result;
    }

    public void drop(DropTargetEvent event) {
        Point point = this.natTableWidget.toControl(event.x, event.y);
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        if (event.data instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)event.data;
            if (cellPosition == null) {
                this.natTableWidget.getController().drop(structuredSelection);
            } else {
                IGridElement gridElement = this.getGridElement(cellPosition);
                if (gridElement != null) {
                    this.dropOnGridElement(structuredSelection, gridElement);
                }
            }
        }
    }

    private IGridElement getGridElement(PositionCoordinate cellPosition) {
        Object dataValue;
        IGridElement result = null;
        LayerCell cell = this.natTableWidget.getCellAt(cellPosition.getColumnPosition(), cellPosition.getRowPosition());
        if (cell != null && (dataValue = cell.getDataValue()) instanceof IGridElement) {
            result = (IGridElement)dataValue;
        }
        return result;
    }

    private void dropOnGridElement(IStructuredSelection structuredSelection, IGridElement gridElement) {
        Column column = gridElement.getColumn();
        if (column instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            if (featureColumn.getFeature() instanceof EStructuralFeature) {
                EStructuralFeature structuralFeature = (EStructuralFeature)featureColumn.getFeature();
                this.dropOnFeature(structuredSelection, gridElement.getElement(), structuralFeature);
            } else {
                Logger.logError((String)("unhandled case:" + column.eClass().getName()), (Plugin)Activator.getDefault());
            }
        } else {
            Logger.logError((String)("unhandled case:" + column.eClass().getName()), (Plugin)Activator.getDefault());
        }
    }

    private void dropOnFeature(IStructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        if (!this.confirmMove((EObject)element, feature)) {
            return;
        }
        this.natTableWidget.getController().drop(structuredSelection, element, feature);
    }

    private boolean confirmMove(EObject eObject, EStructuralFeature feature) {
        EReference reference;
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            Object list = eObject.eGet(feature);
            boolean empty = list == null || list instanceof List && ((List)list).isEmpty();
            String message = !empty && !feature.isMany() ? Messages.NatTableDropListener_valueWillBeMovedAndPreviousLost : Messages.NatTableDropListener_valueWillBeMoved;
            String fullMessage = String.valueOf(Messages.NatTableDropListener_compositeFeature) + message;
            return MessageDialog.openConfirm(null, (String)Messages.NatTableDropListener_moveElement, (String)fullMessage);
        }
        return true;
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

