/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;

public class SshPreferencesMirror {
    private static final String PREFERENCES_NODE = "org.eclipse.jsch.core";
    public static final SshPreferencesMirror INSTANCE = new SshPreferencesMirror();
    private IEclipsePreferences preferences;
    private IEclipsePreferences.IPreferenceChangeListener listener = event -> this.reloadPreferences();
    private File sshDirectory;
    private List<String> defaultIdentities;
    private String defaultMechanisms;

    private SshPreferencesMirror() {
    }

    public void start() {
        this.preferences = InstanceScope.INSTANCE.getNode(PREFERENCES_NODE);
        if (this.preferences != null) {
            this.preferences.addPreferenceChangeListener(this.listener);
        }
        this.reloadPreferences();
    }

    public void stop() {
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPreferences() {
        SshPreferencesMirror sshPreferencesMirror = this;
        synchronized (sshPreferencesMirror) {
            this.setSshDirectory();
            this.setDefaultIdentities();
            this.setPreferredAuthentications();
        }
    }

    private String get(@NonNull String key) {
        return Platform.getPreferencesService().getString(PREFERENCES_NODE, key, null, null);
    }

    private void setSshDirectory() {
        String sshDir = this.get("SSH2HOME");
        if (sshDir != null) {
            try {
                this.sshDirectory = Paths.get(sshDir, new String[0]).toFile();
            }
            catch (InvalidPathException e) {
                Activator.logWarning(MessageFormat.format(CoreText.SshPreferencesMirror_invalidDirectory, sshDir), null);
            }
        }
        this.sshDirectory = null;
    }

    private void setDefaultIdentities() {
        String defaultKeys = this.get("PRIVATEKEY");
        if (defaultKeys == null || defaultKeys.isEmpty()) {
            this.defaultIdentities = null;
            return;
        }
        this.defaultIdentities = Arrays.asList(defaultKeys.trim().split("\\s*,\\s*")).stream().map(s -> {
            if (s.isEmpty()) {
                return null;
            }
            try {
                Paths.get(s, new String[0]);
                return s;
            }
            catch (InvalidPathException e) {
                Activator.logWarning(MessageFormat.format(CoreText.SshPreferencesMirror_invalidKeyFile, s), null);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setPreferredAuthentications() {
        String mechanisms = this.get("CVSSSH2PreferencePage.PREF_AUTH_METHODS");
        if (mechanisms == null || mechanisms.isEmpty()) {
            this.defaultMechanisms = null;
        }
        this.defaultMechanisms = mechanisms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getSshDirectory() {
        SshPreferencesMirror sshPreferencesMirror = this;
        synchronized (sshPreferencesMirror) {
            return this.sshDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Path> getDefaultIdentities(@NonNull File sshDir) {
        SshPreferencesMirror sshPreferencesMirror = this;
        synchronized (sshPreferencesMirror) {
            block4: {
                if (this.defaultIdentities != null) break block4;
                return null;
            }
            return this.defaultIdentities.stream().map(s -> new File(sshDir, (String)s).toPath()).filter(path -> Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreferredAuthentications() {
        SshPreferencesMirror sshPreferencesMirror = this;
        synchronized (sshPreferencesMirror) {
            return this.defaultMechanisms;
        }
    }
}

