/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public abstract class ValueExpression {
    public static final Integer UNKNOWN_ODA_DATA_TYPE = 0;
    protected static final String SPACE = " ";
    protected static final String LEFT_PARANTHESIS = "(";
    protected static final String RIGHT_PARANTHESIS = ")";
    protected static final String LEFT_CURLY_BRACKET = " {";
    protected static final String RIGHT_CURLY_BRACKET = "} ";
    private static final String sm_className = ValueExpression.class.getName();
    private Integer m_odaDataType;

    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public ExpressionVariable.VariableType getVariableType() {
        return ExpressionVariable.VariableType.QUERY_EXPRESSION;
    }

    public Integer getOdaDataType() {
        return this.m_odaDataType;
    }

    public void setOdaDataType(Integer odaDataType) {
        this.m_odaDataType = odaDataType;
    }

    protected static boolean isNumeric(Integer odaDataType) {
        if (odaDataType == null || odaDataType == UNKNOWN_ODA_DATA_TYPE) {
            return false;
        }
        int odaDataTypeCode = odaDataType;
        return odaDataTypeCode == 4 || odaDataTypeCode == 8 || odaDataTypeCode == 3;
    }

    protected static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public void validate() throws OdaException {
        this.validate(null);
    }

    public void validate(ValidationContext context) throws OdaException {
        try {
            this.validateSyntax(context);
            if (context != null && context.getValidator() != null) {
                context.getValidator().validate(this, context);
            }
        }
        catch (OdaException ex) {
            QuerySpecificationHelper.logValidationException(sm_className, ex);
            throw ex;
        }
    }

    public abstract void validateSyntax(ValidationContext var1) throws OdaException;

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()) + SPACE + (Object)((Object)this.getVariableType()));
        return buffer.toString();
    }
}

