/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.propertypages.ModuleProperties;
import org.eclipse.cdt.debug.internal.ui.propertypages.PropertyPageMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ModulePropertyPage
extends PropertyPage {
    private Label fTypeField;
    private Label fCPUField;
    private Label fBaseAddressField;
    private Label fSizeField;
    private Label fSymbolsField;
    protected Text fSymbolsFileField;
    protected Button fBrowseButton;
    private ModuleProperties fProperties = null;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        Font font = parent.getFont();
        composite.setFont(font);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        composite.setLayout((Layout)topLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createFields(composite);
        this.initializeFields();
        this.setValid(true);
        return composite;
    }

    protected ICModule getModule() {
        return (ICModule)this.getElement();
    }

    public boolean performOk() {
        if (this.getModuleProperties() != null && this.getModuleProperties().isDirty()) {
            final IPath path = (IPath)this.getModuleProperties().getProperty("symbolsFile");
            final ICModule module = this.getModule();
            if (module != null) {
                DebugPlugin.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            module.setSymbolsFileName(path);
                        }
                        catch (DebugException e) {
                            ModulePropertyPage.this.failed(PropertyPageMessages.getString("ModulePropertyPage.15"), e);
                        }
                    }
                });
            }
        }
        return super.performOk();
    }

    protected ModuleProperties getModuleProperties() {
        if (this.fProperties == null) {
            this.fProperties = ModuleProperties.create(this.getModule());
        }
        return this.fProperties;
    }

    protected void failed(String message, Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, message, null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), null));
        CDebugUtils.error((IStatus)ms, (Object)this.getModule());
    }

    private void createFields(Composite parent) {
        this.fTypeField = this.createField(parent, PropertyPageMessages.getString("ModulePropertyPage.0"));
        this.fCPUField = this.createField(parent, PropertyPageMessages.getString("ModulePropertyPage.4"));
        this.fBaseAddressField = this.createField(parent, PropertyPageMessages.getString("ModulePropertyPage.6"));
        this.fSizeField = this.createField(parent, PropertyPageMessages.getString("ModulePropertyPage.8"));
        this.fSymbolsField = this.createField(parent, PropertyPageMessages.getString("ModulePropertyPage.10"));
        this.createSymbolsFileField(parent);
    }

    private Label createField(Composite parent, String label) {
        Font font = parent.getFont();
        Label l = new Label(parent, 16384);
        l.setText(label);
        GridData gd = new GridData(256);
        l.setLayoutData((Object)gd);
        l.setFont(font);
        Label v = new Label(parent, 16384);
        gd = new GridData(256);
        v.setLayoutData((Object)gd);
        v.setFont(font);
        return v;
    }

    private void createSymbolsFileField(Composite parent) {
        Font font = parent.getFont();
        Label l = new Label(parent, 16384);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        l = new Label(parent, 16384);
        l.setText(PropertyPageMessages.getString("ModulePropertyPage.13"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        l.setFont(font);
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        this.fSymbolsFileField = new Text(composite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.fSymbolsFileField.setLayoutData((Object)gd);
        this.fBrowseButton = new Button(composite, 8);
        this.fBrowseButton.setText(PropertyPageMessages.getString("ModulePropertyPage.3"));
        this.fBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ModulePropertyPage.this.fBrowseButton.getShell());
                dialog.setFileName(((IPath)ModulePropertyPage.this.getModuleProperties().getProperty("symbolsFile")).toOSString());
                String fn = dialog.open();
                if (fn != null) {
                    Path path = new Path(fn);
                    ModulePropertyPage.this.fSymbolsFileField.setText(path.toOSString());
                    ModulePropertyPage.this.getModuleProperties().setProperty("symbolsFile", path);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void initializeFields() {
        Integer type = (Integer)this.getModuleProperties().getProperty("type");
        String value = PropertyPageMessages.getString("ModulePropertyPage.16");
        if (type == 1) {
            value = PropertyPageMessages.getString("ModulePropertyPage.1");
        }
        if (type == 2) {
            value = PropertyPageMessages.getString("ModulePropertyPage.2");
        }
        this.fTypeField.setText(value);
        String cpu = (String)this.getModuleProperties().getProperty("cpu");
        value = cpu != null ? cpu : PropertyPageMessages.getString("ModulePropertyPage.5");
        this.fCPUField.setText(value);
        IAddress address = (IAddress)this.getModuleProperties().getProperty("baseAddress");
        value = address != null && !address.isZero() ? address.toHexAddressString() : PropertyPageMessages.getString("ModulePropertyPage.7");
        this.fBaseAddressField.setText(value);
        Long size = (Long)this.getModuleProperties().getProperty("size");
        value = size != null && size > 0L ? size.toString() : PropertyPageMessages.getString("ModulePropertyPage.9");
        this.fSizeField.setText(value);
        Boolean loaded = (Boolean)this.getModuleProperties().getProperty("symbolsLoaded");
        value = loaded != null && loaded != false ? PropertyPageMessages.getString("ModulePropertyPage.11") : PropertyPageMessages.getString("ModulePropertyPage.12");
        this.fSymbolsField.setText(value);
        IPath path = (IPath)this.getModuleProperties().getProperty("symbolsFile");
        value = path != null ? path.toOSString() : PropertyPageMessages.getString("ModulePropertyPage.14");
        this.fSymbolsFileField.setText(value);
    }

    public void dispose() {
        if (this.getModuleProperties() != null) {
            this.getModuleProperties().dispose();
        }
        super.dispose();
    }
}

