/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFunctionMeta;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.tools.ParserTool;
import org.eclipse.bpel.validator.xpath.XPathVisitor;
import org.eclipse.bpel.xpath10.AdditiveExpr;
import org.eclipse.bpel.xpath10.BinaryExpr;
import org.eclipse.bpel.xpath10.EqualityExpr;
import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.FunctionCallExpr;
import org.eclipse.bpel.xpath10.LiteralExpr;
import org.eclipse.bpel.xpath10.LogicalExpr;
import org.eclipse.bpel.xpath10.MultiplicativeExpr;
import org.eclipse.bpel.xpath10.NumberExpr;
import org.eclipse.bpel.xpath10.RelationalExpr;
import org.eclipse.bpel.xpath10.UnaryExpr;
import org.eclipse.bpel.xpath10.VariableReferenceExpr;
import org.eclipse.bpel.xpath10.parser.XPath10Exception;
import org.eclipse.bpel.xpath10.parser.XPath10Factory;

public class XPathValidator
extends Validator {
    String exprString;
    String exprStringTrimmed;
    Expr xpathExpr;
    XPathVisitor mVisitor;
    protected String fExprByNode;
    protected INode fParentNode;

    @Override
    public void start() {
        super.start();
        this.exprString = this.mModelQuery.lookup(this.mNode, 2, null, null);
        this.exprStringTrimmed = this.exprString.trim();
        this.fParentNode = this.mNode.parentNode();
        this.fExprByNode = "text.node." + this.mNode.nodeName().getLocalPart();
    }

    @ARule(desc="XPath sanity check", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="XPATH_EMPTY_EXPRESSION")
    public void rule_SanityCheck_1() {
        if (XPathValidator.isEmptyOrWhitespace(this.exprString)) {
            IProblem problem = this.createError();
            problem.fill("XPATH_EMPTY_EXPRESSION", this.toString(this.mNode.nodeName()), this.fExprByNode);
            this.exprString = null;
            this.disableRules();
        }
    }

    @ARule(desc="XPath syntax check", author="michal.chmielewski@oracle.com", date="02/16/2007", errors="XPATH_EXPRESSION_SYNTAX")
    public void rule_CheckExpressionSyntax_2() {
        if (this.exprString == null) {
            return;
        }
        try {
            this.xpathExpr = XPath10Factory.create((String)this.exprString);
        }
        catch (XPath10Exception e) {
            IProblem problem = this.createError();
            problem.fill("XPATH_EXPRESSION_SYNTAX", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode, e.getMessage());
            this.repointOffsets(problem, e.getPosition(), e.getPosition() + 3);
            this.disableRules();
        }
    }

    protected void repointOffsets(IProblem problem, Expr expr) {
        if (expr.getPosition() < 0 || expr.getEndPosition() < 0) {
            return;
        }
        this.repointOffsets(problem, expr.getPosition(), expr.getEndPosition());
    }

    protected void repointOffsets(IProblem problem, int offset, int offsetEnd) {
        int charStart = this.mModelQuery.lookup(this.mNode, 6, -1);
        int charEnd = this.mModelQuery.lookup(this.mNode, 7, -1);
        int lineNo = this.mModelQuery.lookup(this.mNode, 4, -1);
        int columnNo = this.mModelQuery.lookup(this.mNode, 5, -1);
        if (charStart < 0 || charEnd < 0) {
            return;
        }
        charStart += offset;
        charEnd += offsetEnd;
        int i = 0;
        int j = Math.min(this.exprString.length(), offset);
        while (i < j) {
            if (this.exprString.charAt(i) == '\n') {
                ++charStart;
                if (lineNo > 0) {
                    ++lineNo;
                }
                columnNo = 0;
            }
            if (columnNo >= 0) {
                ++columnNo;
            }
            ++i;
        }
        i = 0;
        j = Math.min(this.exprString.length(), offsetEnd);
        while (i < j) {
            if (this.exprString.charAt(i) == '\n') {
                ++charEnd;
            }
            ++i;
        }
        problem.setAttribute("charStart", charStart);
        problem.setAttribute("charEnd", charEnd);
        if (lineNo > 0) {
            problem.setAttribute("lineNumber", lineNo);
        }
        if (columnNo > 0) {
            problem.setAttribute("columnNumber", columnNo);
        }
    }

    @ARule(sa=0, desc="Create the static analysis visitor for expression analysis", author="michal.chmielewski@oracle.com", date="01/30/2007", errors="XPATH_EXPRESSION_SYNTAX,XPATH_EXPRESSION_TYPE,XPATH_FN_ARGS,XPATH_FN_LITERAL_ARGS,XPATH_UNDEF_VARIABLE,XPATH_UNRESOLVED_NAMESPACE_PREFIXXPATH_INVALID_VARREF_PREFIX,XPATH_VARIABLE_PART,XPATH_UNDEF_VARIABLE_PARTXPATH_FUNCTION_MIN_ARGS,XPATH_FUNCTION_MAX_ARGS,XPATH_EMPTY_EXPRESSION", warnings="XPATH_URI_SYNTAX,XPATH_FUNCTION_UNKNOWN,XPATH_FUNCTION_DEPRECATED,XPATH_EXPRESSION_TYPE")
    public void rule_StaticXPathExpressionAnalysis_10() {
        this.mVisitor = new XPathVisitor(this);
        INode typeNode = this.getValue("expression.type", null);
        if (typeNode != null) {
            this.mVisitor.contextPush(typeNode);
        }
    }

    public void rule_ExpressionType_999999() {
        if (this.mVisitor == null) {
            return;
        }
        Object obj = this.mVisitor.contextPop();
        if (XPathVisitor.isSimpleType(obj)) {
            this.setValue("expression.value", obj);
            QName typeQName = null;
            if (obj instanceof String) {
                typeQName = new QName("http://www.w3.org/2001/XMLSchema", "string");
            } else if (obj instanceof Number) {
                Number num = (Number)obj;
                if ((double)num.intValue() == num.doubleValue()) {
                    if ((this.mNode.equals(ND_START_COUNTER_VALUE) || this.mNode.equals(ND_FINAL_COUNTER_VALUE)) && num.intValue() >= 0) {
                        typeQName = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
                    }
                    if (typeQName == null) {
                        typeQName = new QName("http://www.w3.org/2001/XMLSchema", "integer");
                    }
                } else {
                    typeQName = new QName("http://www.w3.org/2001/XMLSchema", "double");
                }
            } else if (obj instanceof Boolean) {
                typeQName = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
            }
            INode basicType = this.mModelQuery.lookup(this.mNode.rootNode(), 9, typeQName);
            if (this.isUndefined(basicType)) {
                this.setValue("expression.type", null);
            } else {
                this.setValue("expression.type", basicType);
            }
        } else if (obj instanceof INode) {
            this.setValue("expression.type", obj);
        } else {
            boolean cfr_ignored_0 = obj instanceof List;
        }
    }

    public void checkDeadlineExpression() {
        Expr expr = this.xpathExpr;
        if (expr instanceof UnaryExpr) {
            expr = ((UnaryExpr)expr).getExpr();
        }
        if (expr instanceof LiteralExpr) {
            LiteralExpr lexpr = (LiteralExpr)expr;
            try {
                ParserTool.parseDateAndTime(lexpr.getLiteral());
            }
            catch (Exception e) {
                IProblem problem = this.createError();
                problem.fill("XPATH_EXPRESSION_SYNTAX", this.toString(this.mNode.nodeName()), lexpr.getLiteral(), this.fExprByNode, e.getMessage());
                this.repointOffsets(problem, expr);
            }
        } else if (expr instanceof FunctionCallExpr) {
            this.mVisitor.visit((FunctionCallExpr)expr);
        } else {
            IProblem problem = this.createError();
            problem.fill("XPATH_EXPRESSION_TYPE", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode);
            this.repointOffsets(problem, expr);
        }
        this.disableRules();
    }

    public void checkDurationExpression() {
        Expr expr = this.xpathExpr;
        if (expr instanceof UnaryExpr) {
            expr = ((UnaryExpr)expr).getExpr();
        }
        if (expr instanceof LiteralExpr) {
            LiteralExpr lexpr = (LiteralExpr)expr;
            try {
                ParserTool.parseDuration(lexpr.getLiteral());
            }
            catch (Exception e) {
                IProblem problem = this.createError();
                problem.fill("XPATH_EXPRESSION_SYNTAX", this.toString(this.mNode.nodeName()), lexpr.getLiteral(), this.fExprByNode, e.getLocalizedMessage());
                this.repointOffsets(problem, expr);
            }
        } else if (expr instanceof FunctionCallExpr) {
            this.mVisitor.visit((FunctionCallExpr)expr);
        } else {
            IProblem problem = this.createError();
            problem.fill("XPATH_EXPRESSION_TYPE", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode);
            this.repointOffsets(problem, expr);
        }
        this.disableRules();
    }

    public void checkBooleanExpression() {
        Expr expr = this.xpathExpr;
        if (expr instanceof LogicalExpr) {
            this.mVisitor.visit((BinaryExpr)((LogicalExpr)expr));
        } else if (expr instanceof EqualityExpr) {
            this.mVisitor.visit((BinaryExpr)((EqualityExpr)expr));
        } else if (expr instanceof RelationalExpr) {
            this.mVisitor.visit((BinaryExpr)((RelationalExpr)expr));
        } else if (expr instanceof UnaryExpr && !(((UnaryExpr)expr).getExpr() instanceof FunctionCallExpr)) {
            this.mVisitor.visit((UnaryExpr)expr);
        } else {
            FunctionCallExpr fce = null;
            if (expr instanceof UnaryExpr && ((UnaryExpr)expr).getExpr() instanceof FunctionCallExpr) {
                fce = (FunctionCallExpr)((UnaryExpr)expr).getExpr();
            } else if (expr instanceof FunctionCallExpr) {
                fce = (FunctionCallExpr)expr;
            }
            if (fce != null) {
                if (!this.isBooleanFunction(fce)) {
                    IProblem problem = this.createWarning();
                    problem.fill("XPATH_EXPRESSION_TYPE", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode);
                    this.repointOffsets(problem, (Expr)fce);
                }
                this.mVisitor.visit(fce);
            } else {
                IProblem problem = this.createError();
                problem.fill("XPATH_EXPRESSION_TYPE", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode);
                this.repointOffsets(problem, expr);
            }
        }
        this.disableRules();
    }

    public void checkIntegerExpression() {
        Expr expr = this.xpathExpr;
        if (expr instanceof MultiplicativeExpr) {
            this.mVisitor.visit((BinaryExpr)((MultiplicativeExpr)expr));
        } else if (expr instanceof AdditiveExpr) {
            this.mVisitor.visit((BinaryExpr)((AdditiveExpr)expr));
        } else if (expr instanceof UnaryExpr) {
            this.mVisitor.visit((UnaryExpr)expr);
        } else if (expr instanceof NumberExpr) {
            this.mVisitor.visit((NumberExpr)expr);
        } else if (expr instanceof VariableReferenceExpr) {
            this.mVisitor.visit((VariableReferenceExpr)expr);
        } else {
            IProblem problem = this.createError();
            problem.fill("XPATH_EXPRESSION_TYPE", this.toString(this.mNode.nodeName()), this.exprStringTrimmed, this.fExprByNode);
        }
        this.disableRules();
    }

    @ARule(sa=1015, desc="Check functions in XPath expressions", author="michal.chmielewski@oracle.com", date="03/02/2007", tag="functions", order=1)
    public void checkFunctions(FunctionCallExpr expr) {
        String functionPrefix = expr.getPrefix();
        String nsURI = this.lookupNamespace(functionPrefix);
        if (XPathVisitor.isBPELNS(nsURI)) {
            this.runRules("bpel.functions", expr);
        }
        IFunctionMeta meta = this.lookup(expr);
        this.checkFunctionMeta(expr, meta);
        this.checkFunctionCall(expr, meta);
    }

    @ARule(sa=30, desc="Arguments to getVariableProperty must be quoted strings", author="michal.chmielewski@oracle.com", date="01/29/2007", tag="bpel.functions")
    public void checkGetVariableProperty(FunctionCallExpr expr) {
        INode variableNode;
        LiteralExpr p1l;
        IProblem problem;
        String fn = expr.getFunctionName();
        if (!"getVariableProperty".equals(fn)) {
            return;
        }
        List params = expr.getParameters();
        int psize = params.size();
        if (psize != 2) {
            problem = this.createError();
            int pz = params.size() - 2 < 0 ? 0 : 1;
            problem.fill("XPATH_FN_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), pz, 2);
            this.repointOffsets(problem, (Expr)expr);
            if (psize < 1) {
                return;
            }
        }
        int i = 0;
        int j = Math.min(2, params.size());
        while (i < j) {
            Expr p = (Expr)params.get(i);
            if (!(p instanceof LiteralExpr)) {
                problem = this.createError();
                problem.fill("XPATH_FN_LITERAL_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), i + 1, p.getText());
                this.repointOffsets(problem, p);
            }
            ++i;
        }
        Expr p1 = (Expr)params.get(0);
        if (p1 instanceof LiteralExpr && !this.duplicateThing("duplicate.variable.check.", (p1l = (LiteralExpr)p1).getLiteral()) && this.isUndefined(variableNode = this.mModelQuery.lookup(this.mNode, 1, p1l.getLiteral()))) {
            problem = this.createError();
            problem.fill("XPATH_UNDEF_VARIABLE", p1l.getLiteral(), expr.getText());
            this.repointOffsets(problem, (Expr)p1l);
        }
    }

    @ARule(sa=31, desc="The second argument MUST be a string literal conforming to the definition of QName in section 3", author="michal.chmielewski@oracle.com", date="01/29/2007", tag="bpel.functions")
    public void checkGetVariableProperty2ndArgument(FunctionCallExpr expr) {
        String fn = expr.getFunctionName();
        if (!"getVariableProperty".equals(fn)) {
            return;
        }
        List params = expr.getParameters();
        if (params.size() < 2 || !(params.get(1) instanceof LiteralExpr)) {
            return;
        }
        LiteralExpr p2l = (LiteralExpr)params.get(1);
        QName qname = this.mModelQuery.createQName(this.mNode, p2l.getLiteral());
        if (!this.isNamespaceOK(qname)) {
            IProblem problem = this.createError();
            problem.fill("XPATH_UNRESOLVED_NAMESPACE_PREFIX", qname.getPrefix(), qname.getLocalPart());
            this.repointOffsets(problem, (Expr)p2l);
            return;
        }
    }

    @ARule(sa=39, desc="1st arguments to doXslTransform must be quoted string", author="michal.chmielewski@oracle.com", date="01/29/2007", tag="bpel.functions")
    public void CheckDoXslTransform_10(FunctionCallExpr expr) {
        Expr p;
        IProblem problem;
        String fn = expr.getFunctionName();
        if (!"doXslTransform".equals(fn)) {
            return;
        }
        List params = expr.getParameters();
        int psize = params.size();
        if (psize < 2) {
            problem = this.createError();
            problem.fill("XPATH_FN_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), 0, 2);
            this.repointOffsets(problem, (Expr)expr);
            if (psize < 1) {
                return;
            }
        }
        if (!((p = (Expr)params.get(0)) instanceof LiteralExpr)) {
            problem = this.createError();
            problem.fill("XPATH_FN_LITERAL_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), 1, p.getText());
            this.repointOffsets(problem, p);
            return;
        }
        LiteralExpr lexpr = (LiteralExpr)p;
        try {
            new URI(lexpr.getLiteral());
        }
        catch (URISyntaxException e) {
            problem = this.createWarning();
            problem.fill("XPATH_URI_SYNTAX", this.toString(this.mNode.nodeName()), lexpr.getLiteral(), expr.getText(), e.getMessage());
            this.repointOffsets(problem, (Expr)lexpr);
        }
    }

    @ARule(sa=40, desc="There must be an even number of arguments doXslTransform", author="michal.chmielewski@oracle.com", date="01/29/2007", tag="bpel.functions")
    public void CheckDoXslTransform_11(FunctionCallExpr expr) {
        String fn = expr.getFunctionName();
        if (!"doXslTransform".equals(fn)) {
            return;
        }
        List params = expr.getParameters();
        if (params.size() < 2) {
            return;
        }
        if (params.size() % 2 != 0) {
            IProblem problem = this.createError();
            problem.fill("XPATH_FN_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), 0, 2);
            this.repointOffsets(problem, (Expr)expr);
        }
    }

    @ARule(sa=41, desc="3rd,5th,7th, etc. arguments must be QName strings", author="michal.chmielewski@oracle.com", date="01/29/2007", tag="bpel.functions")
    public void CheckDoXslTransform_15(FunctionCallExpr expr) {
        String fn = expr.getFunctionName();
        if (!"doXslTransform".equals(fn)) {
            return;
        }
        List params = expr.getParameters();
        if (params.size() < 3) {
            return;
        }
        int i = 2;
        int j = params.size();
        while (i < j) {
            IProblem problem;
            Expr p = (Expr)params.get(i);
            if (p instanceof LiteralExpr) {
                LiteralExpr p2l = (LiteralExpr)p;
                QName qname = this.mModelQuery.createQName(this.mNode, p2l.getLiteral());
                if (!this.isNamespaceOK(qname)) {
                    problem = this.createError();
                    problem.fill("XPATH_UNRESOLVED_NAMESPACE_PREFIX", qname.getPrefix(), qname.getLocalPart());
                    this.repointOffsets(problem, p);
                }
            } else {
                problem = this.createError();
                problem.fill("XPATH_FN_LITERAL_ARGS", this.toString(this.mNode.nodeName()), fn, expr.getText(), i + 1, p.getText());
                this.repointOffsets(problem, p);
            }
            i += 2;
        }
    }

    @ARule(sa=0, desc="Check the variable namespace prefix", author="michal.chmielewski@oracle.com", date="01/30/2007", tag="variables", errors="XPATH_INVALID_VARREF_PREFIX")
    public void rule_CheckVariable_10(VariableReferenceExpr expr) {
        String partName;
        String varName;
        int i;
        IProblem problem;
        if (this.isJoinCondition()) {
            return;
        }
        String prefix = expr.getPrefix();
        String name = expr.getVariableName();
        if (!XPathValidator.isEmpty(prefix)) {
            if (this.duplicateThing("duplicate.variable.check.", name)) {
                return;
            }
            problem = this.createError();
            problem.fill("XPATH_INVALID_VARREF_PREFIX", String.valueOf(prefix) + ":" + name);
        }
        if ((i = name.indexOf(46)) < 0) {
            varName = name;
            partName = null;
        } else {
            varName = name.substring(0, i);
            partName = name.substring(i + 1);
        }
        INode variable = this.mModelQuery.lookup(this.mNode, 1, varName);
        if (this.isUndefined(variable)) {
            if (this.duplicateThing("duplicate.variable.check.", name)) {
                return;
            }
            problem = this.createError();
            problem.fill("XPATH_UNDEF_VARIABLE", varName, expr.getText());
            this.repointOffsets(problem, (Expr)expr);
            this.mVisitor.contextPush(Collections.EMPTY_LIST);
            return;
        }
        INode varTypeNode = this.getValue(variable, "type", null);
        if (this.hasProblems(variable) || this.isUndefined(varTypeNode)) {
            this.mVisitor.contextPush(Collections.EMPTY_LIST);
            return;
        }
        this.mVisitor.contextPush(Collections.EMPTY_LIST);
        INode variablePart = null;
        if (partName != null) {
            variablePart = this.mModelQuery.lookup(varTypeNode, 16, partName);
        }
        if (partName != null) {
            if (!WSDL_ND_MESSAGE.equals(varTypeNode.nodeName())) {
                if (this.duplicateThing("duplicate.variable.check.", name)) {
                    return;
                }
                problem = this.createError();
                problem.fill("XPATH_VARIABLE_PART", varName, partName, expr.getText(), 0);
                this.repointOffsets(problem, (Expr)expr);
            } else if (this.isUndefined(variablePart)) {
                if (this.duplicateThing("duplicate.variable.check.", name)) {
                    return;
                }
                problem = this.createError();
                problem.fill("XPATH_UNDEF_VARIABLE_PART", varName, partName, expr.getText());
                this.repointOffsets(problem, (Expr)expr);
            } else {
                this.mVisitor.contextPop();
                this.mVisitor.contextPush(variablePart);
            }
        } else if (WSDL_ND_MESSAGE.equals(varTypeNode.nodeName())) {
            if (this.duplicateThing("duplicate.variable.check.", name)) {
                return;
            }
            problem = this.createError();
            problem.fill("XPATH_VARIABLE_PART", varName, "text.term.unspecified", expr.getText(), 1);
            this.repointOffsets(problem, (Expr)expr);
        } else {
            this.mVisitor.contextPop();
            this.mVisitor.contextPush(varTypeNode);
        }
    }

    boolean isNamespaceOK(QName qname) {
        if (qname == null) {
            return false;
        }
        return XPathValidator.isEmpty(qname.getNamespaceURI()) == XPathValidator.isEmpty(qname.getPrefix());
    }

    protected boolean isJoinCondition() {
        return ND_JOIN_CONDITION.equals(this.mNode.nodeName());
    }

    protected IModelQuery getModelQuery() {
        return this.mModelQuery;
    }

    protected INode getNode() {
        return this.mNode;
    }

    @Override
    protected IProblem createError() {
        return super.createError();
    }

    @Override
    protected IProblem createInfo() {
        return super.createInfo();
    }

    @Override
    protected IProblem createWarning() {
        return super.createWarning();
    }

    @Override
    protected void runRules(String tag, Object ... args) {
        super.runRules(tag, args);
    }

    protected boolean duplicateThing(String ... args) {
        String key = null;
        if (args.length == 1) {
            key = args[0];
        } else {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                sb.append(a);
                ++n2;
            }
            key = sb.toString();
        }
        if (this.containsValueKey(key)) {
            return true;
        }
        this.setValue(key, Boolean.TRUE);
        return false;
    }

    protected boolean checkPrefix(String prefix, String name) {
        if (XPathValidator.isEmptyOrWhitespace(prefix)) {
            return true;
        }
        String nsURI = this.lookupNamespace(prefix);
        if (XPathValidator.isEmpty(nsURI)) {
            IProblem problem = this.createError();
            problem.fill("XPATH_UNRESOLVED_NAMESPACE_PREFIX", prefix, name);
            return false;
        }
        return true;
    }

    protected String lookupNamespace(String prefix) {
        return this.mModelQuery.lookup(this.mNode, 0, prefix, null);
    }

    boolean isBooleanFunction(FunctionCallExpr functionExpr) {
        IFunctionMeta meta = this.lookup(functionExpr);
        if (meta == null) {
            return false;
        }
        return meta.getReturnType() == Boolean.class;
    }

    protected void checkFunctionMeta(FunctionCallExpr functionExpr, IFunctionMeta meta) {
        String fnCall = functionExpr.getFunctionName();
        if (!XPathValidator.isEmptyOrWhitespace(functionExpr.getPrefix())) {
            fnCall = String.valueOf(functionExpr.getPrefix()) + ":" + fnCall;
        }
        if (this.duplicateThing("function.meta.", fnCall)) {
            return;
        }
        if (meta == null) {
            IProblem problem = this.createWarning();
            problem.fill("XPATH_FUNCTION_UNKNOWN", this.toString(this.mNode.nodeName()), fnCall);
            this.repointOffsets(problem, (Expr)functionExpr);
            return;
        }
        if (meta.isDeprecated()) {
            IProblem problem = this.createWarning();
            problem.fill("XPATH_FUNCTION_DEPRECATED", this.toString(this.mNode.nodeName()), fnCall, meta.getDeprecateComment());
            this.repointOffsets(problem, (Expr)functionExpr);
        }
    }

    protected void checkFunctionCall(FunctionCallExpr functionExpr, IFunctionMeta meta) {
        IProblem problem;
        List params;
        if (meta == null || functionExpr == null) {
            return;
        }
        String fnCall = functionExpr.getFunctionName();
        if (!XPathValidator.isEmptyOrWhitespace(functionExpr.getPrefix())) {
            fnCall = String.valueOf(functionExpr.getPrefix()) + ":" + fnCall;
        }
        if ((params = functionExpr.getParameters()).size() < meta.getMinArity()) {
            problem = this.createError();
            problem.fill("XPATH_FUNCTION_MIN_ARGS", this.toString(this.mNode.nodeName()), fnCall, meta.getMinArity(), params.size());
            this.repointOffsets(problem, (Expr)functionExpr);
        }
        if (params.size() > meta.getMaxArity()) {
            problem = this.createError();
            problem.fill("XPATH_FUNCTION_MAX_ARGS", this.toString(this.mNode.nodeName()), fnCall, meta.getMaxArity(), params.size());
        }
    }

    protected IFunctionMeta lookup(FunctionCallExpr functionExpr) {
        String ns = null;
        ns = XPathValidator.isEmptyOrWhitespace(functionExpr.getPrefix()) ? "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" : this.lookupNamespace(functionExpr.getPrefix());
        return this.mModelQuery.lookupFunction("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", ns, functionExpr.getFunctionName());
    }
}

