/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CPartnerActivityValidator;

public class ReceiveValidator
extends CPartnerActivityValidator {
    protected INode fMyRoleNode;
    protected INode fVariable;
    protected INode fPortTypeFromRole;
    protected String fCreateInstance;
    protected int fFromPartsCount;
    protected String fVariableName;
    INode fInputMessage;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.fFromPartsCount = this.checkChild(ND_FROM_PARTS, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
    }

    @ARule(desc="Check variable on receive activity", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_LookupVariable_1() {
        this.fVariableName = this.getAttribute(this.mNode, AT_VARIABLE, 1, Filters.NC_NAME, false);
        if (!ReceiveValidator.isEmpty(this.fVariableName)) {
            this.fVariable = this.mModelQuery.lookup(this.mNode, 1, this.fVariableName);
        }
        this.fPartnerLinkType = null;
        this.fMyRoleNode = null;
    }

    @ARule(desc="Check createInstance attribute on receive activity.", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckCreateInstanceSetting_2() {
        this.fCreateInstance = this.getAttribute(this.mNode, AT_CREATE_INSTANCE, 1, Filters.BOOLEAN_FILTER, false);
        if (ReceiveValidator.isEmpty(this.fCreateInstance)) {
            this.fCreateInstance = "no";
        }
    }

    @ARule(sa=56, desc="Check if this 'start' <receive> activity is positioned correctly", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__START_ACTIVITY")
    public void rule_CheckIfStartActivity_3() {
        if ("no".equals(this.fCreateInstance)) {
            return;
        }
        this.checkStartActivityPositioning();
        List starts = this.getValue(this.mNode.rootNode(), "start.activities", null);
        starts.add(this.mNode);
    }

    @ARule(sa=2003, desc="Check if inputVariable is set and exists and is defined correctly.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckVariable_3() {
        this.fVariable = this.verifyVariable(this.fVariable, AT_VARIABLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if partner role is defined in receive activity.", errors="BPELC_MISSING_ROLE")
    public void rule_CheckIfMyRoleIsDefined_5() {
        this.fMyRoleNode = this.lookupRoleNode(this.fPartnerLinkNode, AT_MY_ROLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks portType and derived portType values on receive activity.", sa=5, errors="BPELC_MISMATCH_ROLE_PORT_TYPE")
    public void rule_CheckRolePortTypeWithReceivePortType_10() {
        this.fPortTypeFromRole = this.verifyPortTypeFromRole(this.fMyRoleNode, AT_MY_ROLE, this.fPortType);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if input messages is defined for receive activity.", errors="BPELC_PA__NO_MESSAGE,BPELC_PA__MSG_TYPE")
    public void rule_CheckInputMessage_12() {
        this.fInputMessage = this.findMessageType(this.fPortTypeFromRole, this.fOperation, WSDL_ND_INPUT, true);
        this.setValue("input.message.type", this.fInputMessage);
    }

    @ARule(sa=58, desc="Check message type compatability on receive", author="michal.chmielewski@oracle.com", date="02/22/2007", errors="BPELC_PA__MESSAGE_TYPE_MISMATCH")
    public void rule_CheckVariableAndMessageStructureCompatibility_20() {
        if (this.isUndefined(this.fInputMessage) || this.isUndefined(this.fVariable)) {
            return;
        }
        INode varType = this.getValue(this.fVariable, "type", null);
        if (this.isUndefined(varType)) {
            return;
        }
        if (!this.mModelQuery.check(3, varType, this.fInputMessage)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PA__MESSAGE_TYPE_MISMATCH", this.toString(this.mNode.nodeName()), AT_VARIABLE, this.fVariable.getAttribute(AT_NAME), this.fInputMessage, varType);
        }
    }

    @ARule(sa=55, desc="Check to see if fromPart is specified; if so then  variable must not be used on the receive.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__PA_PARTS")
    public void rule_checkFromPartsPresence_50() {
        List<INode> fFromParts = mSelector.selectNodes(this.mNode, ND_FROM_PARTS, ND_FROM_PART);
        if (fFromParts.size() > 0 && !ReceiveValidator.isEmptyOrWhitespace(this.mNode.getAttribute(AT_VARIABLE))) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), this.toString(ND_FROM_PART), AT_VARIABLE, 1);
        }
    }
}

