/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class AreaFigure
extends Figure {
    private static final int LINE_STYLE = 4;
    private static final Insets DEFAULT_EXPAND = new Insets(2, 2, 2, 2);
    private static final int inset = 5;

    public AreaFigure() {
        this.setOpaque(false);
        this.setBorder((Border)new MarginBorder(5));
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle rect = this.getClientArea().expand(DEFAULT_EXPAND);
        Color forecolor = graphics.getForegroundColor();
        if (this.getBackgroundColor().equals((Object)ColorConstants.blue)) {
            graphics.fillRectangle(rect);
        }
        graphics.setForegroundColor(ReportColorConstants.MarginBorderColor);
        this.drawLine(graphics, rect, 16384, 4);
        this.drawLine(graphics, rect, 128, 4);
        this.drawLine(graphics, rect, 131072, 4);
        this.drawLine(graphics, rect, 1024, 4);
        graphics.setForegroundColor(forecolor);
    }

    private void drawLine(Graphics graphics, Rectangle rect, int position, int lineStyle) {
        graphics.setLineStyle(lineStyle);
        switch (position) {
            case 16384: {
                graphics.drawLine(rect.x, rect.y, rect.x, rect.bottom());
                break;
            }
            case 128: {
                graphics.drawLine(rect.x, rect.y, rect.right(), rect.y);
                break;
            }
            case 131072: {
                graphics.drawLine(rect.right(), rect.y, rect.right(), rect.bottom());
                break;
            }
            case 1024: {
                graphics.drawLine(rect.x, rect.bottom(), rect.right(), rect.bottom());
            }
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        this.validate();
        return super.getPreferredSize(wHint, hHint);
    }
}

