/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.reorder.command;

import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

public class ColumnReorderCommand
implements ILayerCommand {
    private ColumnPositionCoordinate fromColumnPositionCoordinate;
    private ColumnPositionCoordinate toColumnPositionCoordinate;

    public ColumnReorderCommand(ILayer layer, int fromColumnPosition, int toColumnPosition) {
        this.fromColumnPositionCoordinate = new ColumnPositionCoordinate(layer, fromColumnPosition);
        this.toColumnPositionCoordinate = new ColumnPositionCoordinate(layer, toColumnPosition);
    }

    protected ColumnReorderCommand(ColumnReorderCommand command) {
        this.fromColumnPositionCoordinate = command.fromColumnPositionCoordinate;
        this.toColumnPositionCoordinate = command.toColumnPositionCoordinate;
    }

    public int getFromColumnPosition() {
        return this.fromColumnPositionCoordinate.getColumnPosition();
    }

    public int getToColumnPosition() {
        return this.toColumnPositionCoordinate.getColumnPosition();
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.fromColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.fromColumnPositionCoordinate, targetLayer);
        this.toColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.toColumnPositionCoordinate, targetLayer);
        return this.fromColumnPositionCoordinate != null && this.toColumnPositionCoordinate != null;
    }

    public ColumnReorderCommand cloneCommand() {
        return new ColumnReorderCommand(this);
    }
}

