/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.ease;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.pushingpixels.trident.ease.LengthItem;
import org.pushingpixels.trident.ease.TimelineEase;

public class Spline
implements TimelineEase {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private ArrayList lengths = new ArrayList();

    public Spline(float easeAmount) {
        this(easeAmount, 0.0f, 1.0f - easeAmount, 1.0f);
    }

    public Spline(float x1, float y1, float x2, float y2) {
        if (x1 < 0.0f || x1 > 1.0f || y1 < 0.0f || y1 > 1.0f || x2 < 0.0f || x2 > 1.0f || y2 < 0.0f || y2 > 1.0f) {
            throw new IllegalArgumentException("Control points must be in the range [0, 1]:");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        float prevX = 0.0f;
        float prevY = 0.0f;
        float prevLength = 0.0f;
        float t = 0.01f;
        while (t <= 1.0f) {
            Point2D.Float xy = this.getXY(t);
            float length = prevLength + (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            LengthItem lengthItem = new LengthItem(length, t);
            this.lengths.add(lengthItem);
            prevLength = length;
            prevX = xy.x;
            prevY = xy.y;
            t += 0.01f;
        }
        int i = 0;
        while (i < this.lengths.size()) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i);
            lengthItem.setFraction(prevLength);
            ++i;
        }
    }

    private Point2D.Float getXY(float t) {
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        Point2D.Float xy = new Point2D.Float(b1 * this.x1 + b2 * this.x2 + b3, b1 * this.y1 + b2 * this.y2 + b3);
        return xy;
    }

    private float getY(float t) {
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        return b1 * this.y1 + b2 * this.y2 + b3;
    }

    public float map(float lengthFraction) {
        float interpolatedT = 1.0f;
        float prevT = 0.0f;
        float prevLength = 0.0f;
        int i = 0;
        while (i < this.lengths.size()) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i);
            float fraction = lengthItem.getFraction();
            float t = lengthItem.getT();
            if (lengthFraction <= fraction) {
                float proportion = (lengthFraction - prevLength) / (fraction - prevLength);
                interpolatedT = prevT + proportion * (t - prevT);
                return this.getY(interpolatedT);
            }
            prevLength = fraction;
            prevT = t;
            ++i;
        }
        return this.getY(interpolatedT);
    }
}

