/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernel;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class KernelThreadInformationProvider {
    private static final Predicate<ITmfStateValue> IS_STATE_VALUE_ACTIVE = stateValue -> !stateValue.isNull() && !stateValue.equals(ProcessStatus.UNKNOWN.getStateValue()) && !stateValue.equals(ProcessStatus.WAIT_BLOCKED.getStateValue()) && !stateValue.equals(ProcessStatus.WAIT_UNKNOWN.getStateValue());

    private KernelThreadInformationProvider() {
    }

    public static @Nullable Integer getThreadOnCpu(KernelAnalysisModule module, long cpuId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            int cpuQuark = ss.getQuarkAbsolute(new String[]{"CPUs", Long.toString(cpuId), "Current_thread"});
            ITmfStateInterval interval = ss.querySingleState(ts, cpuQuark);
            ITmfStateValue val = interval.getStateValue();
            if (val.getType().equals((Object)ITmfStateValue.Type.INTEGER)) {
                return val.unboxInt();
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static @Nullable Set<Integer> getThreadsOfCpus(KernelAnalysisModule module, Collection<Long> cpus, long rangeStart, long rangeEnd) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        ImmutableSet uniqueCpus = ImmutableSet.copyOf(cpus);
        int threadsQuark = ss.optQuarkAbsolute(new String[]{"Threads"});
        if (threadsQuark == -2) {
            return null;
        }
        List threadQuarks = ss.getSubAttributes(threadsQuark, false);
        return threadQuarks.stream().filter(arg_0 -> KernelThreadInformationProvider.lambda$1(ss, rangeStart, rangeEnd, (Set)uniqueCpus, arg_0)).map(arg_0 -> ((ITmfStateSystem)ss).getAttributeName(arg_0)).filter(attribName -> !attribName.startsWith("0_")).map(Integer::valueOf).collect(Collectors.toSet());
    }

    public static Set<Integer> getActiveThreadsForRange(KernelAnalysisModule module, long rangeStart, long rangeEnd) {
        List fullQueryAtStart;
        long end;
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return Collections.emptySet();
        }
        long start = Math.max(rangeStart, ss.getStartTime());
        if (start > (end = Math.min(rangeEnd, ss.getCurrentEndTime()))) {
            return Collections.emptySet();
        }
        int threadsQuark = ss.optQuarkAbsolute(new String[]{"Threads"});
        if (threadsQuark == -2) {
            return Collections.emptySet();
        }
        try {
            fullQueryAtStart = ss.queryFullState(start);
        }
        catch (StateSystemDisposedException e) {
            return Collections.emptySet();
        }
        List threadQuarks = ss.getSubAttributes(threadsQuark, false);
        return threadQuarks.stream().filter(threadQuark -> {
            ITmfStateInterval intervalAtStart = (ITmfStateInterval)fullQueryAtStart.get((int)threadQuark);
            if (IS_STATE_VALUE_ACTIVE.test(intervalAtStart.getStateValue())) {
                return true;
            }
            if (intervalAtStart.getEndTime() >= end) {
                return false;
            }
            StateSystemUtils.QuarkIterator it = new StateSystemUtils.QuarkIterator(ss, threadQuark.intValue(), start, end);
            while (it.hasNext()) {
                ITmfStateInterval interval = it.next();
                if (!IS_STATE_VALUE_ACTIVE.test(interval.getStateValue())) continue;
                return true;
            }
            return false;
        }).map(arg_0 -> ((ITmfStateSystem)ss).getAttributeName(arg_0)).filter(attribName -> !attribName.startsWith("0_")).map(Integer::parseInt).collect(Collectors.toSet());
    }

    public static Collection<Integer> getThreadIds(KernelAnalysisModule module) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return Collections.emptySet();
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads"});
            TreeSet<@NonNull Integer> tids = new TreeSet<Integer>();
            for (Integer quark : ss.getSubAttributes(threadQuark, false)) {
                @NonNull String attributeName = ss.getAttributeName(quark.intValue());
                tids.add(attributeName.startsWith("0_") ? 0 : Integer.parseInt(attributeName));
            }
            return tids;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return Collections.emptySet();
        }
    }

    public static @Nullable Integer getParentPid(KernelAnalysisModule module, Integer threadId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            Integer ppidNode = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "PPID"});
            ITmfStateInterval ppidInterval = ss.querySingleState(ts, ppidNode.intValue());
            ITmfStateValue ppidValue = ppidInterval.getStateValue();
            if (ppidValue.getType().equals((Object)ITmfStateValue.Type.INTEGER)) {
                return ppidValue.unboxInt();
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static @Nullable Integer getProcessId(KernelAnalysisModule module, Integer threadId, long ts) {
        int pidNode;
        ITmfStateSystem ss;
        block6: {
            ss = module.getStateSystem();
            if (ss == null) {
                return null;
            }
            pidNode = ss.optQuarkAbsolute(new String[]{"Threads", threadId.toString()});
            if (pidNode != -2) break block6;
            return null;
        }
        try {
            pidNode = ss.optQuarkRelative(pidNode, new String[]{"PID"});
            if (pidNode == -2) {
                return threadId;
            }
            ITmfStateInterval pidInterval = ss.querySingleState(ts, pidNode);
            Object pid = pidInterval.getValue();
            if (pid instanceof Integer) {
                return (Integer)pid;
            }
        }
        catch (StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static @Nullable String getExecutableName(KernelAnalysisModule module, Integer threadId) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        int execNameNode = ss.optQuarkAbsolute(new String[]{"Threads", threadId.toString(), "Exec_name"});
        if (execNameNode == -2) {
            return null;
        }
        StateSystemUtils.QuarkIterator reversedIterator = new StateSystemUtils.QuarkIterator(ss, execNameNode, ss.getCurrentEndTime());
        while (reversedIterator.hasPrevious()) {
            ITmfStateValue nameInterval = reversedIterator.previous().getStateValue();
            if (nameInterval.getType() != ITmfStateValue.Type.STRING) continue;
            return nameInterval.unboxStr();
        }
        return null;
    }

    public static int getThreadPriority(KernelAnalysisModule module, int threadId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return -1;
        }
        int prioQuark = ss.optQuarkAbsolute(new String[]{"Threads", String.valueOf(threadId), "Prio"});
        if (prioQuark == -2) {
            return -1;
        }
        try {
            return ss.querySingleState(ts, prioQuark).getStateValue().unboxInt();
        }
        catch (StateSystemDisposedException e) {
            return -1;
        }
    }

    public static List<ITmfStateInterval> getStatusIntervalsForThread(KernelAnalysisModule module, Integer threadId, long start, long end, long resolution, IProgressMonitor monitor) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString()});
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)threadQuark, (long)Math.max(start, ss.getStartTime()), (long)Math.min(end - 1L, ss.getCurrentEndTime()), (long)resolution, (IProgressMonitor)monitor);
            return statusIntervals;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            return Collections.emptyList();
        }
    }

    @Deprecated
    public static Iterator<ITmfStateInterval> getStatusIntervalsForThread(KernelAnalysisModule module, Integer threadId, long start, long end) {
        return KernelThreadInformationProvider.getStatusIntervalsForThread(module, threadId, start, end, -1L);
    }

    public static Iterator<ITmfStateInterval> getStatusIntervalsForThread(KernelAnalysisModule module, Integer threadId, long start, long end, long resolution) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return (Iterator)NonNullUtils.checkNotNull(Collections.emptyListIterator());
        }
        int threadQuark = ss.optQuarkAbsolute(new String[]{"Threads", threadId.toString()});
        if (threadQuark == -2) {
            return (Iterator)NonNullUtils.checkNotNull(Collections.emptyListIterator());
        }
        return new StateSystemUtils.QuarkIterator(ss, threadQuark, start, end - 1L, resolution);
    }

    private static /* synthetic */ boolean lambda$1(ITmfStateSystem iTmfStateSystem, long l, long l2, Set set, Integer threadQuark) {
        int threadCurrentCpuQuark = iTmfStateSystem.optQuarkRelative(threadQuark.intValue(), new String[]{"Current_cpu_rq"});
        if (threadCurrentCpuQuark == -2) {
            return false;
        }
        StateSystemUtils.QuarkIterator it = new StateSystemUtils.QuarkIterator(iTmfStateSystem, threadCurrentCpuQuark, l, l2);
        while (it.hasNext()) {
            Object o = it.next().getValue();
            if (!(o instanceof Number) || !set.contains(((Number)o).longValue())) continue;
            return true;
        }
        return false;
    }
}

