/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal;

import java.util.Collection;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.scout.sdk.core.util.OptimisticLock;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalPopup;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextEx;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.util.NormalizedPattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProposalTextField
extends TextField {
    public static final int TYPE_INITIAL_SHOW_POPUP = 1024;
    private Button m_popupButton;
    private ProposalPopup m_popup;
    private P_ProposalFieldListener m_proposalFieldListener;
    private IProposalPopupListener m_popupListener;
    private Object m_selectedProposal = null;
    private Object m_input;
    private final EventListenerList m_eventListeners = new EventListenerList();
    private final OptimisticLock m_updateLock = new OptimisticLock();
    private final OptimisticLock m_focusLock = new OptimisticLock();

    public ProposalTextField(Composite parent) {
        this(parent, 1);
    }

    public ProposalTextField(Composite parent, int type) {
        this(parent, type, 150);
    }

    public ProposalTextField(Composite parent, int type, int labelWidth) {
        super(parent, type, labelWidth);
    }

    protected void setInput(Object input) {
        this.m_input = input;
        ProposalPopup.SearchPatternInput searchPatternInput = new ProposalPopup.SearchPatternInput(input, this.getText());
        this.m_popup.setInput(searchPatternInput);
    }

    protected Object getInput() {
        return this.m_input;
    }

    public void setContentProvider(IProposalContentProvider provider) {
        if (!Objects.equals(provider, this.m_popup.getContentProvider())) {
            this.m_popup.setContentProvider(provider);
            this.acceptProposal(null);
        }
    }

    public IContentProvider getContentProvider() {
        return this.m_popup.getContentProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.m_popup.setLabelProvider(labelProvider);
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.m_popup.getLabelProvider();
    }

    protected void attachProposalListener(StyledText textComponent) {
        if (this.m_proposalFieldListener == null) {
            this.m_proposalFieldListener = new P_ProposalFieldListener();
            textComponent.addListener(1, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(2, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(24, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(16, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(15, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(31, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(4, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(25, (Listener)this.m_proposalFieldListener);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProposalTextField.this.m_popup.dispose();
            }
        });
        this.m_popupButton = new Button(parent, 0x800008);
        this.m_popupButton.setImage(S2ESdkUiActivator.getImage("down.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ProposalTextField.this.m_updateLock.acquire()) {
                        if (ProposalTextField.this.m_popup.isVisible()) {
                            ProposalTextField.this.closePopup();
                        } else {
                            ProposalTextField.this.getTextComponent().setSelection(0);
                            ProposalTextField.this.getTextComponent().setFocus();
                            ProposalTextField.this.updateProposals();
                        }
                    }
                }
                finally {
                    ProposalTextField.this.m_updateLock.release();
                }
            }
        });
        StyledTextEx text = this.getTextComponent();
        parent.setTabList(new Control[]{text});
        this.m_popup = new ProposalPopup(this.getTextComponent());
        this.m_popupListener = new P_PopupListener();
        this.m_popup.addPopupListener(this.m_popupListener);
        this.attachProposalListener(this.getTextComponent());
        FormData textData = (FormData)text.getLayoutData();
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    public void addProposalListener(IProposalListener listener) {
        this.m_eventListeners.add(IProposalListener.class, listener);
    }

    public void removeProposalAdapterListener(IProposalListener listener) {
        this.m_eventListeners.remove(IProposalListener.class, listener);
    }

    protected void notifyAcceptProposal(Object proposal) {
        IProposalListener[] iProposalListenerArray = (IProposalListener[])this.m_eventListeners.getListeners(IProposalListener.class);
        int n = iProposalListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalListener l = iProposalListenerArray[n2];
            l.proposalAccepted(proposal);
            ++n2;
        }
    }

    public void acceptProposal(Object proposal) {
        this.acceptProposal(proposal, false, true);
    }

    public synchronized void acceptProposal(Object proposal, boolean onlyAcceptExistingProposals, boolean closeProposalPopup) {
        if (proposal != null) {
            if (onlyAcceptExistingProposals && !this.isProposalPresent(proposal)) {
                proposal = null;
            }
            try {
                if (this.m_updateLock.acquire()) {
                    String text = proposal != null ? this.m_popup.getText(proposal) : "";
                    if (this.getTextComponent() != null) {
                        this.getTextComponent().setText(text);
                        this.getTextComponent().setSelection(text.length());
                    }
                }
            }
            finally {
                this.m_updateLock.release();
            }
        }
        if (!Objects.equals(this.m_selectedProposal, proposal)) {
            this.m_selectedProposal = proposal;
            this.setInput(proposal);
            this.notifyAcceptProposal(this.m_selectedProposal);
        }
        if (closeProposalPopup) {
            this.closePopup();
        }
    }

    protected boolean isProposalPresent(Object proposal) {
        IProposalContentProvider contentProvider = this.m_popup.getContentProvider();
        IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
        Collection<Object> proposals = null;
        try {
            proposals = contentProvider.getProposals(NormalizedPattern.build(null), monitor);
        }
        finally {
            monitor.done();
        }
        if (proposals == null || proposals.isEmpty()) {
            return false;
        }
        for (Object o : proposals) {
            if (!Objects.equals(o, proposal)) continue;
            return true;
        }
        return false;
    }

    private synchronized void acceptProposalInternal(Object proposal, boolean closeProposalPopup) {
        if (proposal instanceof ISeparatorProposal) {
            return;
        }
        this.acceptProposal(proposal, false, closeProposalPopup);
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_popup.setProposalDescriptionProvider(proposalDescriptionProvider);
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_popup.getProposalDescriptionProvider();
    }

    @Override
    public void setText(String text) {
        try {
            if (this.m_updateLock.acquire()) {
                if (text == null) {
                    text = "";
                }
                super.setText(text);
            }
        }
        finally {
            this.m_updateLock.release();
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(editable);
        }
    }

    @Override
    public boolean getEditable() {
        boolean editable = super.getEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public boolean isEditable() {
        boolean editable = super.isEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(enabled);
        }
    }

    @Override
    public boolean getEnabled() {
        boolean enabled = super.getEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = super.isEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    protected synchronized void closePopup() {
        if (this.m_popup.getShell() != null && !this.m_popup.getShell().isDisposed()) {
            this.m_popup.close();
        }
    }

    private synchronized void updateProposals() {
        String pattern = this.getText();
        int index = this.getSelection().x;
        if (index >= 0 && index < pattern.length()) {
            pattern = pattern.substring(0, index);
        }
        this.m_popup.updatePattern(pattern, this.getInput());
        if (!this.m_popup.isVisible()) {
            this.m_popup.open();
        }
    }

    private synchronized void textModified() {
        this.updateProposals();
    }

    protected boolean isProposalFieldFocusOwner() {
        if (this.m_popup != null && this.m_popup.getShell() != null && !this.m_popup.getShell().isDisposed()) {
            if (this.m_popup.isFocusOwner()) {
                return true;
            }
            Shell[] shells = this.m_popup.getShell().getShells();
            if (shells != null && shells.length > 0) {
                return true;
            }
        }
        if (this.getTextComponent() != null && !this.getTextComponent().isDisposed() && this.getTextComponent().isFocusControl()) {
            return true;
        }
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            return this.m_popupButton.isFocusControl();
        }
        return false;
    }

    public synchronized Object getSelectedProposal() {
        return this.m_selectedProposal;
    }

    private class P_PopupListener
    implements IProposalPopupListener {
        private P_PopupListener() {
        }

        @Override
        public void popupChanged(ProposalPopupEvent event) {
            switch (event.getType()) {
                case 2: {
                    try {
                        Control[] siblings;
                        ProposalTextField.this.m_focusLock.acquire();
                        boolean moveFocus = (Boolean)event.getData("moveFocus");
                        ProposalTextField.this.acceptProposalInternal(event.getData("selectedProposal"), moveFocus);
                        if (!moveFocus || (siblings = ProposalTextField.this.getParent().getChildren())[siblings.length - 1] == ProposalTextField.this) break;
                        ProposalTextField.this.getTextComponent().traverse(16);
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_focusLock.release();
                    }
                }
                case 16: {
                    ProposalTextField.this.updateProposals();
                    break;
                }
            }
        }
    }

    private class P_ProposalFieldListener
    implements Listener {
        private P_ProposalFieldListener() {
        }

        private boolean equalsIgnoreCase(String a, String b) {
            if (a == b) {
                return true;
            }
            if (a == null) {
                return false;
            }
            if (b == null) {
                return false;
            }
            return a.equalsIgnoreCase(b);
        }

        public void handleEvent(Event event) {
            block1 : switch (event.type) {
                case 24: {
                    try {
                        if (!ProposalTextField.this.m_updateLock.acquire()) break;
                        ProposalTextField.this.textModified();
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_updateLock.release();
                    }
                }
                case 25: {
                    if (!"\t".equals(event.text)) break;
                    event.doit = false;
                    break;
                }
                case 1: {
                    if (event.keyCode == 32 && (event.stateMask & 0x40000) == 262144) {
                        if (!ProposalTextField.this.m_popup.isVisible()) {
                            ProposalTextField.this.updateProposals();
                            break;
                        }
                        ProposalTextField.this.m_popup.setFocus();
                        break;
                    }
                    if (event.keyCode != 0x1000007 && event.keyCode != 0x1000008) break;
                    ProposalTextField.this.textModified();
                    break;
                }
                case 2: {
                    switch (event.keyCode) {
                        case 27: {
                            ProposalTextField.this.closePopup();
                            event.doit = false;
                            break block1;
                        }
                        case 0x1000002: {
                            if (!ProposalTextField.this.m_popup.isVisible()) {
                                ProposalTextField.this.updateProposals();
                                break block1;
                            }
                            ProposalTextField.this.m_popup.setFocus();
                            break block1;
                        }
                        case 0x1000003: 
                        case 0x1000004: {
                            ProposalTextField.this.textModified();
                            break block1;
                        }
                    }
                    break;
                }
                case 16: {
                    ProposalTextField.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ProposalTextField.this.m_popupButton != null && !ProposalTextField.this.m_popupButton.isDisposed() && ProposalTextField.this.m_popupButton.equals(ProposalTextField.this.getDisplay().getFocusControl())) {
                                return;
                            }
                            if (!ProposalTextField.this.isProposalFieldFocusOwner() && !ProposalTextField.this.isDisposed()) {
                                String text = ProposalTextField.this.getText();
                                String input = "";
                                if (ProposalTextField.this.m_selectedProposal != null) {
                                    input = ProposalTextField.this.m_popup.getText(ProposalTextField.this.m_selectedProposal);
                                }
                                if (!P_ProposalFieldListener.this.equalsIgnoreCase(text, input)) {
                                    ProposalTextField.this.acceptProposalInternal(null, true);
                                }
                                ProposalTextField.this.closePopup();
                            }
                        }
                    });
                    break;
                }
                case 15: {
                    if ((ProposalTextField.this.getType() & 0x400) == 0) break;
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 4: {
                    if (ProposalTextField.this.getText().length() <= 0) break;
                    ProposalTextField.this.textModified();
                    break;
                }
                case 31: {
                    switch (event.keyCode) {
                        case 27: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            event.doit = false;
                            break block1;
                        }
                        case 13: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            ProposalTextField.this.acceptProposalInternal(ProposalTextField.this.m_popup.getSelectedProposal(), true);
                            event.doit = false;
                            break block1;
                        }
                        case 9: 
                        case 10: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            event.doit = false;
                            ProposalTextField.this.m_popup.setFocus();
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
    }
}

