/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.statics;

import com.google.common.annotations.Beta;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeBuilder;
import org.eclipse.recommenders.jayes.io.jbif.JayesBifReader;
import org.eclipse.recommenders.jayes.util.triangulation.IEliminationHeuristic;
import org.eclipse.recommenders.jayes.util.triangulation.MinDegree;
import org.eclipse.recommenders.statics.IStaticsModel;
import org.eclipse.recommenders.statics.MethodNameUtils;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;

@Beta
public class JayesStaticsModel
implements IStaticsModel {
    private static final String VERBS_NODE_NAME = "method-verbs";
    private static final String VERB_OUTCOME_PRIOR = "#prior";
    private final BayesNet net;
    private final BayesNode verbNode;
    private final JunctionTreeAlgorithm junctionTree;
    private final ITypeName declaringType;

    public static IStaticsModel load(InputStream is, ITypeName type) throws IOException {
        BayesNet net = JayesStaticsModel.getModel(is, type);
        return new JayesStaticsModel(type, net);
    }

    private static BayesNet getModel(InputStream is, ITypeName type) throws IOException {
        JayesBifReader rdr = new JayesBifReader(is);
        try {
            BayesNet bayesNet = rdr.read();
            return bayesNet;
        }
        finally {
            IOUtils.closeQuietly((Closeable)rdr);
        }
    }

    public JayesStaticsModel(ITypeName name, BayesNet net) {
        this.net = net;
        this.declaringType = name;
        this.junctionTree = new JunctionTreeAlgorithm();
        this.junctionTree.setJunctionTreeBuilder(JunctionTreeBuilder.forHeuristic((IEliminationHeuristic)new MinDegree()));
        this.junctionTree.setNetwork(net);
        this.verbNode = net.getNode(VERBS_NODE_NAME);
    }

    @Override
    public boolean setEnclosingMethod(IMethodName context) {
        if (context == null) {
            this.junctionTree.addEvidence(this.verbNode, VERB_OUTCOME_PRIOR);
            return false;
        }
        String verb = (String)MethodNameUtils.extractVerb(context.getName()).orNull();
        if (verb == null) {
            this.junctionTree.addEvidence(this.verbNode, VERB_OUTCOME_PRIOR);
            return false;
        }
        if (this.verbNode.getOutcomes().contains(verb)) {
            this.junctionTree.addEvidence(this.verbNode, verb);
            return true;
        }
        this.junctionTree.addEvidence(this.verbNode, VERB_OUTCOME_PRIOR);
        return false;
    }

    @Override
    public List<Recommendation<IMethodName>> recommendCalls() {
        LinkedList<Recommendation<IMethodName>> recommendations = new LinkedList<Recommendation<IMethodName>>();
        Map evidence = this.junctionTree.getEvidence();
        for (BayesNode node : this.net.getNodes()) {
            boolean isAlreadyUsedAsEvidence;
            if (node == this.verbNode || (isAlreadyUsedAsEvidence = evidence.containsKey(node))) continue;
            int indexForTrue = node.getOutcomeIndex("true");
            double[] probabilities = this.junctionTree.getBeliefs(node);
            double probability = probabilities[indexForTrue];
            VmMethodName method = VmMethodName.get((String)node.getName());
            recommendations.add((Recommendation<IMethodName>)Recommendation.newRecommendation((Object)method, (double)probability));
        }
        return recommendations;
    }

    @Override
    public ITypeName getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public void reset() {
        this.junctionTree.getEvidence().clear();
    }

    @Override
    public double recommendCall(IMethodName method) {
        BayesNode node = this.net.getNode(method.getIdentifier());
        if (node == null) {
            return 0.0;
        }
        int indexForTrue = node.getOutcomeIndex("true");
        double[] probabilities = this.junctionTree.getBeliefs(node);
        return probabilities[indexForTrue];
    }
}

