/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.reporting.core.ImageEntry;
import org.eclipse.rcptt.reporting.util.RcpttReportGenerator;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class DetailsDialog
extends Dialog {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StyledText text;
    private Report report;
    private List<ImageEntry> images = new ArrayList<ImageEntry>();
    private int current = -1;
    private Composite bar;
    private Button nextButton;
    private Button prevButton;
    private Label imageIndex;
    private Label descriptionField;
    private Label imageControl;

    public DetailsDialog(Shell parentShell, Report report) {
        super(parentShell);
        this.report = report;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite sc;
        Composite content = (Composite)super.createDialogArea(parent);
        CTabFolder folder = new CTabFolder(content, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem screenshots = new CTabItem(folder, 0);
        screenshots.setText("Screenshots");
        CTabItem item = new CTabItem(folder, 0);
        this.text = new StyledText((Composite)folder, 2824);
        this.text.setFont(JFaceResources.getTextFont());
        item.setControl((Control)this.text);
        item.setText("Description");
        Composite ct = new Composite((Composite)folder, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)ct);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(ct);
        this.generateContent();
        if (this.images.size() == 0) {
            screenshots.dispose();
        }
        if (this.images.size() > 0) {
            sc = new ScrolledComposite(ct, 2816);
            GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)sc);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sc);
            this.imageControl = new Label((Composite)sc, 2048);
            this.imageControl.setText(" ");
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.imageControl);
            sc.setContent((Control)this.imageControl);
            screenshots.setControl((Control)ct);
        } else {
            sc = null;
        }
        Label info = new Label(ct, 0);
        info.setText("Details:");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)info);
        this.descriptionField = new Label(ct, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.descriptionField);
        if (sc != null) {
            this.bar = null;
            if (this.images.size() > 1) {
                this.bar = new Composite(ct, 0);
                GridDataFactory.fillDefaults().grab(false, false).align(131072, 0x1000000).applyTo((Control)this.bar);
                GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.bar);
                this.imageIndex = new Label(this.bar, 0);
                this.prevButton = new Button(this.bar, 8);
                this.prevButton.setText("Previous");
                this.nextButton = new Button(this.bar, 8);
                this.nextButton.setText("Next");
                this.setButtonLayoutData(this.prevButton);
                this.setButtonLayoutData(this.nextButton);
                this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DetailsDialog.this.updateImage(sc, 1);
                    }
                });
                this.prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DetailsDialog.this.updateImage(sc, -1);
                    }
                });
            }
        }
        if (sc != null) {
            this.updateImage(sc, 1);
        }
        folder.setSelection(0);
        return content;
    }

    private void showImage(Label description, Label imageControl, int selection) {
        if (this.current != selection) {
            if (this.images.size() > selection) {
                ImageEntry imgData = this.images.get(selection);
                description.setText(imgData.description);
                Image img = new Image((Device)imageControl.getDisplay(), (InputStream)new ByteArrayInputStream(imgData.data));
                imageControl.setImage(img);
                this.current = selection;
            }
            if (this.nextButton != null && this.prevButton != null && this.imageIndex != null) {
                this.prevButton.setEnabled(this.current != 0);
                this.nextButton.setEnabled(this.current != this.images.size() - 1);
                this.imageIndex.setText("Screenshot " + (this.current + 1) + " from " + this.images.size());
                this.bar.layout();
            }
        }
    }

    private void generateContent() {
        String value = "";
        if (this.report != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("Report:");
            new RcpttReportGenerator(printWriter, this.images).writeReport(this.report, 1);
            value = writer.toString();
        }
        this.text.setText(value);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.DetailsDialog_Title);
        Rectangle bounds = newShell.getBounds();
        newShell.setBounds(bounds.x, bounds.y, 800, 600);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void updateImage(ScrolledComposite sc, int change) {
        int selection = this.current + change;
        if (selection < 0 || selection >= this.images.size()) {
            return;
        }
        this.showImage(this.descriptionField, this.imageControl, selection);
        Point size = this.imageControl.computeSize(-1, -1);
        sc.setMinSize(size);
    }
}

