/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.ActivatorPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AssignmentPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.ResidualPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatedPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatingPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculationPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class MappingPartitioner
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull RegionsAnalysis<@NonNull Partition> regionsPartitionAnalysis;
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull RegionAnalysis regionAnalysis;
    protected final @NonNull MappingRegion region;
    private final @NonNull Set<@NonNull Edge> alreadyConstantEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyLoadedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyPredicatedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Node> alreadyPredicatedNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull AbstractPartialPartition> alreadyRealizedEdges = new HashMap<Edge, AbstractPartialPartition>();
    private final @NonNull Set<@NonNull Node> alreadyRealizedNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull List<@NonNull AbstractPartialPartition>> debugEdge2partitions = new HashMap<Edge, List<AbstractPartialPartition>>();

    public MappingPartitioner(@NonNull TransformationPartitioner transformationPartitioner, @NonNull RegionAnalysis regionAnalysis) {
        this.scheduleManager = transformationPartitioner.getScheduleManager();
        this.regionsPartitionAnalysis = transformationPartitioner;
        this.transformationAnalysis = transformationPartitioner.getTransformationAnalysis();
        this.regionAnalysis = regionAnalysis;
        this.region = (MappingRegion)regionAnalysis.getRegion();
    }

    public void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole, @NonNull AbstractPartialPartition partition) {
        if (newEdgeRole == Role.CONSTANT) {
            this.alreadyConstantEdges.add(edge);
        } else if (newEdgeRole == Role.LOADED) {
            this.alreadyLoadedEdges.add(edge);
        } else if (newEdgeRole == Role.PREDICATED) {
            this.alreadyPredicatedEdges.add(edge);
        } else if (newEdgeRole == Role.SPECULATED) {
            this.alreadyPredicatedEdges.add(edge);
        } else if (newEdgeRole == Role.REALIZED) {
            this.alreadyRealizedEdges.put(edge, partition);
        }
        List<@NonNull AbstractPartialPartition> partitions = this.debugEdge2partitions.get(edge);
        if (partitions == null) {
            partitions = new ArrayList<AbstractPartialPartition>();
            this.debugEdge2partitions.put(edge, partitions);
        }
        assert (!partitions.contains(partition));
        partitions.add(partition);
    }

    public boolean addPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.add(node);
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.scheduleManager.addProblem(problem);
    }

    public boolean addRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.add(node);
    }

    public @Nullable Node basicGetDispatchNode() {
        return this.regionAnalysis.basicGetDispatchNode();
    }

    public @Nullable SuccessEdge basicGetGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetGlobalSuccessEdge(traceNode);
    }

    public @Nullable Node basicGetGlobalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetGlobalSuccessNode(traceNode);
    }

    public @Nullable SuccessEdge basicGetLocalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetLocalSuccessEdge(traceNode);
    }

    public @Nullable Node basicGetLocalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetLocalSuccessNode(traceNode);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void check() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if ((!node.isSpeculated() || node.isHead()) && !node.isRealized() || this.hasRealizedNode(node)) continue;
            this.addProblem(CompilerUtil.createRegionError((Region)this.region, "Should have realized " + node, new Object[0]));
        }
        HashSet<@NonNull Edge> allPrimaryEdges = new HashSet<Edge>();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            allPrimaryEdges.add(edge);
            if (!edge.isRealized() || this.hasRealizedEdge(edge) || edge.isExpression()) continue;
            this.addProblem(CompilerUtil.createRegionError((Region)this.region, "Should have realized " + edge, new Object[0]));
        }
        Set<@NonNull Node> deadNodes = this.computeDeadNodes(QVTscheduleUtil.getOwnedNodes((Region)this.region));
        Set<@NonNull Edge> deadEdges = this.computeDeadEdges(deadNodes);
        allPrimaryEdges.removeAll(deadEdges);
        HashSet<@NonNull Edge> partitionedEdges = new HashSet<Edge>(this.debugEdge2partitions.keySet());
        if (!partitionedEdges.equals(allPrimaryEdges)) {
            @NonNull HashSet extraEdgesSet = Sets.newHashSet(partitionedEdges);
            CompilerUtil.removeAll(extraEdgesSet, allPrimaryEdges);
            for (Edge edge : extraEdgesSet) {
                if (edge.isSecondary()) continue;
                List<@NonNull AbstractPartialPartition> extraPartitions = this.debugEdge2partitions.get(edge);
                this.addProblem(CompilerUtil.createRegionWarning((Region)this.region, "Extra " + edge, new Object[0]));
            }
            @NonNull HashSet missingEdgesSet = Sets.newHashSet(allPrimaryEdges);
            missingEdgesSet.removeAll(partitionedEdges);
            for (Edge edge : missingEdgesSet) {
                if (edge instanceof NavigableEdge && this.transformationAnalysis.getCorollaryOf((NavigableEdge)edge) != null) continue;
                this.addProblem(CompilerUtil.createRegionWarning((Region)this.region, "Missing " + edge, new Object[0]));
            }
        }
    }

    private @NonNull Set<@NonNull Edge> computeDeadEdges(@NonNull Iterable<@NonNull Node> deadNodes) {
        HashSet<@NonNull Edge> deadEdges = new HashSet<Edge>();
        for (Node node : deadNodes) {
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getIncomingEdges((Node)node));
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getOutgoingEdges((Node)node));
        }
        return deadEdges;
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull Set<@NonNull Node> computeDeadNodes(@NonNull Iterable<@NonNull Node> nodes) {
        deadNodes = new HashSet<Node>();
        moreDeadNodes = null;
        for (Node node : nodes) {
            if (node.isHead() || !this.isDead(node, null)) continue;
            if (moreDeadNodes == null) {
                moreDeadNodes = new HashSet<Node>();
            }
            moreDeadNodes.add(node);
        }
        if (moreDeadNodes != null) ** GOTO lbl27
        return deadNodes;
lbl-1000:
        // 1 sources

        {
            deadNodes.addAll((Collection<Node>)moreDeadNodes);
            moreDeadNodesList = new ArrayList<E>(moreDeadNodes);
            moreDeadNodes = null;
            for (Node deadNode : moreDeadNodesList) {
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)deadNode)) {
                    sourceNode = edge.getEdgeSource();
                    if (sourceNode.isHead() || !this.isDead(sourceNode, deadNodes)) continue;
                    if (moreDeadNodes == null) {
                        moreDeadNodes = new HashSet<E>();
                    }
                    moreDeadNodes.add(sourceNode);
                }
            }
            if (moreDeadNodes == null) break;
lbl27:
            // 2 sources

            ** while (moreDeadNodes.size() > 0)
        }
lbl28:
        // 2 sources

        return deadNodes;
    }

    private @NonNull ActivatorPartition createActivatorPartition() {
        ReachabilityForest reachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
        return new ActivatorPartition(this, reachabilityForest);
    }

    private @NonNull AssignmentPartition createAssignmentPartition(@NonNull ReachabilityForest reachabilityForest, @NonNull Edge outputEdge) {
        return new AssignmentPartition(this, reachabilityForest, outputEdge);
    }

    private @NonNull NonPartition createNonPartition() {
        return new NonPartition(this);
    }

    private @NonNull ResidualPartition createResidualPartition() {
        ReachabilityForest reachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
        return new ResidualPartition(this, reachabilityForest);
    }

    private @NonNull SpeculatedPartition createSpeculatedPartition() {
        ReachabilityForest reachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
        return new SpeculatedPartition(this, reachabilityForest);
    }

    private @NonNull SpeculatingPartition createSpeculatingPartition() {
        ReachabilityForest reachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
        return new SpeculatingPartition(this, reachabilityForest);
    }

    private @NonNull SpeculationPartition createSpeculationPartition() {
        ReachabilityForest reachabilityForest = new ReachabilityForest(this.getSpeculationReachabilityRootNodes(), this.getAvailableNavigableEdges());
        return new SpeculationPartition(this, reachabilityForest);
    }

    public @NonNull Iterable<@NonNull Edge> getAlreadyRealizedEdges() {
        return this.alreadyRealizedEdges.keySet();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Iterable<@NonNull NavigableEdge> getAvailableNavigableEdges() {
        @NonNull ArrayList navigableEdges = Lists.newArrayList(this.getOldPrimaryNavigableEdges());
        for (Edge edge : this.getAlreadyRealizedEdges()) {
            if (!(edge instanceof NavigableEdge)) continue;
            navigableEdges.add((NavigableEdge)edge);
        }
        return navigableEdges;
    }

    public @NonNull Iterable<@NonNull Node> getConstantInputNodes() {
        return this.regionAnalysis.getConstantInputNodes();
    }

    public @NonNull Iterable<@NonNull Node> getConstantOutputNodes() {
        return this.regionAnalysis.getConstantOutputNodes();
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis<@NonNull RegionAnalysis>> getConsumedTraceClassAnalyses() {
        return this.regionAnalysis.getConsumedTraceClassAnalyses();
    }

    public @Nullable Iterable<@NonNull TracePropertyAnalysis<@NonNull RegionAnalysis>> getConsumedTracePropertyAnalyses() {
        return this.regionAnalysis.getConsumedTracePropertyAnalyses();
    }

    public @NonNull Iterable<@NonNull Node> getExecutionNodes() {
        return Iterables.concat(this.getPredicatedExecutionNodes(), this.getRealizedExecutionNodes());
    }

    public @NonNull SuccessEdge getGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.getGlobalSuccessEdge(traceNode);
    }

    public @NonNull Node getGlobalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.getGlobalSuccessNode(traceNode);
    }

    public @NonNull SuccessEdge getLocalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.getLocalSuccessEdge(traceNode);
    }

    public @NonNull Node getLocalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.getLocalSuccessNode(traceNode);
    }

    public String getName() {
        return this.region.getName();
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.regionAnalysis.getOldPrimaryNavigableEdges();
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.regionAnalysis.getPredicatedEdges();
    }

    public @NonNull List<@NonNull Node> getPredicatedExecutionNodes() {
        ArrayList<@NonNull Node> predicatedExecutionNodes = new ArrayList<Node>();
        for (Node node : this.getPredicatedMiddleNodes()) {
            if (!"trace".equals(node.getName())) continue;
            assert (node.isTrace());
            predicatedExecutionNodes.add(node);
        }
        return predicatedExecutionNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.regionAnalysis.getPredicatedMiddleNodes();
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.regionAnalysis.getPredicatedOutputNodes();
    }

    public @NonNull List<@NonNull Node> getPredicatedWhenNodes() {
        ArrayList<@NonNull Node> predicatedWhenNodes = new ArrayList<Node>();
        for (Node node : this.getPredicatedMiddleNodes()) {
            if (!node.getName().startsWith("when_")) continue;
            predicatedWhenNodes.add(node);
        }
        return predicatedWhenNodes;
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis<@NonNull RegionAnalysis>> getProducedTraceClassAnalyses() {
        return this.regionAnalysis.getProducedTraceClassAnalyses();
    }

    public @Nullable Iterable<@NonNull TracePropertyAnalysis<@NonNull RegionAnalysis>> getProducedTracePropertyAnalyses() {
        return this.regionAnalysis.getProducedTracePropertyAnalyses();
    }

    private @NonNull Iterable<@NonNull Node> getReachabilityRootNodes() {
        List<@NonNull Node> traceNodes = this.getTraceNodes();
        Iterable<@NonNull Node> constantInputNodes = this.getConstantInputNodes();
        return Iterables.concat(traceNodes, constantInputNodes);
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedEdges() {
        return this.regionAnalysis.getRealizedEdges();
    }

    public @NonNull List<@NonNull Node> getRealizedExecutionNodes() {
        ArrayList<@NonNull Node> realizedExecutionNodes = new ArrayList<Node>();
        for (Node node : this.getRealizedMiddleNodes()) {
            if (!"trace".equals(node.getName())) continue;
            realizedExecutionNodes.add(node);
        }
        return realizedExecutionNodes;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.regionAnalysis.getRealizedMiddleNodes();
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedOutputEdges() {
        return this.regionAnalysis.getRealizedOutputEdges();
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.regionAnalysis.getRealizedOutputNodes();
    }

    public @NonNull List<@NonNull Node> getRealizedWhereNodes() {
        ArrayList<@NonNull Node> realizedWhereNodes = new ArrayList<Node>();
        for (Node node : this.getRealizedMiddleNodes()) {
            if (!node.getName().startsWith("where_")) continue;
            realizedWhereNodes.add(node);
        }
        return realizedWhereNodes;
    }

    public @Nullable AbstractPartialPartition getRealizingPartition(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.get(edge);
    }

    public @NonNull MappingRegion getRegion() {
        return this.region;
    }

    public @NonNull RegionAnalysis getRegionAnalysis() {
        return this.regionAnalysis;
    }

    public @NonNull RegionsAnalysis<@NonNull Partition> getRegionsPartitionAnalysis() {
        return this.regionsPartitionAnalysis;
    }

    protected @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    private @NonNull Iterable<@NonNull Node> getSpeculationReachabilityRootNodes() {
        ArrayList<@NonNull Node> rootNodes = new ArrayList<Node>();
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)this.region)) {
            if (headNode.isDependency()) continue;
            rootNodes.add(headNode);
        }
        for (Node constantInputNode : this.getConstantInputNodes()) {
            rootNodes.add(constantInputNode);
        }
        return rootNodes;
    }

    public @NonNull Iterable<@NonNull SuccessEdge> getSuccessEdges() {
        return this.regionAnalysis.getSuccessEdges();
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis<@NonNull RegionAnalysis>> getSuperProducedTraceClassAnalyses() {
        return this.regionAnalysis.getSuperProducedTraceClassAnalyses();
    }

    public @NonNull TraceClassAnalysis<@NonNull RegionAnalysis> getTraceClassAnalysis(@NonNull Node traceNode) {
        ClassDatum traceClassDatum = QVTscheduleUtil.getClassDatum((Node)traceNode);
        return this.transformationAnalysis.getTraceClassAnalysis(traceClassDatum);
    }

    public @Nullable Edge getTraceEdge(@NonNull Node node) {
        return this.regionAnalysis.getTraceEdge(node);
    }

    public @NonNull Node getTraceNode() {
        List<@NonNull Node> traceNodes = this.getTraceNodes();
        assert (traceNodes.size() == 1);
        return (Node)ClassUtil.nonNullState((Object)traceNodes.get(0));
    }

    public @NonNull List<@NonNull Node> getTraceNodes() {
        return this.regionAnalysis.getTraceNodes();
    }

    public boolean hasConstantEdge(@NonNull Edge edge) {
        return this.alreadyConstantEdges.contains(edge);
    }

    public boolean hasLoadedEdge(@NonNull Edge edge) {
        return this.alreadyLoadedEdges.contains(edge);
    }

    public boolean hasPredicatedEdge(@NonNull Edge edge) {
        return this.alreadyPredicatedEdges.contains(edge);
    }

    public boolean hasPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.contains(node);
    }

    public boolean hasRealizedEdge(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.containsKey(edge);
    }

    public boolean hasRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.contains(node);
    }

    public @Nullable List<@NonNull Region> getCorollaryOf(@NonNull NavigableEdge edge) {
        return this.transformationAnalysis.getCorollaryOf(edge);
    }

    public boolean isCyclic(@NonNull Node traceNode) {
        ClassDatum traceClassDatum = QVTscheduleUtil.getClassDatum((Node)traceNode);
        return this.transformationAnalysis.isCyclic(traceClassDatum);
    }

    private boolean isDead(@NonNull Node node, @Nullable Set<@NonNull Node> knownDeadNodes) {
        if (node.isHead()) {
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge.isCast() || edge.isNavigation() ? knownDeadNodes == null || !knownDeadNodes.contains(edge.getEdgeSource()) : edge.isPredicate() && (knownDeadNodes == null || !knownDeadNodes.contains(edge.getEdgeSource())))) continue;
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            if (!edge.isCast() && !edge.isNavigation() && !edge.isExpression() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeTarget())) continue;
            return false;
        }
        return true;
    }

    public @NonNull Iterable<@NonNull Partition> partition() {
        if (this.region instanceof DispatchRegion || this.region instanceof VerdictRegion) {
            return Collections.singletonList(this.createNonPartition());
        }
        String name = this.region.getName();
        if ("associationToForeignKey".equals(name)) {
            this.getClass();
        }
        boolean isCyclic = this.transformationAnalysis.isCyclic(this.regionAnalysis);
        boolean hasPredication = false;
        boolean needsActivator = false;
        boolean useActivators = this.scheduleManager.useActivators();
        if (useActivators) {
            List<@NonNull Node> predicatedWhenNodes = this.getPredicatedWhenNodes();
            hasPredication = predicatedWhenNodes.size() > 0;
            List<@NonNull Node> realizedExecutionNodes = this.getRealizedExecutionNodes();
            needsActivator = realizedExecutionNodes.size() > 0;
        } else {
            Iterable<@NonNull Node> predicatedMiddleNodes = this.getPredicatedMiddleNodes();
            hasPredication = !Iterables.isEmpty(predicatedMiddleNodes);
        }
        boolean needsSpeculation = isCyclic && hasPredication;
        ArrayList<@NonNull Partition> newPartitions = new ArrayList<Partition>();
        if (needsActivator) {
            newPartitions.add(this.createActivatorPartition());
        }
        if (!needsSpeculation) {
            if (newPartitions.isEmpty()) {
                newPartitions.add(this.createNonPartition());
            } else {
                newPartitions.add(this.createResidualPartition());
            }
        } else {
            if (useActivators) {
                this.regionAnalysis.createLocalSuccess();
            }
            SpeculationPartition speculationPartition = this.createSpeculationPartition();
            SpeculatingPartition speculatingPartition = this.createSpeculatingPartition();
            SpeculatedPartition speculatedPartition = this.createSpeculatedPartition();
            newPartitions.add(speculationPartition);
            newPartitions.add(speculatingPartition);
            newPartitions.add(speculatedPartition);
            if (!useActivators) {
                speculatingPartition.addExplicitPredecessor(speculationPartition);
                speculatedPartition.addExplicitPredecessor(speculatingPartition);
            }
            ReachabilityForest assignmentReachabilityForest = new ReachabilityForest(this.getReachabilityRootNodes(), this.getAvailableNavigableEdges());
            for (NavigableEdge outputEdge : this.getRealizedOutputEdges()) {
                if (this.hasRealizedEdge((Edge)outputEdge)) continue;
                newPartitions.add(this.createAssignmentPartition(assignmentReachabilityForest, (Edge)outputEdge));
            }
            for (NavigableEdge edge : this.getRealizedEdges()) {
                if (this.hasRealizedEdge((Edge)edge)) continue;
                newPartitions.add(this.createAssignmentPartition(assignmentReachabilityForest, (Edge)edge));
            }
        }
        if (newPartitions.size() > 1) {
            this.check();
        }
        return newPartitions;
    }

    public String toString() {
        return this.region.getName();
    }
}

