/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

public class DebugParametersInitializersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugParametersInitializers";
    private static final String INITIALIZER_TAG = "initializer";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE = "launchConfigurationType";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String MODE_ATTRIBUTE = "mode";
    private static final String RUN = "run";
    private static final String DEBUG = "debug";
    private static final String PROFILE = "profile";
    private Dictionary<String, DebugParametersInitializerFactory> runInitializers = new Hashtable<String, DebugParametersInitializerFactory>();
    private Dictionary<String, DebugParametersInitializerFactory> debugInitializers = new Hashtable<String, DebugParametersInitializerFactory>();
    private Dictionary<String, DebugParametersInitializerFactory> profileInitializers = new Hashtable<String, DebugParametersInitializerFactory>();
    private static DebugParametersInitializersRegistry instance = null;

    private DebugParametersInitializersRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (INITIALIZER_TAG.equals(element.getName())) {
                if (RUN.equals(element.getAttribute(MODE_ATTRIBUTE))) {
                    this.runInitializers.put(element.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(element));
                } else if (PROFILE.equals(element.getAttribute(MODE_ATTRIBUTE))) {
                    this.profileInitializers.put(element.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(element));
                } else {
                    this.debugInitializers.put(element.getAttribute(ID_ATTRIBUTE), new DebugParametersInitializerFactory(element));
                }
            }
            ++i;
        }
    }

    private static DebugParametersInitializersRegistry getInstance() {
        if (instance == null) {
            instance = new DebugParametersInitializersRegistry();
        }
        return instance;
    }

    private Dictionary<String, DebugParametersInitializerFactory> getInitializersFactories(String mode) {
        if (RUN.equals(mode)) {
            return this.runInitializers;
        }
        if (PROFILE.equals(mode)) {
            return this.profileInitializers;
        }
        return this.debugInitializers;
    }

    public static IDebugParametersInitializer getParametersInitializer(String id) throws Exception {
        DebugParametersInitializerFactory initializerFactory = DebugParametersInitializersRegistry.getInstance().getInitializersFactories(RUN).get(id);
        if (initializerFactory == null) {
            initializerFactory = DebugParametersInitializersRegistry.getInstance().getInitializersFactories(PROFILE).get(id);
        }
        if (initializerFactory == null) {
            initializerFactory = DebugParametersInitializersRegistry.getInstance().getInitializersFactories(DEBUG).get(id);
        }
        if (initializerFactory != null) {
            return initializerFactory.createParametersInitializer();
        }
        return null;
    }

    public static IDebugParametersInitializer getCurrentDebugParametersInitializer() {
        try {
            String id = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", "org.eclipse.php.debug.core.debugParametersInitializer", null, null);
            return DebugParametersInitializersRegistry.getParametersInitializer(id);
        }
        catch (Exception e) {
            PHPDebugPlugin.log(e);
            return null;
        }
    }

    public static IDebugParametersInitializer getBestMatchDebugParametersInitializer(ILaunch launch) {
        try {
            String configurationTypeId;
            DebugParametersInitializerFactory initializerFactory;
            Dictionary<String, DebugParametersInitializerFactory> factories = DebugParametersInitializersRegistry.getInstance().getInitializersFactories(launch.getLaunchMode());
            Enumeration<DebugParametersInitializerFactory> e = factories.elements();
            while (e.hasMoreElements()) {
                initializerFactory = e.nextElement();
                configurationTypeId = initializerFactory.element.getAttribute(LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE);
                if (configurationTypeId == null || "".equals(configurationTypeId) || !configurationTypeId.equals(launch.getLaunchConfiguration().getType().getIdentifier())) continue;
                return initializerFactory.createParametersInitializer();
            }
            e = factories.elements();
            while (e.hasMoreElements()) {
                initializerFactory = e.nextElement();
                configurationTypeId = initializerFactory.element.getAttribute(LAUNCH_CONFIGURATION_TYPE_ATTRIBUTE);
                if (configurationTypeId != null && !"".equals(configurationTypeId) || PHPDebugPlugin.getID().equals(initializerFactory.element.getNamespaceIdentifier())) continue;
                return initializerFactory.createParametersInitializer();
            }
            e = factories.elements();
            while (e.hasMoreElements()) {
                initializerFactory = e.nextElement();
                if (!PHPDebugPlugin.getID().equals(initializerFactory.element.getNamespaceIdentifier())) continue;
                return initializerFactory.createParametersInitializer();
            }
        }
        catch (Exception e) {
            PHPDebugPlugin.log(e);
        }
        return DebugParametersInitializersRegistry.getCurrentDebugParametersInitializer();
    }

    class DebugParametersInitializerFactory {
        private IConfigurationElement element;
        private IDebugParametersInitializer parametersInitializer;

        public DebugParametersInitializerFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IDebugParametersInitializer createParametersInitializer() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugParametersInitializers"){

                public void run() throws Exception {
                    DebugParametersInitializerFactory.this.parametersInitializer = (IDebugParametersInitializer)DebugParametersInitializerFactory.this.element.createExecutableExtension(DebugParametersInitializersRegistry.CLASS_ATTRIBUTE);
                }
            });
            this.parametersInitializer.setDebugHandler(this.element.getAttribute(DebugParametersInitializersRegistry.HANDLER_ATTRIBUTE));
            return this.parametersInitializer;
        }
    }
}

