/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class SetResizeCommand
extends AbstractTransactionalCommand {
    private IAdaptable adapter;
    private Dimension size;

    public SetResizeCommand(TransactionalEditingDomain editingDomain, String label, IAdaptable adapter, Dimension size) {
        super(editingDomain, label, null);
        Assert.isNotNull((Object)adapter, (String)"view cannot be null");
        Assert.isNotNull((Object)size, (String)"size cannot be null");
        this.adapter = adapter;
        this.size = size;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.adapter == null) {
            return CommandResult.newErrorCommandResult((String)"SetResizeCommand: viewAdapter does not adapt to IView.class");
        }
        View view = (View)this.adapter.getAdapter(View.class);
        if (this.size != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)this.size.width);
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)this.size.height);
        }
        return CommandResult.newOKCommandResult();
    }

    public List<?> getAffectedFiles() {
        View view;
        if (this.adapter != null && (view = (View)this.adapter.getAdapter(View.class)) != null) {
            return SetResizeCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }
}

