/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.xtext.base.ui.BaseUIActivator;
import org.eclipse.ocl.xtext.base.ui.builder.AbstractValidatingBuilder;
import org.eclipse.ocl.xtext.base.ui.builder.MultiValidationJob;
import org.eclipse.ocl.xtext.base.ui.builder.ValidationEntry;

public abstract class AbstractBuildSelector
implements IResourceVisitor,
IResourceDeltaVisitor {
    protected final @NonNull IProject project;
    protected final @NonNull AbstractValidatingBuilder.BuildType buildType;
    private final @NonNull IProgressMonitor monitor;
    private final @NonNull Map<@NonNull String, @Nullable Boolean> extension2included = new HashMap<String, Boolean>();
    private final char[][] exclusionPatterns;
    private final char[][] inclusionPatterns;
    private final @NonNull Set<@NonNull IPath> removedPaths = new HashSet<IPath>();
    private final @NonNull Set<@NonNull ValidationEntry> selectedEntries = new HashSet<ValidationEntry>();

    protected AbstractBuildSelector(@NonNull IProject project, @NonNull AbstractValidatingBuilder.BuildType buildType, @Nullable Map<String, String> args, @NonNull IProgressMonitor monitor) {
        this.project = project;
        this.buildType = buildType;
        this.monitor = monitor;
        String[] disabledPathArray = null;
        String[] enabledPathArray = null;
        if (args != null) {
            String disabledPaths;
            String enabledPaths;
            String excludedExtensions;
            Object object;
            int n;
            String includedExtensions = args.get("enabledExtensions");
            if (includedExtensions != null) {
                String[] stringArray = includedExtensions.split(",");
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String includedExtension = stringArray[n2];
                    object = this.extension2included.put(includedExtension, Boolean.TRUE);
                    ++n2;
                }
            }
            if ((excludedExtensions = args.get("disabledExtensions")) != null) {
                object = excludedExtensions.split(",");
                int n3 = ((String[])object).length;
                n = 0;
                while (n < n3) {
                    String excludedExtension = object[n];
                    Boolean bl = this.extension2included.put(excludedExtension, Boolean.FALSE);
                    ++n;
                }
            }
            if ((enabledPaths = args.get("enabledPaths")) != null) {
                enabledPathArray = enabledPaths.split(",");
            }
            if ((disabledPaths = args.get("disabledPaths")) != null) {
                disabledPathArray = disabledPaths.split(",");
            }
        }
        if (enabledPathArray != null) {
            this.inclusionPatterns = new char[enabledPathArray.length][];
            int i = 0;
            while (i < enabledPathArray.length) {
                void enabledPath = enabledPathArray[i];
                this.inclusionPatterns[i] = ((String)(enabledPath.length() > 0 ? enabledPath : "**")).toCharArray();
                ++i;
            }
        } else {
            this.inclusionPatterns = null;
        }
        if (disabledPathArray != null) {
            this.exclusionPatterns = new char[disabledPathArray.length][];
            int i = 0;
            while (i < disabledPathArray.length) {
                void disabledPath = disabledPathArray[i];
                this.exclusionPatterns[i] = ((String)(disabledPath.length() > 0 ? disabledPath : "**")).toCharArray();
                ++i;
            }
        } else {
            this.exclusionPatterns = null;
        }
    }

    public void buildResources() {
        MultiValidationJob multiValidationJob = BaseUIActivator.getMultiValidationJob();
        if (multiValidationJob != null) {
            multiValidationJob.addValidations(this.selectedEntries);
        }
    }

    protected @NonNull ValidationEntry createValidationEntry(@NonNull IFile iFile) {
        return new ValidationEntry(iFile, this.getMarkerId(iFile));
    }

    protected @NonNull String getMarkerId(@NonNull IFile iFile) {
        return "org.eclipse.emf.ecore.diagnostic";
    }

    public @Nullable Boolean isSelected(@NonNull IResource resource) {
        if (resource instanceof IFile) {
            String fileExtension = resource.getFileExtension();
            if (this.extension2included.get(fileExtension) != Boolean.TRUE) {
                return Boolean.FALSE;
            }
            String filePath = resource.getProjectRelativePath().toString();
            char[] path = filePath.toCharArray();
            boolean isExcluded = AbstractValidatingBuilder.isExcluded(path, this.inclusionPatterns, this.exclusionPatterns, false);
            return isExcluded ? Boolean.FALSE : Boolean.TRUE;
        }
        if (resource instanceof IFolder) {
            String filePath = resource.getProjectRelativePath().toString();
            char[] path = filePath.toCharArray();
            boolean isExcluded = AbstractValidatingBuilder.isExcluded(path, this.inclusionPatterns, this.exclusionPatterns, true);
            return isExcluded ? Boolean.FALSE : null;
        }
        return null;
    }

    public int selectResources(@Nullable IResourceDelta delta) throws CoreException {
        if (delta == null) {
            this.project.accept((IResourceVisitor)this, 2, 0);
        } else {
            delta.accept((IResourceDeltaVisitor)this);
        }
        return this.selectedEntries.size();
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        assert (resource != null);
        Boolean isSelected = this.isSelected(resource);
        if (isSelected == Boolean.TRUE) {
            IFile iFile = (IFile)resource;
            this.selectedEntries.add(this.createValidationEntry(iFile));
            return true;
        }
        return isSelected == null;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            return resource == this.project;
        }
        if (resource instanceof IStorage) {
            if (delta.getKind() == 2) {
                Boolean isSelected = this.isSelected(resource);
                if (isSelected == Boolean.TRUE) {
                    IPath fullPath = ((IFile)resource).getFullPath();
                    assert (fullPath != null);
                    this.removedPaths.add(fullPath);
                    return true;
                }
                return isSelected == null;
            }
            if (delta.getKind() == 1 || delta.getKind() == 4) {
                Boolean isSelected = this.isSelected(resource);
                if (isSelected == Boolean.TRUE) {
                    IFile iFile = (IFile)resource;
                    this.selectedEntries.add(this.createValidationEntry(iFile));
                    return true;
                }
                return isSelected == null;
            }
        }
        return true;
    }

    public void deleteMarkers() {
        for (ValidationEntry entry : this.selectedEntries) {
            try {
                entry.deleteMarkers();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

