/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2014 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
*******************************************************************************/

package org.eclipse.ocl.parser;

/**
 * @noextend This interface is not intended to be extended by clients.
 */
@SuppressWarnings("nls")
public class OCLParserprs implements lpg.runtime.ParseTable, OCLParsersym {
    public final static int ERROR_SYMBOL = 80;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 44;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 45;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 29;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 250;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 80;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 4635;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 312;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 124;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 204;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 3938;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 8;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 71;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 71;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 4322;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 4323;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return OCLParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,1,1,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,1,1,0,0,0,0,
            0,1,0,1,0,0,1,0,0,0,
            0,0,0,0,1,0,0,0,0,0,
            0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,11,29,30,
            31,32,33,38,39,40,41,42,43,44,
            46,47,48,49,50,51,52,53,54,59,
            60,61,86,88,89,90,91,100,83,84,
            85,80,81,82,77,78,79,74,75,76,
            71,72,73,68,69,70,65,66,67,24,
            55,62,63,64,21,6,8,14,25,56,
            99,57,16,22,23,58,97,94,28,87,
            113,114,115,116,27,36,37,95,96,103,
            105,26,34,35,98,101,102,109,118,119,
            120,123,124,2,3,4,19,20,45,92,
            93,104,106,107,108,110,111,112,117,121,
            122,1,5,7
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,1,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,0,0,0,0,
            1,1,0,0,1,1,1,1,1,1,
            1,1,1,1,1,1,0,1,1,1,
            0,0,1,1,1,1,1,0,0,0,
            0,0,1,1,1,1,1,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,4,0,1,1,3,1,1,3,1,
            1,1,1,1,1,1,4,1,3,1,
            1,1,2,1,1,1,1,1,1,1,
            1,1,1,1,1,8,10,10,8,10,
            1,1,1,5,6,8,8,7,7,5,
            6,9,1,4,6,4,7,5,0,0,
            1,1,3,1,1,1,1,1,1,1,
            1,1,3,1,3,1,1,1,3,1,
            3,1,1,1,3,1,3,1,1,1,
            3,1,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,3,3,1,3,
            3,3,3,1,1,1,3,3,1,3,
            3,1,1,1,3,3,1,3,3,1,
            1,1,2,2,1,2,2,1,1,1,
            1,1,1,3,7,4,1,3,1,1,
            1,1,1,0,1,1,1,1,1,1,
            1,1,1,1,1,1,0,1,1,1,
            0,1,7,2,2,1,6,6,0,1,
            1,3,1,3,1,1,1,2,2,1,
            1,4,1,1,1,3,2,1,3,0,
            1,1,2,1,1,1,7,1,2,3,
            3,3,5,1,2,4,4,5,3,3,
            3,1,2,4,4,4,6,8,0,1,
            1,3,-92,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-98,0,0,
            -2,-3,0,-15,0,0,-4,-5,0,-20,
            -21,-14,-79,0,0,-84,-6,0,0,0,
            -17,0,0,-10,-16,0,0,-93,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-96,0,0,-97,0,0,
            -99,0,0,0,0,-81,-78,-40,-18,-144,
            0,0,-191,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-217,0,-19,-26,0,-27,-28,-30,
            -31,-171,-33,-125,0,-141,-36,0,-231,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -37,0,0,-38,-39,-41,-34,-42,-43,-123,
            -179,0,0,0,-184,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -44,-13,0,0,0,0,0,0,-46,-48,
            -49,-50,-51,-52,-53,-54,-55,-56,-57,-58,
            -59,-63,0,-64,0,0,-143,-65,0,-176,
            0,0,-185,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-66,
            0,0,-67,-68,-69,-70,-71,-75,-82,-87,
            -88,-89,-95,-100,-107,-108,-109,-120,-121,-122,
            -124,0,0,-126,-204,-128,-213,-129,0,0,
            -127,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-130,
            0,-131,-223,-155,0,0,0,-174,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-132,-133,0,-134,-243,
            -227,0,0,0,-182,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-135,-136,-137,-139,-140,-142,-145,-146,
            -147,-148,-149,-150,-151,-152,-153,-154,-158,-159,
            0,0,-203,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-160,-161,-162,
            -163,-164,0,-165,-166,-177,-178,-183,0,-206,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-186,-189,-190,-192,-193,0,
            -194,-195,-197,-199,-200,0,-207,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-201,-202,-205,-208,-209,0,-210,-211,-212,
            -214,-216,0,-234,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-218,-221,
            -222,-224,-225,0,-235,-236,-237,-238,-239,0,
            -86,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-240,-241,-242,-244,-248,
            0,-188,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-249,-250,0,0,
            0,0,-220,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-230,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-22,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-24,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-25,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-45,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-47,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-72,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-73,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-74,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-77,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-118,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-138,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-156,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-167,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-168,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-175,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-181,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-198,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-226,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-228,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-245,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-246,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-247,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-101,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-117,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-102,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-116,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-103,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-104,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-112,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-113,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-114,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-115,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-105,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-106,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-60,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-61,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-32,0,0,
            0,-196,0,0,0,0,-110,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-111,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-1,0,0,
            0,-232,0,0,0,0,0,0,0,-23,
            0,0,0,0,0,0,0,0,-169,0,
            0,0,-62,0,0,-172,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-233,
            0,0,0,0,0,0,0,0,0,0,
            -80,0,0,0,0,0,-7,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-8,0,0,0,0,
            -9,0,0,0,0,0,0,-11,0,0,
            0,0,-12,0,0,0,0,0,0,-29,
            0,0,0,0,-94,0,0,0,0,0,
            0,0,-157,0,0,0,0,0,0,0,
            -170,0,0,0,0,0,0,0,-173,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-215,
            0,0,0,0,0,0,0,0,0,0,
            0,-76,0,0,0,0,0,0,0,0,
            -83,0,0,0,0,-35,0,0,-85,0,
            0,0,0,0,0,0,-187,0,0,0,
            0,0,0,0,-90,0,0,0,0,0,
            0,0,-219,0,0,0,0,0,0,0,
            0,-91,0,0,0,-119,0,0,0,-229,
            0,0,0,0,0,0,0,0,0,-180,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            104,105,105,105,105,105,105,105,105,105,
            105,105,105,105,105,105,106,123,123,123,
            123,123,123,123,123,123,123,123,66,124,
            67,67,67,8,1,1,2,2,68,68,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,73,73,73,73,6,
            7,107,107,108,108,74,65,75,69,92,
            92,85,85,79,79,79,79,9,9,9,
            9,10,10,93,93,94,94,86,86,87,
            12,12,12,12,12,12,12,11,109,109,
            14,15,16,16,17,17,18,19,20,13,
            13,13,21,21,23,23,24,24,24,25,
            25,22,22,22,27,27,27,27,27,27,
            27,27,27,29,28,28,30,30,30,72,
            76,76,70,70,60,60,32,31,61,61,
            64,64,62,62,63,63,58,58,57,57,
            59,59,55,55,54,54,56,56,52,52,
            51,51,53,53,49,49,48,48,48,50,
            50,50,46,46,45,45,45,45,45,47,
            47,47,47,47,43,43,42,42,42,44,
            44,44,40,40,39,39,39,41,41,41,
            80,80,33,33,33,34,34,34,26,26,
            35,35,35,35,35,37,36,110,110,104,
            104,104,104,104,104,123,123,123,123,123,
            123,123,123,123,123,123,123,77,77,1,
            4,95,95,27,30,71,72,38,38,96,
            96,97,97,90,90,90,35,111,111,111,
            112,112,91,114,116,117,117,118,113,113,
            115,115,98,98,81,81,81,82,119,119,
            89,89,83,83,99,99,78,78,78,100,
            100,84,121,121,88,88,88,101,120,102,
            102,103,103,213,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,755,221,204,207,664,215,
            223,266,750,762,199,752,761,189,751,764,
            179,754,760,172,753,768,166,757,759,160,
            756,840,154,1019,144,843,149,758,461,767,
            382,252,73,1098,173,40,382,198,13,4176,
            170,419,363,173,40,382,695,328,670,85,
            87,216,661,382,175,56,1017,1093,213,498,
            382,741,109,665,669,111,146,222,77,78,
            79,80,90,91,666,93,94,95,96,220,
            112,113,114,115,749,121,122,123,133,755,
            221,204,207,664,215,223,266,750,762,199,
            752,761,189,751,764,179,754,760,172,753,
            768,166,757,759,160,756,840,154,1019,144,
            843,149,758,283,284,285,286,283,284,285,
            286,269,268,16,586,173,1096,382,173,1097,
            382,173,500,382,85,87,14,355,268,251,
            326,1094,1093,54,867,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,755,221,204,207,664,215,
            223,266,750,762,199,752,761,189,751,764,
            179,754,760,172,753,768,166,757,759,160,
            756,840,154,1335,1340,843,149,758,1339,851,
            850,1257,1336,536,295,541,364,71,413,440,
            495,512,276,560,162,303,729,513,1338,160,
            1020,382,741,109,665,669,111,146,222,77,
            78,79,80,90,91,666,93,94,95,96,
            220,112,113,114,115,749,121,122,123,133,
            755,221,204,207,664,215,223,266,750,762,
            199,752,761,189,751,764,179,754,760,172,
            753,768,166,757,759,160,756,840,154,142,
            144,843,149,758,72,256,134,256,1255,1488,
            295,593,289,71,3,632,661,10,11,640,
            116,173,868,382,1487,1,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,265,144,843,149,758,
            70,117,173,583,382,294,69,667,294,109,
            416,21,496,566,324,387,463,547,538,646,
            351,557,558,99,74,261,496,597,673,582,
            729,1264,1332,1,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,755,221,204,207,664,215,
            223,266,750,762,199,752,761,189,751,764,
            179,754,760,172,753,768,166,757,759,160,
            756,840,154,265,144,843,149,758,256,1256,
            676,256,138,681,604,685,687,682,689,690,
            696,699,702,703,704,215,277,706,709,710,
            225,304,3848,261,475,631,567,623,462,1333,
            1332,266,498,382,741,109,665,669,111,146,
            222,77,78,79,80,90,91,666,93,94,
            95,96,220,112,113,114,115,749,121,122,
            123,133,755,221,204,207,664,215,223,266,
            750,762,199,752,761,189,751,764,179,754,
            760,172,753,768,166,757,759,160,756,840,
            154,142,144,843,149,758,256,1411,851,850,
            712,1187,711,729,173,857,382,1186,266,498,
            382,741,109,665,669,111,146,222,77,78,
            79,80,90,91,666,93,94,95,96,220,
            112,113,114,115,749,121,122,123,133,755,
            221,204,207,664,215,223,266,750,762,199,
            752,761,189,751,764,179,754,760,172,753,
            768,166,757,759,160,756,840,154,142,144,
            843,149,758,228,256,137,716,717,1187,705,
            626,173,857,382,1263,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,1019,144,843,149,758,
            1416,851,850,721,720,722,723,727,732,535,
            733,601,734,422,101,127,395,559,637,354,
            630,86,87,266,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,755,221,204,207,664,215,
            223,266,750,762,199,752,761,189,751,764,
            179,754,760,172,753,768,166,757,759,160,
            756,840,154,142,144,843,149,758,649,664,
            667,473,352,1187,570,736,735,737,740,1410,
            266,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            142,144,843,149,758,741,745,748,743,750,
            1187,754,756,757,762,769,1412,266,498,382,
            741,109,665,669,111,146,222,77,78,79,
            80,90,91,666,93,94,95,96,220,112,
            113,114,115,749,121,122,123,133,755,221,
            204,207,664,215,223,266,750,762,199,752,
            761,189,751,764,179,754,760,172,753,768,
            166,757,759,160,756,840,154,142,144,843,
            149,758,763,778,501,785,751,1187,476,770,
            774,790,793,1413,266,498,382,741,109,665,
            669,111,146,222,77,78,79,80,90,91,
            666,93,94,95,96,220,112,113,114,115,
            749,121,122,123,133,755,221,204,207,664,
            215,223,266,750,762,199,752,761,189,751,
            764,179,754,760,172,753,768,166,757,759,
            160,756,840,154,142,144,843,149,758,758,
            786,796,798,799,1187,800,766,804,772,808,
            1489,160,498,382,741,109,665,669,111,146,
            222,77,78,79,80,90,91,666,93,94,
            95,96,220,112,113,114,115,749,121,122,
            123,133,755,221,204,207,664,215,223,266,
            750,762,199,752,761,189,751,764,179,754,
            760,172,753,768,166,757,759,160,756,840,
            154,142,144,843,149,758,669,794,674,813,
            815,864,160,498,382,741,109,665,669,111,
            146,222,77,78,79,80,90,91,666,93,
            94,95,96,220,112,113,114,115,749,121,
            122,123,133,755,221,204,207,664,215,223,
            266,750,762,199,752,761,189,751,764,179,
            754,760,172,753,768,166,757,759,160,756,
            840,154,142,144,843,149,758,817,819,4323,
            4323,4323,1334,107,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,755,221,204,207,664,215,
            223,266,750,762,199,752,761,189,751,764,
            179,754,760,172,753,768,166,757,759,160,
            756,840,154,265,144,843,149,758,4323,4323,
            4323,4323,4323,4323,4323,4323,4323,4323,4323,4323,
            4323,4323,4323,4323,4323,4323,4323,4323,4323,4323,
            4323,4323,4323,262,160,498,382,741,109,665,
            669,111,146,222,77,78,79,80,90,91,
            666,93,94,95,96,220,112,113,114,115,
            749,121,122,123,133,755,221,204,207,664,
            215,223,266,750,762,199,752,761,189,751,
            764,179,754,760,172,753,768,166,757,759,
            160,756,840,154,142,144,843,149,758,4323,
            4323,4323,4323,4323,1486,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,67,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            291,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,290,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            853,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,854,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            306,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,305,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            304,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,296,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            68,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,1188,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            226,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,300,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            299,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,143,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            89,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,1409,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            1415,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,1417,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            1490,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,755,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,756,840,154,1557,144,843,149,758,
            160,498,382,741,109,665,669,111,146,222,
            77,78,79,80,90,91,666,93,94,95,
            96,220,112,113,114,115,749,121,122,123,
            133,755,221,204,207,664,215,223,266,750,
            762,199,752,761,189,751,764,179,754,760,
            172,753,768,166,757,759,160,756,840,154,
            1558,144,843,149,758,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,1099,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,757,
            759,160,156,1100,155,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,1184,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            751,764,179,754,760,172,753,768,166,162,
            1185,161,160,498,382,741,109,665,669,111,
            146,222,77,78,79,80,90,91,666,93,
            94,95,96,220,112,113,114,115,749,121,
            122,123,133,1101,221,204,207,664,215,223,
            266,750,762,199,752,761,189,751,764,179,
            754,760,172,168,1102,167,160,498,382,741,
            109,665,669,111,146,222,77,78,79,80,
            90,91,666,93,94,95,96,220,112,113,
            114,115,749,121,122,123,133,1181,221,204,
            207,664,215,223,266,750,762,199,752,761,
            189,751,764,179,174,1182,173,160,498,382,
            741,109,665,669,111,146,222,77,78,79,
            80,90,91,666,93,94,95,96,220,112,
            113,114,115,749,121,122,123,133,1103,221,
            204,207,664,215,223,266,750,762,199,752,
            761,189,182,1104,181,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,1103,221,204,207,
            664,215,223,266,750,762,199,752,761,189,
            182,1105,180,160,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,1109,221,204,207,664,215,
            223,266,750,762,199,194,1110,193,160,498,
            382,741,109,665,669,111,146,222,77,78,
            79,80,90,91,666,93,94,95,96,220,
            112,113,114,115,749,121,122,123,133,1109,
            221,204,207,664,215,223,266,750,762,199,
            194,1178,192,160,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,1109,221,204,207,664,215,
            223,266,750,762,199,194,1179,191,160,498,
            382,741,109,665,669,111,146,222,77,78,
            79,80,90,91,666,93,94,95,96,220,
            112,113,114,115,749,121,122,123,133,1109,
            221,204,207,664,215,223,266,750,762,199,
            194,1180,190,160,498,382,741,109,665,669,
            111,146,222,77,78,79,80,90,91,666,
            93,94,95,96,220,112,113,114,115,749,
            121,122,123,133,1106,221,204,207,664,215,
            223,266,202,1107,201,160,498,382,741,109,
            665,669,111,146,222,77,78,79,80,90,
            91,666,93,94,95,96,220,112,113,114,
            115,749,121,122,123,133,1106,221,204,207,
            664,215,223,266,202,1108,200,160,498,382,
            741,109,665,669,111,146,222,77,78,79,
            80,90,91,666,93,94,95,96,220,112,
            113,114,115,749,121,122,123,133,855,221,
            210,217,664,215,223,266,160,498,382,741,
            109,665,669,111,146,222,77,78,79,80,
            90,91,666,93,94,95,96,220,112,113,
            114,115,749,121,122,123,133,855,221,210,
            216,664,215,223,266,4323,4323,214,4323,4323,
            4323,4323,4323,4323,4323,4323,4323,4323,4323,4323,
            4323,4323,4323,4323,4323,4323,4323,4323,4323,4323,
            4323,4323,4323,4323,4323,4323,4323,4323,334,4323,
            4323,4323,443,4323,4323,4323,213,160,498,382,
            741,109,665,669,111,146,222,77,78,79,
            80,90,91,666,93,94,95,96,220,112,
            113,114,115,749,121,122,123,133,855,221,
            210,209,664,215,223,266,160,498,382,741,
            109,665,669,111,146,222,77,78,79,80,
            90,91,666,93,94,95,96,220,112,113,
            114,115,749,121,122,123,133,855,221,210,
            208,664,215,223,266,4323,302,206,592,387,
            382,288,498,40,382,846,55,847,57,58,
            350,40,382,846,55,847,57,58,4323,278,
            387,382,4323,173,857,382,278,387,382,497,
            4323,573,4323,4323,4323,4323,205,4323,4323,4323,
            498,40,382,846,55,847,57,58,4323,4323,
            4323,424,38,382,30,31,4323,313,38,382,
            30,31,4323,75,4323,4323,4323,76,4323,4323,
            4323,4323,73,74,4323,252,230,233,4323,282,
            284,285,286,844,75,4323,231,232,76,270,
            4323,75,227,73,74,76,392,307,311,4323,
            73,74,381,4323,4323,311,4323,4323,4323,391,
            267,390,271,252,401,575,405,32,39,861,
            4323,1259,1261,32,39,248,4323,4323,1262,1261,
            4323,4323,4323,856,576,308,313,38,382,30,
            31,313,38,382,30,31,4323,4323,313,38,
            382,30,31,313,38,382,30,31,4323,4323,
            313,38,382,30,31,350,40,382,846,55,
            847,57,58,350,40,382,846,55,847,57,
            58,350,40,382,846,55,847,57,58,350,
            40,382,846,55,847,57,58,4323,4323,4323,
            4323,4323,32,39,248,4323,4323,32,39,248,
            173,387,382,578,32,39,248,4323,579,32,
            39,248,173,860,382,580,32,39,248,4323,
            581,424,38,382,30,31,4,848,1095,424,
            38,382,30,31,4323,4323,1258,424,38,382,
            30,31,4323,4323,66,173,868,382,4323,4323,
            4323,4323,3852,350,40,382,846,55,847,57,
            58,4323,275,942,382,75,173,860,382,76,
            173,1419,382,4323,73,74,4323,859,4323,312,
            173,942,382,4323,4323,4323,4323,32,39,41,
            4323,4323,4323,4323,4323,32,39,584,4323,4323,
            4323,4323,4323,32,39,865,4323,282,284,285,
            286,4323,297,858,70,4323,4323,4323,4323,4323,
            69,4323,4323,4323,396,4323,264,63,4323,4323,
            4323,859,4323,4323,4323,72,4323,98,4323,4323,
            4323,849,4323,4323,71,64,4323,4323,4323,4323,
            4323,4323,4323,4323,866,1418,4323,4323,4323,4323,
            4323,4323,4323,4323,4323,4323,298,858,4323,940,
            1016,4323,4323
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,0,0,4,5,6,7,8,0,
            0,1,0,0,2,12,14,15,16,17,
            0,12,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,18,19,
            20,21,42,43,44,45,46,0,48,49,
            50,51,52,0,1,0,3,4,5,6,
            7,8,53,60,55,56,53,12,55,56,
            70,61,0,0,0,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,18,19,20,21,42,43,44,45,46,
            0,48,49,50,51,52,0,1,0,37,
            4,5,6,7,8,0,0,1,18,19,
            20,21,14,15,16,17,0,12,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,18,19,20,21,42,43,
            44,45,46,0,48,49,50,51,52,0,
            1,0,1,4,5,6,7,8,53,0,
            55,56,0,12,0,0,70,61,6,7,
            8,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,0,0,2,
            39,42,43,44,45,46,9,48,49,50,
            51,52,0,1,0,0,4,5,6,7,
            8,6,7,8,0,1,2,53,14,15,
            16,17,0,64,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            0,0,2,0,42,43,44,45,46,9,
            48,49,50,51,52,0,1,0,1,4,
            5,6,7,8,0,0,0,0,0,12,
            6,7,8,6,7,8,10,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,0,1,2,39,42,43,44,
            45,46,0,48,49,50,51,52,6,7,
            8,71,71,0,57,0,1,0,53,2,
            55,56,9,0,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,0,
            0,0,76,0,0,6,7,8,5,9,
            9,38,0,0,39,2,13,14,15,16,
            17,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,0,0,38,38,
            4,5,59,0,0,9,63,11,65,13,
            14,15,16,17,18,19,20,21,14,15,
            16,17,0,59,2,0,0,63,0,65,
            5,0,60,0,38,4,5,41,13,6,
            7,8,11,47,13,14,15,16,17,0,
            54,2,0,0,58,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            0,0,0,2,4,5,6,7,8,9,
            9,11,0,13,0,0,4,5,18,19,
            20,21,64,11,10,13,14,15,16,17,
            18,19,20,21,0,0,2,0,38,4,
            0,41,42,6,7,8,11,47,66,67,
            10,0,0,2,54,40,54,5,58,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,0,0,0,0,4,5,
            0,0,68,9,69,11,0,13,14,15,
            16,17,18,19,20,21,0,0,0,0,
            4,2,5,5,0,0,0,11,68,0,
            13,13,38,4,5,41,10,37,9,0,
            11,47,13,14,15,16,17,18,19,20,
            21,0,0,47,2,58,0,6,7,8,
            0,66,67,0,4,5,41,38,12,9,
            41,11,9,13,14,15,16,17,18,19,
            20,21,0,1,2,0,1,2,62,0,
            0,0,10,4,12,39,0,12,38,0,
            11,5,12,12,53,0,55,56,0,13,
            59,60,4,57,63,64,65,66,67,11,
            0,39,40,0,39,40,0,4,0,39,
            4,3,0,0,11,0,3,11,10,57,
            0,0,57,10,0,1,0,1,0,0,
            2,69,47,12,0,0,1,37,0,1,
            61,0,0,0,0,0,3,2,0,0,
            0,0,2,41,3,0,0,9,9,0,
            0,0,0,1,3,10,0,1,0,54,
            10,0,0,0,0,0,0,3,58,0,
            0,1,0,12,0,1,10,0,1,0,
            0,9,3,0,60,0,0,0,3,3,
            59,0,0,10,3,0,77,39,0,0,
            2,0,10,0,41,73,72,0,62,10,
            3,62,47,10,0,0,54,3,3,0,
            40,2,0,0,2,0,1,0,0,0,
            3,3,3,0,0,40,3,0,0,2,
            0,40,0,74,0,3,0,3,0,3,
            0,3,0,0,0,0,0,0,0,0,
            0,0,75,40,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            259,1985,212,280,3776,4429,4359,4572,4357,4323,
            4323,4212,4323,292,1790,4171,218,218,218,218,
            176,3991,4373,4374,4375,4376,4377,4368,4366,4369,
            4367,4365,668,4370,4372,4371,4573,4425,182,182,
            182,182,3737,4423,4424,4356,1920,4323,3963,4427,
            4428,4431,4430,4323,1985,278,4447,3776,4429,4359,
            4572,4357,4088,742,4093,404,4088,587,4093,404,
            1265,4195,35,4323,4323,4373,4374,4375,4376,4377,
            4368,4366,4369,4367,4365,668,4370,4372,4371,4573,
            4425,3608,3563,3518,3473,3737,4423,4424,4356,1920,
            178,3963,4427,4428,4431,4430,4323,1985,4323,4360,
            3776,4429,4359,4572,4357,4323,4323,4105,3608,3563,
            3518,3473,491,378,485,488,177,4171,4373,4374,
            4375,4376,4377,4368,4366,4369,4367,4365,668,4370,
            4372,4371,4573,4425,3608,3563,3518,3473,3737,4423,
            4424,4356,1920,4323,3963,4427,4428,4431,4430,4323,
            1985,139,948,3776,4429,4359,4572,4357,4088,4323,
            4093,404,4323,41,4323,4323,1265,408,4359,4572,
            4357,4373,4374,4375,4376,4377,4368,4366,4369,4367,
            4365,668,4370,4372,4371,4573,4425,65,4323,3950,
            852,3737,4423,4424,4356,1920,1725,3963,4427,4428,
            4431,4430,83,1985,211,275,3776,4429,4359,4572,
            4357,4359,4572,4357,4323,3959,4121,4100,219,219,
            219,219,4323,384,4373,4374,4375,4376,4377,4368,
            4366,4369,4367,4365,668,4370,4372,4371,4573,4425,
            274,4323,249,4323,3737,4423,4424,4356,1920,249,
            3963,4427,4428,4431,4430,140,1985,147,139,3776,
            4429,4359,4572,4357,61,293,4323,309,4323,40,
            4359,4572,4357,4359,4572,4357,944,4373,4374,4375,
            4376,4377,4368,4366,4369,4367,4365,668,4370,4372,
            4371,4573,4425,41,3966,4129,852,3737,4423,4424,
            4356,1920,247,3963,4427,4428,4431,4430,4359,4572,
            4357,249,4322,170,1421,4323,503,4323,4088,1855,
            4093,404,174,4323,4373,4374,4375,4376,4377,4368,
            4366,4369,4367,4365,4351,4370,4372,4371,4573,4323,
            4323,171,2440,195,301,4359,4572,4357,203,3425,
            3425,174,273,4323,852,2050,203,219,219,219,
            219,4373,4374,4375,4376,4377,4368,4366,4369,4367,
            4365,845,4370,4372,4371,4573,145,4323,3377,3377,
            195,203,4081,4323,203,175,4076,195,3997,203,
            219,219,219,219,183,183,183,183,219,219,
            219,219,4323,4081,2115,196,4323,4076,229,3997,
            202,183,742,4323,175,195,203,169,202,4359,
            4572,4357,195,163,203,219,219,219,219,4323,
            157,2180,4323,4323,151,4373,4374,4375,4376,4377,
            4368,4366,4369,4367,4365,4351,4370,4372,4371,4573,
            4323,4323,152,4113,4336,4337,4359,4572,4357,4333,
            1725,4335,175,4338,4323,4323,195,203,4332,4329,
            4331,4330,384,195,2635,203,219,219,219,219,
            183,183,183,183,4323,184,4162,251,4334,194,
            4323,4324,4326,4359,4572,4357,194,4327,388,397,
            2635,4323,4323,2245,4328,2895,156,4602,4325,4373,
            4374,4375,4376,4377,4368,4366,4369,4367,4365,845,
            4370,4372,4371,4573,157,287,4323,4323,195,203,
            4323,4323,770,175,1021,195,158,203,219,219,
            219,219,183,183,183,183,4323,4323,198,40,
            3653,393,3896,3896,4323,164,4323,3695,943,163,
            3857,3857,175,195,203,169,671,4600,175,4323,
            195,163,203,219,219,219,219,183,183,183,
            183,234,4323,162,4599,3155,139,4359,499,4357,
            169,388,397,66,195,203,168,175,40,175,
            169,195,2310,203,219,219,219,219,183,183,
            183,183,147,139,3950,147,139,4121,4420,188,
            139,4323,589,3653,40,852,197,40,175,110,
            3695,3896,41,4179,4088,4323,4093,404,187,3857,
            4081,742,3653,1492,4076,384,3997,388,397,3695,
            92,852,65,186,852,65,185,3653,4323,852,
            3653,4449,4323,4323,3695,4323,4450,3695,2635,1421,
            148,56,1421,2635,4323,4212,4323,4105,4323,4323,
            4216,65,3272,4171,281,4323,871,4426,254,256,
            313,4323,4323,4323,88,4323,4547,4113,4323,4323,
            4323,4323,4121,3326,4383,62,4323,2505,2570,4323,
            84,4323,4323,675,4382,4230,4323,773,139,3215,
            1025,4323,153,165,4323,159,141,4453,150,4323,
            4323,1113,4323,4187,136,1190,2635,4323,1267,4323,
            4323,2310,1341,310,742,4323,4323,4323,1342,4454,
            4578,4323,260,4150,4581,4323,4595,852,263,72,
            4203,4323,1563,144,3326,2375,2700,4323,4405,4220,
            4580,4404,3272,1654,4323,4323,3215,4448,4451,4323,
            2830,3942,4323,4323,3980,135,1344,4323,4323,4323,
            4452,4576,4442,4323,4323,2960,4439,65,4323,4121,
            4323,3025,4323,2765,4323,4455,4323,4443,4323,4441,
            4323,4440,4323,4323,4323,4323,4323,4323,4323,4323,
            4323,4323,4548,3090
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            406,54,56,104,481,481,463,463,463,419,
            463,463,242,100,242,110,30,113,33,102,
            101,213,227,213,213,481,481,481,463,481,
            481,311,324,325,483,52,481,63,328,59,
            124,166,169,166,213,356,213,67,71,69,
            77,75,63,79,78,246,248,250,253,213,
            213,242,51,161,256,258,80,266,122,122,
            260,213,213,213,481,242,213,307,242,227,
            96,485,227,484,227,213,122,273,313,242,
            390,1,1,227,315,242,242,35,242,393,
            213,213,213,213,213,213,63,317,481,213,
            213,213,213,213,213,213,213,213,242,439,
            439,320,325,323,60,330,361,396,118,393,
            481,107,397,395,396,397,393,213,122,122,
            121,328,59,121,63,79,63,77,63,71,
            71,63,67,67,242,213,227,63,69,69,
            69,69,63,75,63,78,213,213,390,227,
            96,390,227,361,213,62,393,107,242,242,
            213,213,399,211,211,122,227,213,273,122,
            361,439,393,107,393,208,393,213,393,106,
            107,393,361,60,330,361,361,393,271,270,
            269,107,333,481,242,481,204,401,227,212,
            393,273,62,393,393,213,242,213,242,213,
            213,421,441,361,393,271,393,271,403,107,
            271,107,334,393,213,213,213,393,393,393
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            62,48,4,42,1,46,22,23,24,25,
            26,32,51,52,5,49,50,44,43,31,
            28,30,27,29,33,35,34,36,45,8,
            7,6,37,0,6,8,7,41,58,42,
            47,54,19,21,20,18,9,38,11,4,
            13,5,0,71,0,2,69,37,57,12,
            1,39,14,15,16,17,5,13,11,4,
            18,19,20,21,9,38,41,47,54,58,
            3,62,68,40,10,72,73,74,75,76,
            59,63,65,66,67,77,55,53,56,60,
            71,64,0,71,9,2,3,10,0,64,
            12,0,6,37,7,8,71,9,2,0,
            39,1,0,11,4,5,13,9,38,3,
            62,68,14,40,10,15,72,16,17,73,
            74,75,41,47,54,58,76,55,59,63,
            60,64,77,53,65,66,67,56,71,37,
            18,19,20,21,0,1,61,0,11,4,
            5,13,18,19,9,20,21,38,3,62,
            68,14,40,10,15,72,16,17,73,74,
            75,41,47,54,58,76,55,59,63,53,
            65,56,61,60,64,77,71,67,66,0,
            3,70,48,4,42,1,46,51,52,5,
            49,50,37,44,43,45,31,28,30,27,
            29,33,35,34,36,22,23,24,25,26,
            32,8,7,6,0,58,0,47,0,9,
            38,0,11,4,0,41,0,54,0,59,
            63,65,66,67,12,3,71,9,10,69,
            40,0,1,11,4,5,13,18,19,9,
            20,21,38,3,62,68,14,40,10,15,
            72,16,17,73,74,75,41,47,54,58,
            76,55,53,66,67,56,60,64,77,71,
            63,65,59,0,73,0,76,10,0,2,
            1,0,1,2,55,53,56,12,0,68,
            10,0,69,11,4,5,13,18,19,9,
            20,21,38,3,10,41,47,54,58,40,
            12,1,39,2,57,14,15,17,16,0,
            48,4,42,1,46,22,23,24,25,26,
            32,51,52,5,49,50,37,44,43,31,
            28,30,27,29,33,35,34,36,45,8,
            7,6,3,0,72,10,62,0,74,0,
            75,0,40,2,0,71,7,64,60,55,
            56,59,63,65,67,66,8,6,53,0,
            31,28,30,27,29,33,35,34,36,6,
            8,7,22,23,24,25,26,32,9,0,
            59,63,65,31,28,30,27,29,33,35,
            34,36,6,8,7,22,23,24,25,26,
            32,0,22,23,24,25,26,31,28,30,
            27,29,33,35,34,36,32,6,8,7,
            2,0,12,60,77,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            88,20,20,20,20,20,19,19,19,20,
            19,19,30,6,19,20,19,20,20,4,
            4,16,18,16,16,20,20,20,19,20,
            20,84,20,25,91,20,20,20,20,12,
            20,20,20,20,16,20,16,20,20,20,
            20,20,20,20,20,20,20,20,20,78,
            78,93,20,20,20,20,20,20,20,20,
            20,16,16,16,20,96,16,10,19,19,
            8,20,19,6,19,16,20,20,20,101,
            104,16,16,18,20,19,19,1,19,20,
            36,48,60,60,72,72,20,20,20,78,
            78,66,66,66,66,54,42,16,96,20,
            20,20,25,20,23,20,16,20,20,20,
            20,20,20,20,20,20,20,16,20,20,
            23,20,23,12,20,20,20,20,20,20,
            20,20,20,20,33,16,18,20,20,20,
            20,20,20,20,20,20,16,16,19,18,
            8,19,18,16,16,23,20,20,27,98,
            16,16,20,16,16,20,19,16,20,20,
            14,20,20,20,20,86,20,16,20,20,
            20,20,16,23,20,16,16,20,20,20,
            20,20,12,20,19,20,21,20,18,16,
            20,20,23,20,20,16,33,16,19,16,
            16,18,18,16,20,20,20,20,20,20,
            20,20,12,20,16,16,16,20,20,20
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            2,106,0,91,0,81,0,78,0,88,
            0,71,0,65,69,6,16,3,2,0,
            89,0,72,0,99,0,2,92,0,2,
            120,0,2,69,0,6,16,3,2,59,
            0,3,6,16,2,56,0,6,16,3,
            2,53,0,3,6,16,2,50,0,6,
            16,3,2,47,0,3,6,16,2,44,
            0,6,16,3,2,41,0,2,6,16,
            3,34,0,121,0,119,0,116,118,2,
            98,0,2,110,0,101,100,2,65,0,
            2,109,0,108,2,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,20,12,2,3,30,75,78,7,19,
            1,21,4,17,23,26,27,5,6,8,
            9,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,76,33,10,25,18,
            39,42,31,32,34,35,40,44,46,47,
            48,49,70,41,64,74,15,43,65,67,
            13,14,66,68,71,72,73,16,22,28,
            77,24,36,37,38,45,69,79,80,81
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            84,85,83,0,87,89,0,0,0,0,
            0,0,0,0,0,99,0,0,0,0,
            0,0,0,0,0,101,0,0,0,0,
            104,0,0,129,130,0,0,0,125,126,
            127,122,123,124,119,120,121,116,117,118,
            113,114,115,110,111,112,107,108,109,92,
            102,105,0,106,91,0,0,86,93,103,
            136,0,88,0,0,0,0,133,96,128,
            145,0,0,0,95,98,0,134,135,138,
            139,94,0,97,0,0,137,141,147,148,
            149,0,152,0,0,82,0,90,100,131,
            132,0,140,0,0,142,143,144,146,150,
            151,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            195,231,241,129,163,171,217,251,205,15,
            28,149,156,1,9,138,189,123,179,225,
            144,37,259,265,269,273,277,116,55,22,
            46,58,58,66,66,74,74,74,74,88,
            88,96,101,106,111
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            7,7,7,7,7,7,7,7,213,7,
            35,7,7,7,7,7,7,120,185,213,
            7,42,263,263,263,7,7,120,7,25,
            49,60,63,68,71,76,79,82,85,90,
            93,98,103,108,113
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            25,24,24,27,27,27,25,24,25,27,
            37,27,27,38,38,27,27,30,27,25,
            27,37,11,10,10,7,6,30,35,36,
            37,41,41,44,44,47,47,47,47,50,
            50,53,56,59,63
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            3,3,3,3,3,3,3,3,40,3,
            75,3,3,3,3,3,3,68,10,40,
            3,74,62,62,62,3,3,68,3,76,
            73,13,5,4,11,21,20,19,18,38,
            9,41,47,54,58
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,1,1,9,9,9,
            9,13,13,15,15,19,19,19,19,21,
            21,22,23,24,25
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            176,1,81,16,106,0,3,0,176,1,
            81,17,106,0,156,1,151,81,14,106,
            0,190,48,0,76,140,0,140,74,140,
            73,140,46,0,75,0,140,73,140,46,
            0,74,140,75,0,140,46,0,73,140,
            74,140,75,0,140,1,0,120,0,13,
            114,0,5,114,0,123,0,4,121,0,
            11,121,0,126,0,21,124,0,20,124,
            0,19,124,0,18,124,0,129,0,38,
            127,0,9,127,0,132,0,41,130,0,
            135,0,47,133,0,138,0,54,136,0,
            144,0,58,139,0,150,57,81,0,68,
            152,0,150,57,81,15,106,0,156,1,
            152,148,12,85,15,106,0,156,1,148,
            12,85,0,156,1,152,81,0,156,1,
            152,81,15,106,0,156,1,152,186,15,
            106,0,150,10,81,1,81,14,106,0,
            150,10,141,1,81,14,106,0,141,1,
            81,14,106,0,10,150,3,0,140,1,
            81,14,106,0,140,40,149,69,165,1,
            81,14,106,0,149,69,165,1,81,14,
            106,0,40,140,3,0,140,40,149,1,
            81,14,106,0,149,1,81,14,106,0,
            140,40,165,10,145,1,81,14,106,0,
            140,40,165,10,81,1,81,14,106,0,
            140,40,165,1,81,14,106,0,189,61,
            32,0,62,0,173,61,86,0,173,61,
            83,0,187,1,32,0,153,1,83,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            3980,3942,4203,4129,4121,4113,4105,3950,3896,3857,
            3776,3737,3695,3653,3608,3563,3518,3473,3425,3377,
            3326,3272,3215,3155,3090,3025,2960,1344,589,1654,
            2895,2830,1563,1267,1190,1113,2765,503,1492,773,
            675,1025,2700,2635,948,2570,2505,2440,2375,871,
            2310,408,313,1421,2245,2180,2115,2050,1985,1920,
            1855,1790,1725,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,184,82,81,66,67,65,63,59,56,
            53,55,60,178,64,198,196,7,197,193,
            191,9,2,2,2,157,157,157,53,157,
            157,200,81,85,85,12,81,115,85,81,
            96,32,86,83,46,106,1,119,125,122,
            131,128,111,137,134,144,135,129,123,42,
            4,48,120,126,132,138,142,153,32,83,
            85,2,2,2,157,2,2,201,2,12,
            179,195,12,178,12,57,152,151,39,61,
            1,61,61,1,140,16,17,15,14,140,
            58,47,38,9,4,11,111,190,81,13,
            5,21,20,19,18,41,54,9,2,181,
            145,81,85,148,148,150,1,189,81,187,
            81,188,173,140,174,173,153,73,81,81,
            186,85,81,81,111,138,111,132,111,126,
            126,111,120,120,10,76,2,111,123,123,
            123,123,111,129,111,135,9,9,1,2,
            179,1,2,1,10,68,156,150,10,10,
            72,10,140,1,1,152,12,57,152,151,
            1,153,182,183,182,153,156,74,176,70,
            177,176,1,148,150,1,1,140,149,165,
            145,141,81,3,10,3,199,140,2,10,
            156,152,68,156,156,40,69,40,10,10,
            10,2,2,1,140,149,140,165,81,150,
            165,150,81,156,40,40,40,140,140,140
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@",
            "^",
            "^^",
            "?",
            "$empty",
            "QUOTED_IDENTIFIER",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "STRING_LITERAL",
            "self",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "null",
            "invalid",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "OclInvalid",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "body",
            "derive",
            "init",
            "static",
            "import",
            "OclMessage",
            "EOF_TOKEN",
            "IDENTIFIER",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "ERROR_TOKEN",
            "conceptualOperationNameCS",
            "CollectionTypeIdentifierCS",
            "simpleNameCS",
            "QuotedSimpleNameCS",
            "unreservedSimpleNameCS",
            "pathNameCS",
            "typeCS",
            "collectionTypeCS",
            "tupleTypePartsCS",
            "typedUninitializedVariableCS",
            "OclExpressionCS",
            "typedInitializedVariableCS",
            "initializedVariableCS",
            "uninitializedVariableCS",
            "VariableDeclarationCS",
            "CollectionLiteralPartsCS",
            "CollectionLiteralPartCS",
            "StringLiteralExpCS",
            "TupleLiteralPartsCS",
            "primaryExpCS",
            "notNameExpressionCS",
            "argumentsCS",
            "SimpleNameExpCS",
            "impliesNotNameNotLetCS",
            "impliesNotLetCS",
            "xorNotNameNotLetCS",
            "xorNotLetCS",
            "xorWithLetCS",
            "orNotNameNotLetCS",
            "orNotLetCS",
            "orWithLetCS",
            "andNotNameNotLetCS",
            "andNotLetCS",
            "andWithLetCS",
            "equalityNotNameNotLetCS",
            "equalityNotLetCS",
            "equalityWithLetCS",
            "relationalNotNameNotLetCS",
            "relationalNotLetCS",
            "relationalWithLetCS",
            "additiveNotNameNotLetCS",
            "additiveNotLetCS",
            "additiveWithLetCS",
            "multiplicativeNotNameNotLetCS",
            "multiplicativeNotLetCS",
            "multiplicativeWithLetCS",
            "unaryNotLetCS",
            "unaryWithLetCS",
            "primaryNotNameCS",
            "letVariablesCS",
            "packageDeclarationsCS",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "isMarkedPreCS",
            "OclMessageArgumentsCS",
            "OclMessageArgCS",
            "packageDeclarationCS_A",
            "importCS",
            "contextDeclsCS",
            "importCS_0",
            "importCS_1",
            "importCS_2",
            "contextDeclCS",
            "initOrDerValuesCS",
            "invOrDefsCS",
            "defExpressionCS",
            "operationCS1",
            "operationCS2",
            "prePostOrBodyDeclsCS",
            "parametersCS"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
