/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.ui.wizards.typecreation.TypeInfo;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class TypeCreator {
    private TypeInfo _typeInfo;
    private boolean _addComments;
    private IType _createdType;
    private String _defaultSupertypeName = this.createDefaultSupertypeName();
    private StubTypeContext fSuperClassStubTypeContext;
    private StubTypeContext fSuperInterfaceStubTypeContext;

    public void setTypeInfo(TypeInfo typeInfo) {
        this._typeInfo = typeInfo;
    }

    protected TypeInfo getTypeInfo() {
        return this._typeInfo;
    }

    public void setAddComments(boolean addComments) {
        this._addComments = addComments;
    }

    protected abstract String createDefaultSupertypeName();

    protected String getDefaultSupertypeName() {
        return this._defaultSupertypeName;
    }

    private void setCreatedType(IType createdType) {
        this._createdType = createdType;
    }

    /*
     * Unable to fully structure code
     */
    public IType createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewTypeWizardPage_operationdesc, 10);
        createdWorkingCopies = new ArrayList<ICompilationUnit>();
        try {
            this.validateTypeCreation();
            pack = this.getPackageFragment();
            monitor.worked(1);
            indent = 0;
            lineDelimiter = null;
            needsSave = false;
            enclosingType = this.getEnclosingType();
            teamCU = null;
            teamAST = null;
            existingImports = null;
            newAST = null;
            if (enclosingType != null) {
                teamCU = enclosingType.getCompilationUnit();
                needsSave = teamCU.isWorkingCopy() == false;
                teamCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                createdWorkingCopies.add(teamCU);
                teamAST = this.createASTForImports(teamCU);
            } else if (this._typeInfo.isInlineType()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", "missing enclosing type for inline type"));
            }
            if (!this._typeInfo.isInlineType()) {
                lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)pack.getJavaProject());
                newCU = pack.createCompilationUnit(String.valueOf(this._typeInfo.getTypeName()) + ".java", "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                needsSave = true;
                newCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                createdWorkingCopies.add(newCU);
                buffer = newCU.getBuffer();
                cuContent = this.constructCUContent(newCU, this.constructSimpleTypeStub(), lineDelimiter);
                buffer.setContents(cuContent);
                newAST = this.createASTForImports(newCU);
                existingImports = this.getExistingImports(newAST);
                imports = teamAST != null ? new ImportsManager(newAST, teamAST) : new ImportsManager(newAST);
                imports.addImport(JavaModelUtil.concatenateName((String)pack.getElementName(), (String)this._typeInfo.getTypeName()));
                typeContent = this.constructTypeStub(newCU, imports, lineDelimiter);
                typeNode = (AbstractTypeDeclaration)newAST.types().get(0);
                start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                end = typeNode.getStartPosition() + typeNode.getLength();
                buffer.replace(start, end - start, typeContent);
                createdType = newCU.getType(this._typeInfo.getTypeName());
            } else {
                imports = new ImportsManager(teamAST);
                existingImports = this.getExistingImports(teamAST);
                topLevelTypes = teamCU.getTypes();
                i = 0;
                while (i < topLevelTypes.length) {
                    imports.addImport(topLevelTypes[i].getFullyQualifiedName('.'));
                    ++i;
                }
                lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)enclosingType);
                content = new StringBuffer();
                if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc") && (comment = this.getTypeComment(teamCU, lineDelimiter)) != null) {
                    content.append(comment);
                    content.append(lineDelimiter);
                }
                content.append(this.constructTypeStub(teamCU, imports, lineDelimiter));
                elems = enclosingType.getChildren();
                sibling = elems.length > 0 ? elems[0] : null;
                createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                indent = StubUtility.getIndentUsed((IJavaElement)enclosingType) + 1;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            cu = createdType.getCompilationUnit();
            imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            if (imports.fHasAddedBaseImportsForRofi) {
                teamCU.commitWorkingCopy(true, monitor);
                teamCU.save(monitor, true);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            astRoot = this.createASTForImports(imports.getCompilationUnit());
            imports = new ImportsManager(astRoot);
            this.createTypeMembers(createdType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.removeUnusedImports(cu, existingImports, false);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            range = createdType.getSourceRange();
            buf = cu.getBuffer();
            originalContent = buf.getText(range.getOffset(), range.getLength());
            formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)indent, (String)lineDelimiter, (IJavaProject)pack.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
            buf.replace(range.getOffset(), range.getLength(), formattedContent);
            if (!this._typeInfo.isInlineType() && (fileComment = this.getFileComment(cu)) != null && fileComment.length() > 0) {
                buf.replace(0, 0, String.valueOf(fileComment) + lineDelimiter);
            }
            if (needsSave) {
                cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            this.setCreatedType(createdType);
        }
        finally {
            ** for (wc : createdWorkingCopies)
        }
lbl-1000:
        // 1 sources

        {
            wc.discardWorkingCopy();
            continue;
        }
lbl105:
        // 1 sources

        monitor.done();
        return this._createdType;
    }

    private CompilationUnit createASTForImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        return (CompilationUnit)parser.createAST(null);
    }

    private Set<String> getExistingImports(CompilationUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)((ImportDeclaration)imports.get(i))));
            ++i;
        }
        return res;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment((int)next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected String getFileComment(ICompilationUnit parentCU) {
        return null;
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this._addComments) {
            return CodeGeneration.getFileComment((ICompilationUnit)parentCU, (String)lineDelimiter);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) {
        try {
            StringBuffer typeName = new StringBuffer();
            typeName.append(this._typeInfo.getTypeName());
            String comment = CodeGeneration.getTypeComment((ICompilationUnit)parentCU, (String)typeName.toString(), (String)lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return null;
    }

    private void removeUnusedImports(ICompilationUnit cu, Set<String> existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)((ASTNode)importsDecls.get(importsDecls.size() - 1)));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    private IType getEnclosingType() throws CoreException {
        IType enclosingType = null;
        if (this._typeInfo.getEnclosingTypeName().trim().length() != 0) {
            try {
                enclosingType = this._typeInfo.getPkgFragmentRoot().getJavaProject().findType(this._typeInfo.getEnclosingTypeName());
                if (enclosingType == null || enclosingType.getCompilationUnit() == null) {
                    throw new Exception("The enclosing type " + this._typeInfo.getEnclosingTypeName() + " or its compilation unit does not exist.");
                }
                if (!JavaModelUtil.isEditable((ICompilationUnit)enclosingType.getCompilationUnit())) {
                    throw new Exception("The compilation unit of the enclosing type " + this._typeInfo.getEnclosingTypeName() + " is not editable!");
                }
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", 0, ex.getMessage(), null));
            }
        }
        return enclosingType;
    }

    private IPackageFragment getPackageFragment() throws JavaModelException, CoreException {
        IPackageFragment pkgFragment = null;
        IType enclosingType = this.getEnclosingType();
        if (enclosingType == null) {
            pkgFragment = this._typeInfo.getPkgFragment();
            if (pkgFragment == null) {
                pkgFragment = this._typeInfo.getPkgFragmentRoot().getPackageFragment("");
            }
        } else if (this._typeInfo.isInlineType()) {
            pkgFragment = enclosingType.getPackageFragment();
        } else {
            String qualifiedEnclosingTypeName = this.getEnclosingType().getFullyQualifiedName('.');
            pkgFragment = this._typeInfo.getPkgFragmentRoot().getPackageFragment(qualifiedEnclosingTypeName);
        }
        if (!pkgFragment.exists()) {
            pkgFragment = this._typeInfo.getPkgFragmentRoot().createPackageFragment(pkgFragment.getElementName(), true, null);
        }
        return pkgFragment;
    }

    protected void validateTypeCreation() throws CoreException {
        if (this._typeInfo.isInlineType() && this._typeInfo.getEnclosingTypeName().trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", 0, "The class " + this._typeInfo.getTypeName() + " is declared to be an inner class" + " but fails to specify its enclosing type.", null));
        }
    }

    private String constructSimpleTypeStub() {
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(this._typeInfo.getTypeName());
        buf.append("{ }");
        return buf.toString();
    }

    private String constructTypeStub(ICompilationUnit parentCU, ImportsManager imports, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        buf.append(Flags.toString((int)this._typeInfo.getModifiers()));
        if (this._typeInfo.getModifiers() != 0) {
            buf.append(' ');
        }
        buf.append("class ");
        buf.append(this._typeInfo.getTypeName());
        this.writeInheritanceRelations(imports, buf);
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody((String)"org.eclipse.jdt.ui.text.codetemplates.classbody", (ICompilationUnit)parentCU, (String)this._typeInfo.getTypeName(), (String)lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    protected void writeInheritanceRelations(ImportsManager imports, StringBuffer buf) throws CoreException {
        this.writeSuperClass(buf, imports);
        this.writeSuperInterfaces(buf, imports);
    }

    private void writeSuperClass(StringBuffer buf, ImportsManager imports) throws CoreException {
        String superclass = this._typeInfo.getSuperClassName();
        if (superclass.length() > 0 && !"java.lang.Object".equals(superclass) && !String.valueOf(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM).equals(superclass)) {
            buf.append(" extends ");
            ITypeBinding binding = TypeContextChecker.resolveSuperClass((String)superclass, (IType)this._typeInfo.getCurrentType(), (StubTypeContext)this.getSuperClassStubTypeContext());
            if (binding != null) {
                buf.append(imports.addImport(binding));
            } else {
                buf.append(imports.addImport(superclass));
            }
        }
    }

    protected StubTypeContext getSuperClassStubTypeContext() throws CoreException {
        if (this.fSuperClassStubTypeContext == null) {
            String typeName = this._typeInfo.getCurrentType() != null ? this._typeInfo.getTypeName() : "$$__$$";
            this.fSuperClassStubTypeContext = TypeContextChecker.createSuperClassStubTypeContext((String)typeName, (IType)this.getEnclosingType(), (IPackageFragment)this.getPackageFragment());
        }
        return this.fSuperClassStubTypeContext;
    }

    protected StubTypeContext getBaseTypeStubTypeContext() throws CoreException {
        if (this.fSuperClassStubTypeContext == null) {
            String typeName = this._typeInfo.getCurrentType() != null ? this._typeInfo.getTypeName() : "$$__$$";
            this.fSuperClassStubTypeContext = this.createBaseTypeStubTypeContext(typeName, false, this.getEnclosingType(), this.getPackageFragment());
        }
        return this.fSuperClassStubTypeContext;
    }

    private StubTypeContext createBaseTypeStubTypeContext(String typeName, boolean isInterface, IType enclosingType, IPackageFragment packageFragment) {
        if (enclosingType == null) {
            JavaPlugin.log((Throwable)new IllegalArgumentException("Missing enclosing type"));
            return new StubTypeContext(null, null, null);
        }
        ICompilationUnit cu = enclosingType.getCompilationUnit();
        StringBuffer teamString = new StringBuffer();
        teamString.append("package ").append(packageFragment.getElementName()).append(";\n");
        teamString.append("public");
        int levels = this.writeClassHeader(enclosingType, teamString);
        int i = 0;
        while (i < levels) {
            teamString.append('}');
            ++i;
        }
        String prolog = "class " + typeName + (isInterface ? " implements " : " extends ");
        String epilog = " {} ";
        return new StubTypeContext(cu, String.valueOf(teamString.toString()) + prolog, epilog);
    }

    private int writeClassHeader(IType type, StringBuffer buf) {
        IJavaElement parent = type.getParent();
        int nestingLevels = 1;
        if (parent instanceof IType) {
            nestingLevels += this.writeClassHeader((IType)parent, buf);
        }
        buf.append(" class ").append(type.getElementName()).append(" {");
        return nestingLevels;
    }

    private void writeSuperInterfaces(StringBuffer buf, ImportsManager imports) throws CoreException {
        List<String> interfaces = this._typeInfo.getSuperInterfacesNames();
        int last = interfaces.size() - 1;
        if (last >= 0) {
            buf.append(" implements ");
            String[] intfs = interfaces.toArray(new String[interfaces.size()]);
            IType currentType = this._typeInfo.getCurrentType();
            ITypeBinding[] bindings = currentType != null ? TypeContextChecker.resolveSuperInterfaces((String[])intfs, (IType)currentType, (StubTypeContext)this.getSuperInterfacesStubTypeContext()) : new ITypeBinding[intfs.length];
            int i = 0;
            while (i <= last) {
                ITypeBinding binding = bindings[i];
                if (binding != null) {
                    buf.append(imports.addImport(binding));
                } else {
                    buf.append(imports.addImport(intfs[i]));
                }
                if (i < last) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    protected StubTypeContext getSuperInterfacesStubTypeContext() throws CoreException {
        if (this.fSuperInterfaceStubTypeContext == null) {
            String typeName = this._typeInfo != null ? this._typeInfo.getTypeName() : "$$__$$";
            this.fSuperInterfaceStubTypeContext = TypeContextChecker.createSuperInterfaceStubTypeContext((String)typeName, (IType)this.getEnclosingType(), (IPackageFragment)this.getPackageFragment());
        }
        return this.fSuperInterfaceStubTypeContext;
    }

    private String createCUHeaderFromScratch(IPackageFragment pack, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        if (this._typeInfo.isRole()) {
            buf.append("team ");
            buf.append("package ").append(pack.getElementName()).append(';');
        } else if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        return buf.toString();
    }

    private String getCompilationUnitContent(ICompilationUnit cu, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packageString = this._typeInfo.isRole() ? "team package " : "package ";
        String packDecl = pack.isDefaultPackage() ? "" : String.valueOf(packageString) + pack.getElementName() + ';';
        Template template = TypeCreator.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.newtype", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)cu.getElementName()));
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return TypeCreator.evaluateTemplate(context, template, fullLine);
    }

    private static Template getCodeTemplate(String id, IJavaProject project) {
        if (project == null) {
            return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            JavaPlugin.log((Throwable)e);
        }
        return projectStore.findTemplateById(id);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = TypeCreator.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces((String)str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = TypeCreator.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces((String)str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String fileComment = this.getFileComment(cu, lineDelimiter);
        String typeComment = this.getTypeComment(cu, lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = this.getCompilationUnitContent(cu, fileComment, typeComment, typeContent, lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setUnitName(cu.getPath().toString());
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        System.out.println("TypeCreator: does this ever happen?");
        StringBuffer buf = new StringBuffer();
        buf.append(this.createCUHeaderFromScratch(pack, lineDelimiter));
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    private void createTypeMembers(IType type, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(type, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this._typeInfo.isCreateMainMethod()) {
            StringBuffer buf = new StringBuffer();
            buf.append("public static void main(");
            buf.append(imports.addImport("java.lang.String"));
            buf.append("[] args) {}");
            type.createMethod(buf.toString(), null, false, null);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    protected IMethod[] createInheritedMethods(IType type, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        IMethod[] typeMethods = type.getMethods();
        HashSet<String> handleIds = new HashSet<String>(typeMethods.length);
        int index = 0;
        while (index < typeMethods.length) {
            handleIds.add(typeMethods[index].getHandleIdentifier());
            ++index;
        }
        ArrayList<IMethod> newMethods = new ArrayList<IMethod>();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = this._addComments;
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITypeBinding binding = ASTNodes.getTypeBinding((CompilationUnit)unit, (IType)type);
        if (binding != null) {
            AddUnimplementedMethodsOperation operation;
            if (this._typeInfo.isCreateAbstractInheritedMethods()) {
                operation = new AddUnimplementedMethodsOperation(unit, binding, null, -1, false, true, false);
                operation.setCreateComments(this._addComments);
                operation.run(monitor);
                this.createImports(imports, operation.getCreatedImports());
            }
            if (this._typeInfo.isCreateConstructor()) {
                operation = new AddUnimplementedConstructorsOperation(unit, binding, null, -1, false, true, false);
                operation.setCreateComments(this._addComments);
                operation.run(monitor);
                this.createImports(imports, operation.getCreatedImports());
            }
        }
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        typeMethods = type.getMethods();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            if (!handleIds.contains(typeMethods[index2].getHandleIdentifier())) {
                newMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        IMethod[] methods = new IMethod[newMethods.size()];
        newMethods.toArray(methods);
        return methods;
    }

    private void createImports(ImportsManager imports, String[] createdImports) {
        int index = 0;
        while (index < createdImports.length) {
            imports.addImport(createdImports[index]);
            ++index;
        }
    }

    public static class ImportsManager {
        ImportRewrite fImportsRewrite;
        ImportRewrite fTeamImportsRewrite;
        boolean fHasAddedBaseImportsForRofi;

        ImportsManager(CompilationUnit astRoot) throws CoreException {
            this.fImportsRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        }

        ImportsManager(CompilationUnit astRoot, CompilationUnit teamAST) throws CoreException {
            this.fImportsRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
            this.fTeamImportsRewrite = StubUtility.createImportRewrite((CompilationUnit)teamAST, (boolean)true);
        }

        ImportsManager(ICompilationUnit createdWorkingCopy) throws CoreException {
            this.fImportsRewrite = StubUtility.createImportRewrite((ICompilationUnit)createdWorkingCopy, (boolean)true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            return this.fImportsRewrite.addImport(qualifiedTypeName);
        }

        public String addImport(ITypeBinding typeBinding) {
            return this.fImportsRewrite.addImport(typeBinding);
        }

        void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
            TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
            JavaModelUtil.applyEdit((ICompilationUnit)this.fImportsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)needsSave, null);
            if (this.fTeamImportsRewrite != null) {
                edit = this.fTeamImportsRewrite.rewriteImports(monitor);
                this.fHasAddedBaseImportsForRofi = edit.hasChildren();
                JavaModelUtil.applyEdit((ICompilationUnit)this.fTeamImportsRewrite.getCompilationUnit(), (TextEdit)edit, (boolean)needsSave, null);
            }
        }

        void removeImport(String qualifiedName) {
            this.fImportsRewrite.removeImport(qualifiedName);
        }

        void removeStaticImport(String qualifiedName) {
            this.fImportsRewrite.removeStaticImport(qualifiedName);
        }
    }
}

