/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RWLock
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    private long timeoutMillis;

    public RWLock(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public RWLock(long timeoutMillis, boolean fair) {
        super(fair);
        this.timeoutMillis = timeoutMillis;
    }

    public <V> V read(Callable<V> callable) {
        return RWLock.call(callable, this.readLock(), this.timeoutMillis);
    }

    public void read(Runnable runnable) {
        RWLock.run(runnable, this.readLock(), this.timeoutMillis);
    }

    public <V> V write(Callable<V> callable) {
        return RWLock.call(callable, this.writeLock(), this.timeoutMillis);
    }

    public void write(Runnable runnable) {
        RWLock.run(runnable, this.writeLock(), this.timeoutMillis);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V> V call(Callable<V> callable, Lock lock, long timeoutMillis) {
        try {
            boolean locked = lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!locked) throw new TimeoutException("Acquisition of lock timed out after " + timeoutMillis + " millis");
            try {
                V v = callable.call();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static void run(Runnable runnable, Lock lock, long timeoutMillis) {
        block6: {
            try {
                boolean locked = lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS);
                if (locked) {
                    try {
                        runnable.run();
                        break block6;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new TimeoutException("Acquisition of lock timed out after " + timeoutMillis + " millis");
            }
            catch (Exception ex) {
                throw WrappedException.wrap(ex);
            }
        }
    }
}

