/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.launcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DSPMainTab
extends AbstractLaunchConfigurationTab {
    private static final int DEFAULT_PORT = 4711;
    private static final String DEFAULT_SERVER = "127.0.0.1";
    private Text debugCommandText;
    private Text debugArgsText;
    private Text jsonText;
    private Button launchDebugServer;
    private Button monitorAdapterLauncherProcessCheckbox;
    private Button connectDebugServer;
    private Text serverHost;
    private Text serverPort;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setFont(parent.getFont());
        this.createVerticalSpacer(comp, 3);
        this.createDebugAdapterComponent(comp);
        this.createDebugJSonComponent(comp);
    }

    private void createDebugAdapterComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Debug Adapter Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Label debugText = new Label((Composite)group, 0);
        debugText.setText("We launch specific debug adapters using these settings. In future this could be handled by an extension point.");
        debugText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.launchDebugServer = new Button((Composite)group, 16);
        this.launchDebugServer.setText("&Launch a Debug Server using the following arguments:");
        this.launchDebugServer.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.launchDebugServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.launchDebugServer.setSelection(true);
        Label programLabel = new Label((Composite)group, 0);
        programLabel.setText("&Command:");
        programLabel.setLayoutData((Object)new GridData(1));
        this.debugCommandText = new Text((Composite)group, 2052);
        this.debugCommandText.setLayoutData((Object)new GridData(768));
        this.debugCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Label argsLabel = new Label((Composite)group, 0);
        argsLabel.setText("&Arguments:");
        argsLabel.setLayoutData((Object)new GridData(1));
        this.debugArgsText = new Text((Composite)group, 2052);
        this.debugArgsText.setLayoutData((Object)new GridData(768));
        this.debugArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Composite filler = new Composite((Composite)group, 0);
        filler.setLayoutData((Object)new GridData(0, 0));
        this.monitorAdapterLauncherProcessCheckbox = new Button((Composite)group, 32);
        GridData layoutData = new GridData(16384, -1, true, false);
        this.monitorAdapterLauncherProcessCheckbox.setLayoutData((Object)layoutData);
        this.monitorAdapterLauncherProcessCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.monitorAdapterLauncherProcessCheckbox.setText("Monitor Debug Adapter launcher process");
        this.connectDebugServer = new Button((Composite)group, 16);
        this.connectDebugServer.setText("Connect to &running Debug Server using the following arguments:");
        this.connectDebugServer.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        this.connectDebugServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        Label serverHostLabel = new Label((Composite)group, 0);
        serverHostLabel.setText("Server &Host:");
        serverHostLabel.setLayoutData((Object)new GridData(1));
        this.serverHost = new Text((Composite)group, 2052);
        this.serverHost.setLayoutData((Object)new GridData(768));
        this.serverHost.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Label serverPortLabel = new Label((Composite)group, 0);
        serverPortLabel.setText("Server &Port:");
        serverPortLabel.setLayoutData((Object)new GridData(1));
        this.serverPort = new Text((Composite)group, 2052);
        this.serverPort.setLayoutData((Object)new GridData(768));
        this.serverPort.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    private void createDebugJSonComponent(Composite parent) {
        Group comp = new Group(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Label jsonLabel = new Label((Composite)comp, 0);
        jsonLabel.setText("Launch &Parameters (Json):");
        jsonLabel.setLayoutData((Object)new GridData(1));
        this.jsonText = new Text((Composite)comp, 2626);
        this.jsonText.setLayoutData((Object)new GridData(1808));
        this.jsonText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSPMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void updateLaunchConfigurationDialog() {
        boolean launch = this.launchDebugServer.getSelection();
        this.debugCommandText.setEnabled(launch);
        this.debugArgsText.setEnabled(launch);
        this.monitorAdapterLauncherProcessCheckbox.setEnabled(launch);
        this.serverHost.setEnabled(!launch);
        this.serverPort.setEnabled(!launch);
        super.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", "");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Collections.emptyList());
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", DEFAULT_SERVER);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 4711);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", "");
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean launch = "launch server".equals(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server"));
            this.launchDebugServer.setSelection(launch);
            this.connectDebugServer.setSelection(!launch);
            this.debugCommandText.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", ""));
            List args = configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Collections.emptyList());
            if (args.size() == 0) {
                this.debugArgsText.setText("");
            } else if (args.size() == 1) {
                this.debugArgsText.setText((String)args.get(0));
            } else {
                this.debugArgsText.setText(String.join((CharSequence)" ", args.toArray(new String[args.size()])));
            }
            this.monitorAdapterLauncherProcessCheckbox.setSelection(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            this.serverHost.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", DEFAULT_SERVER));
            this.serverPort.setText(Integer.toString(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", 4711)));
            this.jsonText.setText(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean launch = this.launchDebugServer.getSelection();
        if (launch) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        } else {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "connect to server");
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", this.getAttributeValueFrom(this.debugCommandText));
        String arg = this.getAttributeValueFrom(this.debugArgsText);
        if (arg == null) {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", null);
        } else {
            configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", Arrays.asList(arg.split("\\s+")));
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", this.monitorAdapterLauncherProcessCheckbox.getSelection());
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_HOST", this.getAttributeValueFrom(this.serverHost));
        String portString = this.getAttributeValueFrom(this.serverPort);
        int port = 4711;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_SERVER_PORT", port);
        configuration.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", this.getAttributeValueFrom(this.jsonText));
    }

    protected String getAttributeValueFrom(Text text) {
        String value = text.getText().trim();
        if (!value.isEmpty()) {
            return value;
        }
        return null;
    }

    public String getName() {
        return "Debug Adapter";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean launch = this.launchDebugServer.getSelection();
        if (launch) {
            if (this.getAttributeValueFrom(this.debugCommandText) == null) {
                this.setMessage("Specify a debug adapter command");
                return false;
            }
        } else {
            if (this.getAttributeValueFrom(this.serverHost) == null) {
                this.setMessage("Specify a server host");
                return false;
            }
            try {
                int port = Integer.parseInt(this.getAttributeValueFrom(this.serverPort));
                if (port < 1 || port > 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.setMessage("Specify a port as an integer in the range 1-65535");
                return false;
            }
        }
        return true;
    }
}

