/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String[] KERNEL_SOURCE_PATH = new String[]{"/usr/src/kernels/{kernel_version}", "/usr/src/linux", "/usr/src/linux-{kernel_version}"};

    public void initializeDefaultPreferences() {
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        store.setDefault("UseStoredTreePreference", false);
        store.setDefault("RemoteProbes", false);
        store.setDefault("KernelSourcePreference", this.getKernelSourceLocation());
        store.setDefault("ExcludedKernelSource", "CVS/" + File.pathSeparator + ".svn/" + File.pathSeparator + "{arch}/" + File.pathSeparator + ".arch-ids/" + File.pathSeparator + ".bzr/" + File.pathSeparator + "debian/" + File.pathSeparator + ".git/");
        store.setDefault("RemoteLocalKernelSource", "local");
        store.setDefault("TapsetPreference", "");
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            store.setDefault(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            store.setDefault(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
            ++i;
        }
    }

    private String getKernelSourceLocation() {
        String version = "";
        try {
            Process process = RuntimeProcessFactory.getFactory().exec("uname -r", null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            version = reader.readLine();
        }
        catch (IOException process) {
            // empty catch block
        }
        String[] stringArray = KERNEL_SOURCE_PATH;
        int n = KERNEL_SOURCE_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(String.valueOf(path = path.replace("{kernel_version}", version)) + "/System.map");
            if (file.exists()) {
                return path;
            }
            ++n2;
        }
        return "";
    }
}

