/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.ContainerNotFoundException;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerRequestException;
import com.spotify.docker.client.exceptions.DockerTimeoutException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerChange;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.Ipam;
import com.spotify.docker.client.messages.Network;
import com.spotify.docker.client.messages.NetworkConfig;
import com.spotify.docker.client.messages.NetworkCreation;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.Version;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerContainerNotFoundException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerOpenConnectionException;
import org.eclipse.linuxtools.docker.core.DockerPingConnectionException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConfParameter;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnection2;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerChange;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IDockerIpamConfig;
import org.eclipse.linuxtools.docker.core.IDockerNetwork;
import org.eclipse.linuxtools.docker.core.IDockerNetworkConfig;
import org.eclipse.linuxtools.docker.core.IDockerNetworkCreation;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerVersion;
import org.eclipse.linuxtools.docker.core.ILogger;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.AbstractKillableThread;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.core.DefaultImageBuildProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DefaultImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DefaultImagePushProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerClientFactory;
import org.eclipse.linuxtools.internal.docker.core.DockerConnectionInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerConsoleOutputStream;
import org.eclipse.linuxtools.internal.docker.core.DockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerChange;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerExit;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerImageHierarchyNodeUtils;
import org.eclipse.linuxtools.internal.docker.core.DockerImageInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.core.DockerMessages;
import org.eclipse.linuxtools.internal.docker.core.DockerNetwork;
import org.eclipse.linuxtools.internal.docker.core.DockerNetworkCreation;
import org.eclipse.linuxtools.internal.docker.core.DockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.DockerVersion;
import org.eclipse.linuxtools.internal.docker.core.HttpHijackWorkaround;
import org.eclipse.linuxtools.internal.docker.core.ProcessMessages;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalServiceOutputStreamMonitorListener;

public class DockerConnection
implements IDockerConnection,
IDockerConnection2,
Closeable {
    private String name;
    private IDockerConnectionSettings connectionSettings;
    private IDockerConnectionInfo connectionInfo;
    private final String username;
    private final Object imageLock = new Object();
    private final Object containerLock = new Object();
    private final Object actionLock = new Object();
    private final Object clientLock = new Object();
    private DockerClientFactory dockerClientFactory = new DockerClientFactory();
    private DockerClient client;
    private Map<String, Job> actionJobs;
    private Map<String, LogThread> loggingThreads = new HashMap<String, LogThread>();
    private List<IDockerContainer> containers;
    private Map<String, IDockerContainer> containersById = new HashMap<String, IDockerContainer>();
    private EnumDockerConnectionState state = EnumDockerConnectionState.UNKNOWN;
    private List<IDockerImage> images;
    private Boolean isLocalConnection;
    ListenerList<IDockerContainerListener> containerListeners;
    ListenerList<IDockerImageListener> imageListeners;

    private DockerConnection(String name, UnixSocketConnectionSettings connectionSettings, String username, String password) {
        this.name = name;
        this.connectionSettings = connectionSettings;
        this.username = username;
        this.storePassword(connectionSettings.getPath(), username, password);
    }

    private DockerConnection(String name, TCPConnectionSettings connectionSettings, String username, String password) {
        this.name = name;
        this.connectionSettings = connectionSettings;
        this.username = username;
        this.storePassword(connectionSettings.getHost(), username, password);
        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
        this.addContainerListener(dcrm);
    }

    private void storePassword(String uri, String username, String passwd) {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        String key = DockerConnection.getPreferencesKey(uri, username);
        ISecurePreferences node = root.node(key);
        try {
            if (passwd != null && !passwd.equals("")) {
                node.put("password", passwd, true);
            }
        }
        catch (StorageException e) {
            Activator.log(e);
        }
    }

    public static String getPreferencesKey(String uri, String username) {
        String key = "/org/eclipse/linuxtools/docker/core/";
        key = String.valueOf(key) + uri + "/" + username;
        return EncodingUtils.encodeSlashes((String)key);
    }

    @Override
    public boolean isOpen() {
        return this.client != null && this.state == EnumDockerConnectionState.ESTABLISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(boolean registerContainerRefreshManager) throws DockerException {
        DockerConnection dockerConnection = this;
        synchronized (dockerConnection) {
            if (this.client == null) {
                try {
                    this.setClient(this.dockerClientFactory.getClient(this.connectionSettings));
                    if (registerContainerRefreshManager) {
                        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
                        this.addContainerListener(dcrm);
                    }
                }
                catch (DockerCertificateException e) {
                    this.setState(EnumDockerConnectionState.CLOSED);
                    throw new DockerOpenConnectionException(NLS.bind((String)Messages.Open_Connection_Failure, (Object)this.name, (Object)this.getUri()), e);
                }
            }
            this.ping();
        }
    }

    public DockerClient getClient() {
        return this.client;
    }

    public void setClient(DockerClient client) {
        this.client = client;
        try {
            this.connectionInfo = this.getInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDockerClientFactory(DockerClientFactory dockerClientFactory) {
        this.dockerClientFactory = dockerClientFactory;
    }

    @Override
    public EnumDockerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(EnumDockerConnectionState state) {
        EnumDockerConnectionState oldState = this.state;
        this.state = state;
        switch (state) {
            case UNKNOWN: 
            case CLOSED: {
                Object object = this.imageLock;
                synchronized (object) {
                    this.images = Collections.emptyList();
                }
                object = this.containerLock;
                synchronized (object) {
                    this.containers = Collections.emptyList();
                    this.containersById = new HashMap<String, IDockerContainer>();
                }
                this.notifyContainerListeners(this.containers);
                this.notifyImageListeners(this.images);
                if (oldState != EnumDockerConnectionState.ESTABLISHED) break;
                DockerConnectionManager.instanceNotifyListeners(this, 5);
                break;
            }
            case ESTABLISHED: {
                this.getContainers(true);
                this.getImages(true);
                this.notifyContainerListeners(this.containers);
                this.notifyImageListeners(this.images);
                if (oldState == EnumDockerConnectionState.ESTABLISHED) break;
                DockerConnectionManager.instanceNotifyListeners(this, 4);
            }
        }
    }

    @Override
    public void ping() throws DockerException {
        try {
            UnixSocketConnectionSettings settings;
            String path;
            String socket;
            File f;
            if (!(this.getState() != EnumDockerConnectionState.CLOSED && this.getState() != EnumDockerConnectionState.UNKNOWN || this.connectionSettings.getType() != IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION || (f = new File(socket = (path = (settings = (UnixSocketConnectionSettings)this.connectionSettings).getPath()).replaceAll("unix://", ""))).exists())) {
                throw new com.spotify.docker.client.exceptions.DockerException(NLS.bind((String)Messages.Docker_Daemon_No_Unix_Socket, (Object)socket));
            }
            if (this.client == null) {
                throw new DockerPingConnectionException(NLS.bind((String)Messages.Docker_Daemon_Ping_Failure, (Object)this.getName()));
            }
            this.client.ping();
            this.setState(EnumDockerConnectionState.ESTABLISHED);
        }
        catch (com.spotify.docker.client.exceptions.DockerException | IllegalArgumentException | InterruptedException e) {
            this.setState(EnumDockerConnectionState.CLOSED);
            throw new DockerPingConnectionException(NLS.bind((String)Messages.Docker_Daemon_Ping_Failure, (Object)this.getName()), e);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (String key : this.loggingThreads.keySet()) {
            LogThread t = this.loggingThreads.get(key);
            if (t != null) {
                t.kill();
            }
            this.loggingThreads.remove(key);
        }
        Object object = this.clientLock;
        synchronized (object) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        this.setState(EnumDockerConnectionState.CLOSED);
    }

    @Override
    public IDockerConnectionInfo getInfo() throws DockerException {
        if (this.client == null) {
            return null;
        }
        try {
            Info info = this.client.info();
            Version version = this.client.version();
            return new DockerConnectionInfo(info, version);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_General_Info_Failure, e);
        }
    }

    @Override
    public String getName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return Messages.Unnamed;
    }

    @Override
    public boolean setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            return true;
        }
        return false;
    }

    @Override
    public String getUri() {
        if (this.connectionSettings.getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION) {
            return ((UnixSocketConnectionSettings)this.connectionSettings).getPath();
        }
        return ((TCPConnectionSettings)this.connectionSettings).getHost();
    }

    @Override
    public IDockerConnectionSettings getSettings() {
        return this.connectionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSettings(IDockerConnectionSettings connectionSettings) {
        if (!this.connectionSettings.equals(connectionSettings)) {
            Object object = this.clientLock;
            synchronized (object) {
                this.connectionSettings = connectionSettings;
                if (this.client != null) {
                    this.client.close();
                }
                this.state = EnumDockerConnectionState.UNKNOWN;
                this.client = null;
                new Job(NLS.bind((String)Messages.Open_Connection, (Object)this.getUri())){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            DockerConnection.this.open(true);
                            DockerConnection.this.ping();
                        }
                        catch (DockerException e) {
                            Activator.logErrorMessage(NLS.bind((String)Messages.Docker_Daemon_Ping_Failure, (Object)this.getName()), e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
            }
            return true;
        }
        return false;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public IDockerVersion getVersion() throws DockerException {
        try {
            Version version = this.client.version();
            return new DockerVersion(this, version);
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_General_Info_Failure, e);
        }
    }

    @Override
    public void addContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners == null) {
            this.containerListeners = new ListenerList(1);
        }
        this.containerListeners.add((Object)listener);
    }

    @Override
    public void removeContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners != null) {
            this.containerListeners.remove((Object)listener);
        }
    }

    private DockerClient getClientCopy() throws DockerException {
        try {
            return this.dockerClientFactory.getClient(this.connectionSettings);
        }
        catch (DockerCertificateException e) {
            throw new DockerException(NLS.bind((String)Messages.Open_Connection_Failure, (Object)this.name, (Object)this.getUri()));
        }
    }

    public Closeable getOperationToken() throws DockerException {
        return this.getClientCopy();
    }

    public void closeOperationToken(Object token) {
        DockerClient client = (DockerClient)token;
        client.close();
    }

    public void notifyContainerListeners(List<IDockerContainer> list) {
        if (this.containerListeners != null) {
            for (IDockerContainerListener listener : this.containerListeners) {
                listener.listChanged(this, list);
            }
        }
    }

    public List<IDockerContainerListener> getContainerListeners() {
        if (this.containerListeners == null) {
            return Collections.emptyList();
        }
        IDockerContainerListener[] result = new IDockerContainerListener[this.containerListeners.size()];
        Object[] listeners = this.containerListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            result[i] = (IDockerContainerListener)listeners[i];
            ++i;
        }
        return Arrays.asList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getActionJob(String id) {
        Object object = this.actionLock;
        synchronized (object) {
            Job j = null;
            if (this.actionJobs != null) {
                return this.actionJobs.get(id);
            }
            return j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs == null) {
                this.actionJobs = new HashMap<String, Job>();
            }
            this.actionJobs.put(id, j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs != null && this.actionJobs.get(id) == j) {
                this.actionJobs.remove(id);
            }
        }
    }

    @Override
    public List<IDockerContainer> getContainers() {
        return this.getContainers(false);
    }

    @Override
    public List<IDockerContainer> getContainers(boolean force) {
        if (this.state == EnumDockerConnectionState.CLOSED) {
            return Collections.emptyList();
        }
        if (this.state == EnumDockerConnectionState.UNKNOWN) {
            try {
                this.open(true);
                this.getContainers(force);
            }
            catch (DockerException e) {
                Activator.log(e);
                return Collections.emptyList();
            }
        } else if (!this.isContainersLoaded() || force) {
            try {
                return this.listContainers();
            }
            catch (DockerException e) {
                Activator.log(e);
            }
        }
        return this.containers;
    }

    @Override
    public boolean isContainersLoaded() {
        return this.containers != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private List<IDockerContainer> listContainers() throws DockerException {
        updatedContainersById = new HashMap<String, IDockerContainer>();
        var3_2 = this.containerLock;
        synchronized (var3_2) {
            nativeContainers = new ArrayList<E>();
            var5_6 = this.clientLock;
            synchronized (var5_6) {
                if (this.client != null) ** break block24
                var9_7 = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 8, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var5_6
                this.containersById = updatedContainersById;
                sortedContainers = this.sort(updatedContainersById.values(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(org.eclipse.linuxtools.docker.core.IDockerContainer org.eclipse.linuxtools.docker.core.IDockerContainer ), (Lorg/eclipse/linuxtools/docker/core/IDockerContainer;Lorg/eclipse/linuxtools/docker/core/IDockerContainer;)I)());
                this.containers = sortedContainers;
            }
            return var9_7;
            {
                block25: {
                    try {
                        nativeContainers.addAll(this.client.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()}));
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 5, 8, 9] lbl23 : MonitorExitStatement: MONITOREXIT : var5_6
                        {
                            catch (Throwable v0) {
                                throw v0;
                            }
                        }
                        for (Container nativeContainer : nativeContainers) {
                            if (nativeContainer.status() != null && nativeContainer.status().startsWith(Messages.Exited_specifier)) {
                                var7_12 = this.loggingThreads;
                                synchronized (var7_12) {
                                    if (this.loggingThreads.containsKey(nativeContainer.id())) {
                                        this.loggingThreads.get(nativeContainer.id()).requestStop();
                                        this.loggingThreads.remove(nativeContainer.id());
                                    }
                                }
                            }
                            if (nativeContainer.status() != null && nativeContainer.status().equals(Messages.Removal_In_Progress_specifier)) continue;
                            if (this.containers != null && this.containersById.containsKey(nativeContainer.id())) {
                                container = this.containersById.get(nativeContainer.id());
                                updatedContainersById.put(nativeContainer.id(), new DockerContainer(this, nativeContainer, container.info()));
                                continue;
                            }
                            updatedContainersById.put(nativeContainer.id(), new DockerContainer(this, nativeContainer));
                        }
                    }
                    catch (DockerTimeoutException e) {
                        if (this.isOpen()) {
                            Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", Messages.Docker_Connection_Timeout, (Throwable)e));
                            this.close();
                        }
                        this.containersById = updatedContainersById;
                        sortedContainers /* !! */  = this.sort(updatedContainersById.values(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(org.eclipse.linuxtools.docker.core.IDockerContainer org.eclipse.linuxtools.docker.core.IDockerContainer ), (Lorg/eclipse/linuxtools/docker/core/IDockerContainer;Lorg/eclipse/linuxtools/docker/core/IDockerContainer;)I)());
                        this.containers = sortedContainers /* !! */ ;
                        break block25;
                    }
                    catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
                        try {
                            if (this.isOpen() && e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof ProcessingException) {
                                this.close();
                                break block25;
                            }
                            throw new DockerException(e.getMessage());
                        }
                        catch (Throwable var8_13) {
                            throw var8_13;
                        }
                        finally {
                            this.containersById = updatedContainersById;
                            sortedContainers /* !! */  = this.sort(updatedContainersById.values(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(org.eclipse.linuxtools.docker.core.IDockerContainer org.eclipse.linuxtools.docker.core.IDockerContainer ), (Lorg/eclipse/linuxtools/docker/core/IDockerContainer;Lorg/eclipse/linuxtools/docker/core/IDockerContainer;)I)());
                            this.containers = sortedContainers /* !! */ ;
                        }
                    }
                    this.containersById = updatedContainersById;
                    sortedContainers /* !! */  = this.sort(updatedContainersById.values(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(org.eclipse.linuxtools.docker.core.IDockerContainer org.eclipse.linuxtools.docker.core.IDockerContainer ), (Lorg/eclipse/linuxtools/docker/core/IDockerContainer;Lorg/eclipse/linuxtools/docker/core/IDockerContainer;)I)());
                    this.containers = sortedContainers /* !! */ ;
                }
            }
        }
        {
            this.notifyContainerListeners(sortedContainers /* !! */ );
            return sortedContainers /* !! */ ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getContainerIdsWithLabels(Map<String, String> labels) throws DockerException {
        HashSet<String> labelSet = new HashSet<String>();
        try {
            ArrayList nativeContainers = new ArrayList();
            Object object = this.clientLock;
            synchronized (object) {
                if (this.client == null) {
                    return Collections.emptySet();
                }
                DockerClient clientCopy = this.getClientCopy();
                DockerClient.ListContainersParam[] parms = new DockerClient.ListContainersParam[2];
                parms[0] = DockerClient.ListContainersParam.allContainers();
                String separator = "";
                StringBuffer labelString = new StringBuffer();
                for (Map.Entry<String, String> entry : labels.entrySet()) {
                    labelString.append(separator);
                    if (entry.getValue() == null || "".equals(entry.getValue())) {
                        labelString.append(entry.getKey());
                    } else {
                        labelString.append(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                    }
                    separator = "\",\"";
                }
                parms[1] = DockerClient.ListContainersParam.withLabel((String)labelString.toString());
                nativeContainers.addAll(clientCopy.listContainers(parms));
            }
            for (Container nativeContainer : nativeContainers) {
                labelSet.add(nativeContainer.id());
            }
        }
        catch (DockerTimeoutException e) {
            if (this.isOpen()) {
                Activator.log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.core", Messages.Docker_Connection_Timeout, (Throwable)e));
                this.close();
            }
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            if (this.isOpen() && e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof ProcessingException) {
                this.close();
            }
            throw new DockerException(e.getMessage());
        }
        return labelSet;
    }

    private <T> List<T> sort(Collection<T> values, Comparator<T> comparator) {
        ArrayList<T> result = new ArrayList<T>(values);
        Collections.sort(result, comparator);
        return result;
    }

    @Override
    public IDockerContainer getContainer(String id) {
        List<IDockerContainer> containers = this.getContainers();
        for (IDockerContainer container : containers) {
            if (!container.id().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public IDockerContainerInfo getContainerInfo(String id) {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            return new DockerContainerInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(ProcessMessages.getString("Container_Info_Exception"), e);
            return null;
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", ProcessMessages.getFormattedString("Container_Inspect_Exception", (Object)id), e));
            return null;
        }
    }

    @Override
    public IDockerImageInfo getImageInfo(String id) {
        if (this.client == null) {
            return null;
        }
        try {
            ImageInfo info = this.client.inspectImage(id);
            return new DockerImageInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(ProcessMessages.getString("Image_Info_Exception"), e);
            return null;
        }
        catch (ImageNotFoundException e) {
            return null;
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", ProcessMessages.getFormattedString("Image_Inspect_Exception", (Object)id), e));
            return null;
        }
    }

    @Override
    public void addImageListener(IDockerImageListener listener) {
        if (this.imageListeners == null) {
            this.imageListeners = new ListenerList(1);
        }
        this.imageListeners.add((Object)listener);
    }

    @Override
    public void removeImageListener(IDockerImageListener listener) {
        if (this.imageListeners != null) {
            this.imageListeners.remove((Object)listener);
        }
    }

    public void notifyImageListeners(List<IDockerImage> list) {
        if (this.imageListeners != null) {
            for (IDockerImageListener listener : this.imageListeners) {
                listener.listChanged(this, list);
            }
        }
    }

    public List<IDockerImageListener> getImageListeners() {
        if (this.imageListeners == null) {
            return Collections.emptyList();
        }
        IDockerImageListener[] result = new IDockerImageListener[this.imageListeners.size()];
        Object[] listeners = this.imageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            result[i] = (IDockerImageListener)listeners[i];
            ++i;
        }
        return Arrays.asList(result);
    }

    @Override
    public List<IDockerImage> getImages() {
        return this.getImages(false);
    }

    @Override
    public IDockerImage getImage(String id) {
        List<IDockerImage> images = this.getImages();
        for (IDockerImage image : images) {
            if (!image.id().equals(id)) continue;
            return image;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerImage> getImages(boolean force) {
        List<IDockerImage> latestImages;
        Object object = this.imageLock;
        synchronized (object) {
            latestImages = this.images;
        }
        if (this.state == EnumDockerConnectionState.CLOSED) {
            return Collections.emptyList();
        }
        if (this.state == EnumDockerConnectionState.UNKNOWN) {
            try {
                this.open(true);
                latestImages = this.getImages(force);
            }
            catch (DockerException e) {
                Activator.log(e);
                return Collections.emptyList();
            }
        }
        if (!this.isImagesLoaded() || force) {
            try {
                latestImages = this.listImages();
            }
            catch (DockerException e) {
                Object object2 = this.imageLock;
                synchronized (object2) {
                    this.images = Collections.emptyList();
                }
                Activator.log(e);
            }
        }
        return latestImages;
    }

    @Override
    public boolean isImagesLoaded() {
        return this.images != null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IDockerImage> listImages() throws DockerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DockerImage.DockerImageQualifier resolveQualifier(Image nativeImage, List<Image> nativeImages) {
        boolean hasTag = nativeImage.repoTags() != null && (nativeImage.repoTags().size() != 1 || !nativeImage.repoTags().contains((Object)"<none>:<none>"));
        boolean hasChildImage = nativeImages.stream().anyMatch(i -> nativeImage.id().equals(i.parentId()));
        if (!hasTag && hasChildImage) {
            return DockerImage.DockerImageQualifier.INTERMEDIATE;
        }
        if (!hasTag && !hasChildImage) {
            return DockerImage.DockerImageQualifier.DANGLING;
        }
        return DockerImage.DockerImageQualifier.TOP_LEVEL;
    }

    @Override
    public boolean hasImage(String repository, String tag) {
        for (IDockerImage image : this.getImages()) {
            for (String repoTag : image.repoTags()) {
                String tagExpr;
                String string = tagExpr = tag != null && !tag.isEmpty() ? ":" + tag : "";
                if (!repoTag.equals(String.valueOf(repository) + tagExpr)) continue;
                return true;
            }
        }
        return false;
    }

    public IDockerImage getImageByTag(String tag) {
        for (IDockerImage image : this.getImages()) {
            for (String repoTag : image.repoTags()) {
                if (!repoTag.equals(tag)) continue;
                return image;
            }
        }
        return null;
    }

    @Override
    public IDockerProgressHandler getDefaultBuildImageProgressHandler(String image, int lines) {
        return new DefaultImageBuildProgressHandler(this, image, lines);
    }

    @Override
    public IDockerProgressHandler getDefaultPullImageProgressHandler(String image) {
        return new DefaultImagePullProgressHandler(this, image);
    }

    @Override
    public IDockerProgressHandler getDefaultPushImageProgressHandler(String image) {
        return new DefaultImagePushProgressHandler(this, image);
    }

    @Override
    public void pullImage(String id, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.pull(id, (ProgressHandler)d);
            this.listImages();
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void pullImage(String imageId, IRegistryAccount info, IDockerProgressHandler handler) throws DockerException, InterruptedException, DockerCertificateException {
        try {
            DockerClient client = this.dockerClientFactory.getClient(this.connectionSettings, info);
            DockerProgressHandler d = new DockerProgressHandler(handler);
            client.pull(imageId, (ProgressHandler)d);
            this.listImages();
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public List<IDockerImageSearchResult> searchImages(String term) throws DockerException {
        try {
            List searchResults = this.client.searchImages(term);
            ArrayList<IDockerImageSearchResult> results = new ArrayList<IDockerImageSearchResult>();
            for (ImageSearchResult r : searchResults) {
                if (!r.name().contains(term)) continue;
                results.add(new DockerImageSearchResult(r.description(), r.official(), r.automated(), r.name(), r.starCount()));
            }
            return results;
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void pushImage(String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.push(name, (ProgressHandler)d);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void pushImage(String name, IRegistryAccount info, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerClient client = this.dockerClientFactory.getClient(this.connectionSettings, info);
            DockerProgressHandler d = new DockerProgressHandler(handler);
            client.push(name, (ProgressHandler)d);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (DockerCertificateException | com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeImage(String name) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(name, true, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeTag(String tag) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(tag, false, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void tagImage(String name, String newTag) throws DockerException, InterruptedException {
        this.tagImage(name, newTag, false);
    }

    public void tagImage(String name, String newTag, boolean force) throws DockerException, InterruptedException {
        try {
            this.client.tag(name, newTag, force);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            java.nio.file.Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            String res = this.getClientCopy().build(p, (ProgressHandler)d, new DockerClient.BuildParam[]{DockerClient.BuildParam.create((String)"forcerm", (String)"true")});
            return res;
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            java.nio.file.Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            String res = this.getClientCopy().build(p, name, (ProgressHandler)d, new DockerClient.BuildParam[]{DockerClient.BuildParam.create((String)"forcerm", (String)"true")});
            return res;
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    public String buildImage(IPath path, String name, IDockerProgressHandler handler, Map<String, Object> buildOptions) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            java.nio.file.Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            String res = this.getClientCopy().build(p, name, (ProgressHandler)d, this.getBuildParameters(buildOptions));
            return res;
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    public String buildImage(IPath path, String name, String dockerFileName, IDockerProgressHandler handler, Map<String, Object> buildOptions) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            java.nio.file.Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            String res = this.getClientCopy().build(p, name, dockerFileName, (ProgressHandler)d, this.getBuildParameters(buildOptions));
            return res;
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    private DockerClient.BuildParam[] getBuildParameters(Map<String, Object> buildOptions) {
        if (buildOptions == null) {
            return new DockerClient.BuildParam[0];
        }
        ArrayList<DockerClient.BuildParam> buildParameters = new ArrayList<DockerClient.BuildParam>();
        for (Map.Entry<String, Object> entry : buildOptions.entrySet()) {
            String optionName = entry.getKey();
            Object optionValue = entry.getValue();
            if (optionName.equals("quietBuild") && optionValue.equals(true)) {
                buildParameters.add(DockerClient.BuildParam.create((String)"q", (String)"true"));
                continue;
            }
            if (optionName.equals("noCache") && optionValue.equals(true)) {
                buildParameters.add(DockerClient.BuildParam.create((String)"nocache", (String)"true"));
                continue;
            }
            if (optionName.equals("rm") && optionValue.equals(false)) {
                buildParameters.add(DockerClient.BuildParam.create((String)"rm", (String)"false"));
                continue;
            }
            if (!optionName.equals("forcerm") || !optionValue.equals(true)) continue;
            buildParameters.add(DockerClient.BuildParam.create((String)"forcerm", (String)"true"));
        }
        return buildParameters.toArray(new DockerClient.BuildParam[0]);
    }

    public void save() {
        DockerConnectionManager.getInstance().saveConnections();
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc) throws DockerException, InterruptedException {
        return this.createContainer(c, hc, null);
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc, String containerName) throws DockerException, InterruptedException {
        try {
            HostConfig.Builder hbuilder = HostConfig.builder().containerIdFile(hc.containerIDFile()).publishAllPorts(Boolean.valueOf(hc.publishAllPorts())).privileged(Boolean.valueOf(hc.privileged())).networkMode(hc.networkMode()).readonlyRootfs(Boolean.valueOf(((DockerHostConfig)hc).readonlyRootfs()));
            if (((DockerHostConfig)hc).tmpfs() != null) {
                hbuilder.tmpfs((Map)ImmutableMap.copyOf(((DockerHostConfig)hc).tmpfs()));
            }
            if (((DockerHostConfig)hc).capAdd() != null) {
                hbuilder.capAdd(((DockerHostConfig)hc).capAdd());
            }
            if (((DockerHostConfig)hc).capDrop() != null) {
                hbuilder.capDrop(((DockerHostConfig)hc).capDrop());
            }
            if (hc.binds() != null) {
                hbuilder.binds(hc.binds());
            }
            if (hc.dns() != null) {
                hbuilder.dns(hc.dns());
            }
            if (hc.dnsSearch() != null) {
                hbuilder.dnsSearch(hc.dnsSearch());
            }
            if (hc.links() != null) {
                hbuilder.links(hc.links());
            }
            if (hc.lxcConf() != null) {
                List<IDockerConfParameter> lxcconf = hc.lxcConf();
                ArrayList lxcreal = new ArrayList();
                for (IDockerConfParameter iDockerConfParameter : lxcconf) {
                }
                hbuilder.lxcConf(lxcreal);
            }
            if (hc.portBindings() != null) {
                Map<String, List<IDockerPortBinding>> bindings = hc.portBindings();
                HashMap realBindings = new HashMap();
                for (Map.Entry entry : bindings.entrySet()) {
                    String key = (String)entry.getKey();
                    List bindingList = (List)entry.getValue();
                    ArrayList<PortBinding> newList = new ArrayList<PortBinding>();
                    for (IDockerPortBinding binding : bindingList) {
                        newList.add(PortBinding.of((String)binding.hostIp(), (String)binding.hostPort()));
                    }
                    realBindings.put(key, newList);
                }
                hbuilder.portBindings(realBindings);
            }
            if (hc.volumesFrom() != null) {
                hbuilder.volumesFrom(hc.volumesFrom());
            }
            if (hc.securityOpt() != null) {
                hbuilder.securityOpt(hc.securityOpt());
            }
            if (((DockerHostConfig)hc).memory() != null) {
                hbuilder.memory(((DockerHostConfig)hc).memory());
            }
            if (((DockerHostConfig)hc).cpuShares() != null && ((DockerHostConfig)hc).cpuShares() > 0L) {
                hbuilder.cpuShares(((DockerHostConfig)hc).cpuShares());
            }
            ContainerConfig.Builder builder = ContainerConfig.builder().hostname(c.hostname()).domainname(c.domainname()).user(c.user()).attachStdin(Boolean.valueOf(c.attachStdin())).attachStdout(Boolean.valueOf(c.attachStdout())).attachStderr(Boolean.valueOf(c.attachStderr())).tty(Boolean.valueOf(c.tty())).openStdin(Boolean.valueOf(c.openStdin())).stdinOnce(Boolean.valueOf(c.stdinOnce())).cmd(c.cmd()).image(c.image()).hostConfig(hbuilder.build()).workingDir(c.workingDir()).labels(c.labels()).networkDisabled(Boolean.valueOf(c.networkDisabled()));
            if (c.portSpecs() != null) {
                builder = builder.portSpecs(c.portSpecs());
            }
            if (c.exposedPorts() != null) {
                builder = builder.exposedPorts(c.exposedPorts());
            }
            if (c.env() != null) {
                builder = builder.env(c.env());
            }
            if (c.volumes() != null) {
                builder = builder.volumes(c.volumes());
            }
            if (c.entrypoint() != null) {
                builder = builder.entrypoint(c.entrypoint());
            }
            if (c.onBuild() != null) {
                builder = builder.onBuild(c.onBuild());
            }
            ContainerCreation creation = this.client.createContainer(builder.build(), containerName != null && !containerName.isEmpty() ? containerName : null);
            String string = creation.id();
            this.listContainers();
            return string;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.stopContainer(id, 10);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.killContainer(id);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void pauseContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.pauseContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpauseContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.unpauseContainer(id);
            if (stream != null) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    } else {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void removeContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.removeContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    private String getCmdString(IDockerContainerInfo info) {
        if (info == null) {
            return "";
        }
        List<String> cmd = info.config().cmd();
        StringBuffer b = new StringBuffer();
        cmd.stream().forEach(s -> {
            StringBuffer stringBuffer2 = b.append(String.valueOf(s) + " ");
        });
        b.deleteCharAt(b.length() - 1);
        return b.toString();
    }

    @Override
    public void startContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        this.startContainer((Closeable)this.client, id, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContainer(Closeable token, String id, OutputStream stream) throws DockerException, InterruptedException {
        IDockerContainerInfo containerInfo = this.getContainerInfo(id);
        if (containerInfo == null) {
            throw new DockerException(DockerMessages.getFormattedString("DockerContainerNotFound.error", id));
        }
        try {
            ((DockerClient)token).startContainer(id);
            if (stream != null && containerInfo != null && containerInfo.config() != null && !containerInfo.config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerException(DockerMessages.getFormattedString("DockerStartContainer.error", this.getCmdString(containerInfo)));
        }
        catch (DockerRequestException e) {
            if (e.status() != 304) {
                throw new DockerException(e.getMessage());
            }
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContainer(String id, String loggingId, OutputStream stream) throws DockerException, InterruptedException {
        IDockerContainerInfo containerInfo = this.getContainerInfo(id);
        if (containerInfo == null) {
            throw new DockerException(DockerMessages.getFormattedString("DockerContainerNotFound.error", id));
        }
        try {
            this.client.startContainer(id);
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
            boolean autoLog = preferences.getBoolean("autoLogOnStart", true);
            if (autoLog && !containerInfo.config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(loggingId);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(loggingId, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerException(DockerMessages.getFormattedString("DockerStartContainer.error", this.getCmdString(containerInfo)));
        }
        catch (DockerRequestException e) {
            if (e.status() != 304) {
                throw new DockerException(e.getMessage());
            }
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void restartContainer(String id, int secondsToWait) throws DockerException, InterruptedException {
        this.restartContainer(id, secondsToWait, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartContainer(String id, int secondsToWait, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.restartContainer(id, secondsToWait);
            IDockerContainerInfo containerInfo = this.getContainerInfo(id);
            if (stream != null && containerInfo != null && containerInfo.config() != null && !containerInfo.config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void commitContainer(String id, String repo, String tag, String comment, String author) throws DockerException {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            this.client.commitContainer(id, repo, tag, info.config(), comment, author);
            this.listImages();
            this.getImages(true);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException | InterruptedException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public InputStream copyContainer(String id, String path) throws DockerException, InterruptedException {
        InputStream stream;
        try {
            DockerClient copy = this.getClientCopy();
            stream = copy.archiveContainer(id, path);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
        return stream;
    }

    public InputStream copyContainer(Closeable token, String id, String path) throws DockerException, InterruptedException {
        InputStream stream;
        DockerClient clientCopy = (DockerClient)token;
        try {
            stream = clientCopy.archiveContainer(id, path);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
        return stream;
    }

    @Override
    public List<IDockerContainerChange> containerChanges(String id) throws DockerException, InterruptedException {
        ArrayList<IDockerContainerChange> containerChanges = new ArrayList<IDockerContainerChange>();
        try {
            DockerClient copy = this.getClientCopy();
            List changes = copy.inspectContainerChanges(id);
            for (ContainerChange change : changes) {
                containerChanges.add(new DockerContainerChange(change.path(), change.kind()));
            }
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
        return containerChanges;
    }

    public boolean isLocal() {
        if (this.isLocalConnection != null) {
            return this.isLocalConnection;
        }
        this.isLocalConnection = false;
        if (this.connectionSettings.getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION) {
            this.isLocalConnection = true;
        } else if (this.connectionSettings.getType() == IDockerConnectionSettings.BindingType.TCP_CONNECTION) {
            TCPConnectionSettings settings = (TCPConnectionSettings)this.connectionSettings;
            try {
                InetAddress addr = InetAddress.getByName(settings.getAddr());
                if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                    this.isLocalConnection = true;
                } else {
                    try {
                        this.isLocalConnection = NetworkInterface.getByInetAddress(addr) != null;
                    }
                    catch (SocketException e) {
                        this.isLocalConnection = false;
                    }
                }
            }
            catch (UnknownHostException e) {
                Activator.log(e);
            }
        }
        return this.isLocalConnection;
    }

    @Override
    public void copyToContainer(String directory, String id, String path) throws DockerException, InterruptedException, IOException {
        try {
            DockerClient copy = this.getClientCopy();
            java.nio.file.Path dirPath = FileSystems.getDefault().getPath(directory, new String[0]);
            copy.copyToContainer(dirPath, id, path);
            copy.close();
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public void copyToContainer(Closeable token, String directory, String id, String path) throws DockerException, InterruptedException, IOException {
        try {
            DockerClient copy = (DockerClient)token;
            java.nio.file.Path dirPath = FileSystems.getDefault().getPath(directory, new String[0]);
            copy.copyToContainer(dirPath, id, path);
            copy.close();
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public int auth(IRegistryAccount cfg) throws DockerException, InterruptedException {
        try {
            RegistryAuth authConfig = RegistryAuth.builder().username(new String(cfg.getUsername())).password(cfg.getPassword() != null ? new String(cfg.getPassword()) : null).email(new String(cfg.getEmail())).serverAddress(new String(cfg.getServerAddress())).build();
            return this.client.auth(authConfig);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumDockerLoggingStatus loggingStatus(String id) {
        Map<String, LogThread> map = this.loggingThreads;
        synchronized (map) {
            LogThread t = this.loggingThreads.get(id);
            if (t == null) {
                return EnumDockerLoggingStatus.LOGGING_NONE;
            }
            if (t.isAlive()) {
                return EnumDockerLoggingStatus.LOGGING_ACTIVE;
            }
            return EnumDockerLoggingStatus.LOGGING_COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void stopLoggingThread(String id) {
        var2_2 = this.loggingThreads;
        synchronized (var2_2) {
            t = this.loggingThreads.get(id);
            if (t != null) {
                t.requestStop();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl17
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
lbl17:
            // 3 sources

        } while (this.loggingStatus(id) == EnumDockerLoggingStatus.LOGGING_ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                ContainerInfo info = this.client.inspectContainer(id);
                LogThread t = this.loggingThreads.get(id);
                if (t == null || !t.isAlive()) {
                    t = new LogThread(id, this.getClientCopy(), info.state().running());
                    this.loggingThreads.put(id, t);
                    t.setOutputStream(stream);
                    t.start();
                } else {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void attachLog(String id, OutputStream out, OutputStream err) throws DockerException, InterruptedException, IOException {
        try {
            DockerClient copyClient = this.getClientCopy();
            LogStream stream = copyClient.logs(id, new DockerClient.LogsParam[]{DockerClient.LogsParam.follow(), DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            stream.attach(out, err);
            stream.close();
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public void attachLog(Closeable token, String id, OutputStream out, OutputStream err) throws DockerException, InterruptedException, IOException {
        try {
            LogStream stream = ((DockerClient)token).logs(id, new DockerClient.LogsParam[]{DockerClient.LogsParam.follow(), DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            stream.attach(out, err);
            stream.close();
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public IDockerContainerExit waitForContainer(String id) throws DockerException, InterruptedException {
        try {
            DockerClient copy = this.getClientCopy();
            ContainerExit x = copy.waitContainer(id);
            DockerContainerExit exit = new DockerContainerExit(x.statusCode());
            this.listContainers();
            copy.close();
            return exit;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public void attachCommand(String id, InputStream in, DockerConsoleOutputStream out) throws DockerException {
        this.attachCommand((Closeable)this.client, id, in, out, true);
    }

    public void attachCommand(Closeable token, String id, InputStream in, DockerConsoleOutputStream out, boolean openTTY) throws DockerException {
        byte[] prevCmd = new byte[1024];
        try {
            LogStream pty_stream = ((DockerClient)token).attachContainer(id, new DockerClient.AttachParameter[]{DockerClient.AttachParameter.STDIN, DockerClient.AttachParameter.STDOUT, DockerClient.AttachParameter.STDERR, DockerClient.AttachParameter.STREAM, DockerClient.AttachParameter.LOGS});
            IDockerContainerInfo info = this.getContainerInfo(id);
            boolean isTtyEnabled = info.config().tty();
            boolean isOpenStdin = info.config().openStdin();
            if (isTtyEnabled && openTTY) {
                this.openTerminal(pty_stream, info.name(), out);
            }
            Thread t_in = new Thread(() -> {
                byte[] buff = new byte[1024];
                try {
                    WritableByteChannel pty_out = HttpHijackWorkaround.getOutputStream(pty_stream, this.getUri());
                    while (true) {
                        int n = in.read(buff);
                        if (n == -1) return;
                        if (!this.getContainerInfo(id).state().running().booleanValue()) {
                            return;
                        }
                        byte[] byArray2 = prevCmd;
                        // MONITORENTER : byArray
                        pty_out.write(ByteBuffer.wrap(buff, 0, n));
                        int i = 0;
                        while (true) {
                            if (i >= prevCmd.length) {
                                // MONITOREXIT : byArray2
                                break;
                            }
                            byArray[i] = buff[i];
                            ++i;
                        }
                        buff = new byte[1024];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            if (!isTtyEnabled && isOpenStdin) {
                t_in.start();
            }
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public void attachContainerOutput(Closeable token, String id, OutputStream stdout, OutputStream stderr) throws DockerException {
        try {
            LogStream logstream = ((DockerClient)token).attachContainer(id, new DockerClient.AttachParameter[]{DockerClient.AttachParameter.STDOUT, DockerClient.AttachParameter.STDERR, DockerClient.AttachParameter.STREAM});
            logstream.attach(stdout, stderr);
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public List<ContainerFileProxy> readContainerDirectory(String id, String path) throws DockerException {
        ArrayList<ContainerFileProxy> childList = new ArrayList<ContainerFileProxy>();
        try {
            DockerClient copyClient = this.getClientCopy();
            ExecCreation execCreation = copyClient.execCreate(id, new String[]{"/bin/sh", "-c", "ls -l -F -L -Q " + path}, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr()});
            String execId = execCreation.id();
            LogStream pty_stream = copyClient.execStart(execId, new DockerClient.ExecStartParameter[0]);
            try {
                while (pty_stream.hasNext()) {
                    String[] lines;
                    ByteBuffer b = ((LogMessage)pty_stream.next()).content();
                    byte[] buffer = new byte[b.remaining()];
                    b.get(buffer);
                    String s = new String(buffer);
                    String[] stringArray = lines = s.split("\\r?\\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (!line.trim().startsWith("total")) {
                            String[] token = line.split("\\s+");
                            boolean isDirectory = token[0].startsWith("d");
                            boolean isLink = token[0].startsWith("l");
                            if (token.length > 8) {
                                String link = null;
                                if (isLink) {
                                    String linkname = token[token.length - 1];
                                    if (linkname.endsWith("/")) {
                                        linkname = linkname.substring(0, linkname.length() - 1);
                                        isDirectory = true;
                                    }
                                    Path linkPath = new Path(path);
                                    linkPath = linkPath.append(linkname);
                                    link = linkPath.toString();
                                    String name = token[token.length - 3];
                                    childList.add(new ContainerFileProxy(path, name, isDirectory, isLink, link));
                                } else {
                                    String name = token[token.length - 1];
                                    name = name.substring(1, name.length() - (name.endsWith("\"") ? 1 : 2));
                                    childList.add(new ContainerFileProxy(path, name, isDirectory));
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            finally {
                if (pty_stream != null) {
                    pty_stream.close();
                }
                if (copyClient != null) {
                    copyClient.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return childList;
    }

    public void execShell(String id) throws DockerException {
        try {
            ExecCreation execCreation = this.client.execCreate(id, new String[]{"/bin/sh"}, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr(), DockerClient.ExecCreateParam.attachStdin(), DockerClient.ExecCreateParam.tty()});
            String execId = execCreation.id();
            LogStream pty_stream = this.client.execStart(execId, new DockerClient.ExecStartParameter[]{DockerClient.ExecStartParameter.TTY});
            IDockerContainerInfo info = this.getContainerInfo(id);
            this.openTerminal(pty_stream, String.valueOf(info.name()) + " [shell]", null);
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    private void openTerminal(LogStream pty_stream, String name, DockerConsoleOutputStream out) throws DockerException {
        try {
            OutputStream tout = DockerConnection.noBlockingOutputStream(HttpHijackWorkaround.getOutputStream(pty_stream, this.getUri()));
            InputStream tin = HttpHijackWorkaround.getInputStream(pty_stream);
            TerminalOutputMonitorListener monitor = new TerminalOutputMonitorListener(out);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
            properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.streams.StreamsConnector");
            properties.put("title", name);
            properties.put("localEcho", false);
            properties.put("terminal.forceNew", true);
            properties.put("streams.stdin", tout);
            properties.put("streams.stdout", tin);
            properties.put("stderrListeners", new ITerminalServiceOutputStreamMonitorListener[]{monitor});
            properties.put("stdoutListeners", new ITerminalServiceOutputStreamMonitorListener[]{monitor});
            properties.put("data", pty_stream);
            properties.put("PREVENT_JVM_GC_FINALIZE", pty_stream);
            if (out != null) {
                out.setTerminalProperties(properties);
            }
            ITerminalService service = TerminalServiceFactory.getService();
            service.openConsole(properties, null);
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getTcpCertPath() {
        if (this.connectionSettings.getType() == IDockerConnectionSettings.BindingType.TCP_CONNECTION) {
            return ((TCPConnectionSettings)this.connectionSettings).getPathToCertificates();
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static OutputStream noBlockingOutputStream(final WritableByteChannel out) {
        return new OutputStream(){

            @Override
            public synchronized void write(int i) throws IOException {
                byte[] b = new byte[]{(byte)i};
                this.write(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return;
                }
                ByteBuffer buff = ByteBuffer.wrap(b, off, len);
                while (buff.remaining() > 0) {
                    out.write(buff);
                }
            }

            @Override
            public void close() throws IOException {
                out.close();
            }
        };
    }

    @Override
    public IDockerNetworkCreation createNetwork(IDockerNetworkConfig cfg) throws DockerException, InterruptedException {
        try {
            Ipam.Builder ipamBuilder = Ipam.builder().driver(cfg.ipam().driver());
            List<IDockerIpamConfig> ipamCfgs = cfg.ipam().config();
            for (IDockerIpamConfig ipamCfg : ipamCfgs) {
                ipamBuilder = ipamBuilder.config(ipamCfg.subnet(), ipamCfg.ipRange(), ipamCfg.gateway());
            }
            Ipam ipam = ipamBuilder.build();
            NetworkConfig.Builder networkConfigBuilder = NetworkConfig.builder().name(cfg.name()).driver(cfg.driver()).ipam(ipam);
            networkConfigBuilder.options(cfg.options());
            NetworkConfig networkConfig = networkConfigBuilder.build();
            NetworkCreation creation = this.client.createNetwork(networkConfig);
            return new DockerNetworkCreation(creation);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public IDockerNetwork inspectNetwork(String networkId) throws DockerException, InterruptedException {
        try {
            Network n = this.client.inspectNetwork(networkId);
            return new DockerNetwork(n);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public List<IDockerNetwork> listNetworks() throws DockerException, InterruptedException {
        try {
            List networkList = this.client.listNetworks(new DockerClient.ListNetworksParam[0]);
            ArrayList<IDockerNetwork> networks = new ArrayList<IDockerNetwork>();
            for (Network n : networkList) {
                networks.add(new DockerNetwork(n));
            }
            return networks;
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void removeNetwork(String networkId) throws DockerException, InterruptedException {
        try {
            this.client.removeNetwork(networkId);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void connectNetwork(String id, String networkId) throws DockerException, InterruptedException {
        try {
            this.client.connectToNetwork(id, networkId);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void disconnectNetwork(String id, String networkId) throws DockerException, InterruptedException {
        try {
            this.client.disconnectFromNetwork(id, networkId);
        }
        catch (com.spotify.docker.client.exceptions.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public boolean equals(Object other) {
        if (other instanceof IDockerConnection) {
            return this.getSettings().equals(((IDockerConnection)other).getSettings());
        }
        return false;
    }

    public int hashCode() {
        return this.getSettings().hashCode();
    }

    @Override
    public IDockerImageHierarchyNode resolveImageHierarchy(IDockerImage selectedImage) {
        return DockerImageHierarchyNodeUtils.resolveImageHierarchy(this.images, this.containers, selectedImage);
    }

    @Override
    public IDockerImageHierarchyNode resolveImageHierarchy(IDockerContainer selectedContainer) {
        return DockerImageHierarchyNodeUtils.resolveImageHierarchy(this.images, selectedContainer);
    }

    /* synthetic */ DockerConnection(String string, UnixSocketConnectionSettings unixSocketConnectionSettings, String string2, String string3, DockerConnection dockerConnection) {
        this(string, unixSocketConnectionSettings, string2, string3);
    }

    /* synthetic */ DockerConnection(String string, TCPConnectionSettings tCPConnectionSettings, String string2, String string3, DockerConnection dockerConnection) {
        this(string, tCPConnectionSettings, string2, string3);
    }

    private static /* synthetic */ int lambda$0(IDockerContainer container, IDockerContainer otherContainer) {
        return container.name().compareTo(otherContainer.name());
    }

    public static class Builder {
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public DockerConnection unixSocketConnection(UnixSocketConnectionSettings unixSocketConnectionSettings) {
            return new DockerConnection(this.name, unixSocketConnectionSettings, null, null, null);
        }

        public DockerConnection tcpConnection(TCPConnectionSettings tcpConnectionSettings) {
            return new DockerConnection(this.name, tcpConnectionSettings, null, null, null);
        }
    }

    private class LogThread
    extends AbstractKillableThread
    implements ILogger {
        private String id;
        private DockerClient copyClient;
        private OutputStream outputStream;
        private boolean follow;

        public LogThread(String id, DockerClient copyClient, boolean follow) {
            this.id = id;
            this.copyClient = copyClient;
            this.follow = follow;
        }

        @Override
        public LogThread clone() {
            return new LogThread(this.id, this.copyClient, this.follow);
        }

        @Override
        public void setOutputStream(OutputStream stream) {
            this.outputStream = stream;
        }

        @Override
        public void execute() throws InterruptedException, IOException {
            LogStream stream = null;
            try {
                try {
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
                    boolean timestamps = preferences.getBoolean("logTimestamp", true);
                    stream = timestamps ? this.copyClient.logs(this.id, new DockerClient.LogsParam[]{DockerClient.LogsParam.follow(), DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr(), DockerClient.LogsParam.timestamps()}) : this.copyClient.logs(this.id, new DockerClient.LogsParam[]{DockerClient.LogsParam.follow(), DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
                    int delayTime = 100;
                    do {
                        Thread.sleep(delayTime);
                        delayTime = 500;
                        while (stream.hasNext()) {
                            ByteBuffer b = ((LogMessage)stream.next()).content();
                            byte[] bytes = new byte[b.remaining()];
                            b.get(bytes);
                            if (this.outputStream == null) continue;
                            this.outputStream.write(bytes);
                        }
                    } while (this.follow && !this.stop);
                    DockerConnection.this.listContainers();
                }
                catch (DockerRequestException e) {
                    Activator.logErrorMessage(ProcessMessages.getString("Monitor_Logs_Exception"), e);
                    throw new InterruptedException();
                }
                catch (com.spotify.docker.client.exceptions.DockerException | IOException e) {
                    Activator.logErrorMessage(ProcessMessages.getString("Monitor_Logs_Exception"), e);
                    throw new InterruptedException();
                }
                catch (InterruptedException e) {
                    this.kill = true;
                    Thread.currentThread().interrupt();
                    this.follow = false;
                    this.copyClient.close();
                    if (stream != null) {
                        stream.close();
                    }
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
                catch (Exception e) {
                    Activator.logErrorMessage(ProcessMessages.getString("Monitor_Logs_Exception"), e);
                    this.follow = false;
                    this.copyClient.close();
                    if (stream != null) {
                        stream.close();
                    }
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
            }
            finally {
                this.follow = false;
                this.copyClient.close();
                if (stream != null) {
                    stream.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
        }
    }

    private class TerminalOutputMonitorListener
    implements ITerminalServiceOutputStreamMonitorListener {
        private DockerConsoleOutputStream consoleOutputStream;

        public TerminalOutputMonitorListener(DockerConsoleOutputStream out) {
            this.consoleOutputStream = out;
        }

        public void onContentReadFromStream(byte[] byteBuffer, int bytesRead) {
            try {
                if (this.consoleOutputStream != null) {
                    this.consoleOutputStream.write(byteBuffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }
}

