/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.impl.ReferenceImpl;
import org.eclipse.jwt.we.parts.core.GraphicalModelElementEditPart;
import org.eclipse.jwt.we.parts.processes.ScopeEditPartHelper;
import org.eclipse.jwt.we.parts.processes.policies.ScopeLayoutEditPolicy;

public class ScopeEditPart
extends GraphicalModelElementEditPart {
    private static final Logger logger = Logger.getLogger(ScopeEditPart.class);
    private final ScopeEditPartHelper scopeEditPartHelper = new ScopeEditPartHelper(this);
    public static final String ROUTER_SHORTESTPATH = "shortestpath";
    public static final String ROUTER_MANHATTAN = "manhattan";
    public static final String ROUTER_FAN = "fan";
    public static final String ROUTER_NULL = "null";

    public Class getModelClass() {
        return Scope.class;
    }

    public Scope getScope() {
        return (Scope)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ScopeLayoutEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    protected IFigure createFigure() {
        IFigure figure = super.createFigure();
        ConnectionLayer conLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (PreferenceReader.appearanceAntialiasing.get()) {
            conLayer.setAntialias(1);
        }
        ShortestPathConnectionRouter router = null;
        String preferenceRouter = PreferenceReader.appearanceConRouter.get();
        if (preferenceRouter.equals(ROUTER_SHORTESTPATH)) {
            router = new ShortestPathConnectionRouter(figure);
        } else if (preferenceRouter.equals(ROUTER_MANHATTAN)) {
            router = new ManhattanConnectionRouter();
        } else if (preferenceRouter.equals(ROUTER_FAN)) {
            router = new FanRouter();
            ((FanRouter)router).setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter(figure));
        } else if (preferenceRouter.equals(ROUTER_NULL)) {
            router = new FanRouter();
            ((FanRouter)router).setSeparation(1);
        } else {
            router = new ShortestPathConnectionRouter(figure);
        }
        conLayer.setConnectionRouter((ConnectionRouter)router);
        return figure;
    }

    public List getModelChildren() {
        List childrenlist = this.scopeEditPartHelper.getModelChildren();
        ArrayList returnlist = new ArrayList();
        Views myviews = Views.getInstance();
        for (Object obj : childrenlist) {
            EObject eo = (EObject)obj;
            try {
                EClass e = eo.eClass();
                if (eo instanceof ReferenceImpl) {
                    ReferenceImpl ri = (ReferenceImpl)eo;
                    e = ri.basicGetReference().eClass();
                }
                if (!myviews.displayObject((EObject)e)) continue;
                returnlist.add(obj);
            }
            catch (Exception exception) {
                returnlist.add(obj);
            }
        }
        return returnlist;
    }
}

