/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.resource.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.plugin.internal.EMFUtils;

public class EMFResourceUtils {
    public static final void cleanBadlyLoadedResource(ResourceSet resourceSet, URI badlyLoadedResourceUri) {
        Resource badlyLoadedResource = resourceSet.getResource(badlyLoadedResourceUri, false);
        if (badlyLoadedResource != null) {
            if (badlyLoadedResource.isLoaded()) {
                badlyLoadedResource.unload();
            }
            resourceSet.getResources().remove((Object)badlyLoadedResource);
        }
    }

    public static final void updateModelExternalResourceUri(EObject modelRoot, URI oldURI, URI newURI) {
        Resource modelResource = modelRoot.eResource();
        URI ownURI = modelResource.getURI();
        TreeIterator eObjectIt = modelRoot.eAllContents();
        while (eObjectIt.hasNext()) {
            EObject eObject = (EObject)eObjectIt.next();
            URI eObjectResourceURI = EMFUtils.getResourceOrProxyURI(eObject);
            if (ownURI.equals(eObjectResourceURI)) {
                EMFResourceUtils.updateModelElementCrossReferenceExternalResourceUri(eObject, oldURI, newURI);
                continue;
            }
            if (!oldURI.equals(eObjectResourceURI)) continue;
            EMFUtils.updateResourceOrProxyURI(eObject, newURI);
        }
        EMFResourceUtils.updateModelElementCrossReferenceExternalResourceUri(modelRoot, oldURI, newURI);
    }

    private static final void updateModelElementCrossReferenceExternalResourceUri(EObject eObject, URI oldURI, URI newURI) {
        for (EObject refEObject : eObject.eCrossReferences()) {
            URI refEObjectResourceURI = EMFUtils.getResourceOrProxyURI(refEObject);
            if (!oldURI.equals(refEObjectResourceURI)) continue;
            EMFUtils.updateResourceOrProxyURI(refEObject, newURI);
        }
    }

    public static void removeResourceFromResourceSet(URI toBeRemovedUri, ResourceSet resourceSet) {
        for (Resource resource : new ArrayList(resourceSet.getResources())) {
            if (!toBeRemovedUri.equals(resource.getURI())) continue;
            if (resource.isLoaded()) {
                resource.unload();
            }
            resourceSet.getResources().remove((Object)resource);
        }
    }

    public static boolean deleteEMFResource(EObject toBeDeletedEObject) {
        Resource toBeDeletedEResource = toBeDeletedEObject.eResource();
        try {
            URI normalizedURI = toBeDeletedEResource.getURI();
            String platformResourcePathString = normalizedURI.toPlatformString(false);
            IFile file = ConfPlugin.getWorkspaceRoot().getFile((IPath)new Path(platformResourcePathString));
            file.delete(true, null);
            if (toBeDeletedEResource.isLoaded()) {
                toBeDeletedEResource.unload();
                toBeDeletedEResource.getResourceSet().getResources().remove((Object)toBeDeletedEResource);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

