/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.DirectComboBoxDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class MergeComponentNameHandler
extends AbstractSelectionBasedHandler {
    public Object executeImpl(ExecutionEvent event) {
        Set<IComponentNamePO> compNames = this.getComponentNames(this.getSelection());
        IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
        if (selectedCompNamePo == null) {
            return null;
        }
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        Persistor persistor = Persistor.instance();
        EntityTransaction tx = persistor.getTransaction(masterSession);
        HashSet<IComponentNamePO> inSessionCompNames = new HashSet<IComponentNamePO>();
        try {
            for (IComponentNamePO cn : compNames) {
                IComponentNamePO compName = (IComponentNamePO)masterSession.find(cn.getClass(), (Object)cn.getId());
                masterSession.refresh((Object)compName);
                persistor.lockPO(masterSession, (IPersistentObject)compName);
                inSessionCompNames.add(compName);
            }
            this.performOperation(inSessionCompNames, selectedCompNamePo);
            persistor.commitTransaction(masterSession, tx);
            this.fireChangeEvents(inSessionCompNames);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return null;
    }

    protected IComponentNamePO openDialog(Set<IComponentNamePO> compNames) {
        DirectComboBoxDialog<IComponentNamePO> dialog = this.createDialog(compNames);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog(dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.mergeComponentNameContextId");
        if (dialog.open() == 0) {
            IComponentNamePO selectedCompNamePo = dialog.getSelection();
            compNames.remove(selectedCompNamePo);
            return selectedCompNamePo;
        }
        return null;
    }

    private DirectComboBoxDialog<IComponentNamePO> createDialog(Set<IComponentNamePO> compNames) {
        ArrayList<IComponentNamePO> compNamesList = new ArrayList<IComponentNamePO>(compNames);
        Collections.sort(compNamesList, new Comparator<IComponentNamePO>(){

            @Override
            public int compare(IComponentNamePO compName1, IComponentNamePO compName2) {
                return compName1.getName().compareTo(compName2.getName());
            }
        });
        ArrayList<String> displayNameList = new ArrayList<String>();
        for (IComponentNamePO compName : compNamesList) {
            displayNameList.add(compName.getName());
        }
        DirectComboBoxDialog<IComponentNamePO> dialog = new DirectComboBoxDialog<IComponentNamePO>(this.getActiveShell(), compNamesList, displayNameList, Messages.MergeComponentNamesMessage, Messages.MergeComponentNamesShellTitle, IconConstants.MERGE_COMPONENT_NAME_DIALOG_IMAGE, Messages.MergeComponentNamesShellTitle, Messages.MergeComponentNamesLabel);
        return dialog;
    }

    private void performOperation(Set<IComponentNamePO> compNames, IComponentNamePO selectedCompNamePo) {
        for (IComponentNamePO compName : compNames) {
            compName.setReferencedGuid(selectedCompNamePo.getGuid());
        }
    }

    private void fireChangeEvents(Set<IComponentNamePO> compNames) {
        for (IComponentNamePO compName : compNames) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
        }
    }

    private Set<IComponentNamePO> getComponentNames(IStructuredSelection structuredSel) {
        HashSet<IComponentNamePO> compNames = new HashSet<IComponentNamePO>();
        Object[] objectArray = structuredSel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IComponentNamePO) {
                compNames.add((IComponentNamePO)obj);
            }
            ++n2;
        }
        return compNames;
    }
}

