/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd.utils;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.ProjectVersion;

public class VersionStringUtils {
    public static final char VERSION_SEPARATOR = '.';
    public static final char VERSION_QUALIFIER_SEPARATOR = '_';

    private VersionStringUtils() {
    }

    public static ProjectVersion createProjectVersion(String version) throws MalformedVersionException {
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)version, (String)"_", (int)2);
        if (tokens.length == 1) {
            try {
                return VersionStringUtils.createVersionsNumbers(tokens[0]);
            }
            catch (NumberFormatException numberFormatException) {
                return new ProjectVersion(tokens[0]);
            }
            catch (MalformedVersionException malformedVersionException) {
                return new ProjectVersion(tokens[0]);
            }
        }
        if (tokens.length == 2) {
            ProjectVersion projectNumbers = new ProjectVersion(null);
            if (StringUtils.isNotBlank((String)tokens[0])) {
                try {
                    projectNumbers = VersionStringUtils.createVersionsNumbers(tokens[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedVersionException("parsing the version:" + tokens[0] + " as numbers, was not possible");
                }
            }
            String qualifier = tokens[1];
            return new ProjectVersion(projectNumbers.getMajorNumber(), projectNumbers.getMinorNumber(), projectNumbers.getMicroNumber(), qualifier);
        }
        throw new MalformedVersionException("No version Token found");
    }

    private static ProjectVersion createVersionsNumbers(String versionNumbers) throws NumberFormatException, MalformedVersionException {
        String[] splittedString = versionNumbers.split("\\.");
        Integer major = null;
        Integer minor = null;
        Integer micro = null;
        switch (splittedString.length) {
            case 3: {
                micro = Integer.parseInt(splittedString[2]);
            }
            case 2: {
                minor = Integer.parseInt(splittedString[1]);
            }
            case 1: {
                major = Integer.parseInt(splittedString[0]);
                break;
            }
            default: {
                throw new MalformedVersionException("Version has more than 3 numbers");
            }
        }
        return new ProjectVersion(major, minor, micro);
    }

    public static class MalformedVersionException
    extends Exception {
        public MalformedVersionException(String string) {
            super(string);
        }
    }
}

