/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.ide.css.cssext.ui.adapter.ACssResource;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ExtensionHolder {
    private ResourceSet cachedResourceSet;
    private IProject project;
    private EObject context;
    private ACssResource resource;

    private ResourceSet createResourceSet() {
        if (this.cachedResourceSet == null) {
            IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"dummy:/dummy/file.cssext"));
            IResourceSetProvider rp = (IResourceSetProvider)rsp.get(IResourceSetProvider.class);
            this.cachedResourceSet = rp.get(this.project);
        }
        return this.cachedResourceSet;
    }

    private ResourceSet getResourceSet(EObject context) {
        ResourceSet resourceSet = context.eResource() == null || context.eResource().getResourceSet() == null ? this.createResourceSet() : context.eResource().getResourceSet();
        return resourceSet;
    }

    public ExtensionHolder(IProject project, EObject context, ACssResource resource) {
        this.resource = resource;
        this.project = project;
        this.context = context;
    }

    public List<CssExtension> getModels() {
        ArrayList<CssExtension> result = new ArrayList<CssExtension>();
        ResourceSet resourceSet = this.getResourceSet(this.context);
        URI processedURI = null;
        try {
            Iterator<URI> iterator = this.resource.getAllEnabledExtensions().iterator();
            while (iterator.hasNext()) {
                URI uri;
                processedURI = uri = iterator.next();
                Resource resource = resourceSet.getResource(uri, true);
                if (!resource.getContents().isEmpty()) {
                    result.add((CssExtension)resource.getContents().get(0));
                    continue;
                }
                System.err.println("The resource '" + uri + "' does not contain any elements");
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to find CSSExtension in " + processedURI, t);
        }
        return result;
    }
}

