/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.catalog.v2;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManager;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManagerConfiguration;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManagerFactory;
import org.eclipse.emf.facet.util.emf.core.internal.catalog.v2.CatalogManager;

public class CatalogManagerFactory
implements ICatalogManagerFactory {
    public ICatalogManager getOrCreateCatalogManager(ICatalogManagerConfiguration catalogMgrconfig, ResourceSet resourceSet, String catalogId) {
        CatalogManager result = CatalogManagerFactory.searchExistingMgr(resourceSet, catalogId);
        if (result == null) {
            result = new CatalogManager(catalogMgrconfig, resourceSet, catalogId);
            resourceSet.eAdapters().add((Object)result);
        }
        return result;
    }

    public ICatalogManager createCatalogManager(ICatalogManagerConfiguration catalogMgrconfig, ResourceSet resourceSet) {
        CatalogManager result = new CatalogManager(catalogMgrconfig, resourceSet, null);
        resourceSet.eAdapters().add((Object)result);
        return result;
    }

    private static CatalogManager searchExistingMgr(ResourceSet resourceSet, String catalogId) {
        CatalogManager result = null;
        for (Adapter adapter : resourceSet.eAdapters()) {
            CatalogManager candidate;
            if (!(adapter instanceof CatalogManager) || !(candidate = (CatalogManager)adapter).getCatalogId().equals(catalogId)) continue;
            result = (CatalogManager)adapter;
        }
        return result;
    }
}

