/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.op.FeatureFinishOperation;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.AbstractGitFlowHandler;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.dialogs.FinishFeatureDialog;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.rebase.CommitMessageEditorDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureFinishHandler
extends AbstractGitFlowHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String featureBranch;
        final GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return Activator.error(UIText.Handlers_noGitflowRepositoryFound);
        }
        Repository repo = gfRepo.getRepository();
        try {
            featureBranch = repo.getBranch();
        }
        catch (IOException e) {
            return Activator.error(e.getMessage(), e);
        }
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FinishFeatureDialog dialog = new FinishFeatureDialog(activeShell, featureBranch);
        if (dialog.open() != 0) {
            return null;
        }
        final boolean squash = dialog.isSquash();
        boolean keepBranch = dialog.isKeepBranch();
        try {
            try {
                if (squash && !UIRepositoryUtils.handleUncommittedFiles((Repository)repo, (Shell)activeShell)) {
                    return null;
                }
            }
            catch (GitAPIException e) {
                Activator.logError(e.getMessage(), e);
                return null;
            }
            final FeatureFinishOperation operation = new FeatureFinishOperation(gfRepo);
            operation.setSquash(squash);
            operation.setKeepBranch(keepBranch);
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.FeatureFinishHandler_finishingFeature, (Object)JobFamilies.GITFLOW_FAMILY, (IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobChangeEvent) {
                    if (jobChangeEvent.getResult().isOK()) {
                        FeatureFinishHandler.this.postMerge(gfRepo, featureBranch, squash, operation.getMergeResult());
                    }
                }
            });
            return null;
        }
        catch (IOException | CoreException | OperationCanceledException | WrongGitFlowStateException e) {
            return Activator.error(e.getMessage(), e);
        }
    }

    private void postMerge(final GitFlowRepository gfRepo, final String featureBranch, final boolean squash, final MergeResult mergeResult) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MergeResult.MergeStatus mergeStatus;
                Shell activeShell = Display.getDefault().getActiveShell();
                if (squash && mergeResult.getMergedCommits().length > 1) {
                    try {
                        FeatureFinishHandler.this.rewordCommitMessage(activeShell, gfRepo);
                    }
                    catch (IOException | CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (MergeResult.MergeStatus.CONFLICTING.equals((Object)(mergeStatus = mergeResult.getMergeStatus()))) {
                    String develop = gfRepo.getConfig().getDevelop();
                    MultiStatus status = FeatureFinishHandler.this.createMergeConflictInfo(develop, featureBranch, mergeResult);
                    ErrorDialog.openError(null, (String)UIText.FeatureFinishHandler_Conflicts, null, (IStatus)status);
                }
            }
        });
    }

    private void rewordCommitMessage(Shell activeShell, GitFlowRepository gfRepo) throws CoreException, IOException {
        Repository repository = gfRepo.getRepository();
        CommitHelper commitHelper = new CommitHelper(repository);
        CommitMessageEditorDialog messageEditorDialog = new CommitMessageEditorDialog(activeShell, repository.readSquashCommitMsg(), UIText.FeatureFinishHandler_rewordSquashedCommitMessage);
        if (messageEditorDialog.open() == 0) {
            String commitMessage = FeatureFinishHandler.stripCommentLines(messageEditorDialog.getCommitMessage());
            CommitOperation commitOperation = new CommitOperation(repository, commitHelper.getAuthor(), commitHelper.getCommitter(), commitMessage);
            commitOperation.execute(null);
        }
    }

    private static String stripCommentLines(String commitMessage) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commitMessage.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().startsWith("#")) {
                result.append(line).append("\n");
            }
            ++n2;
        }
        if (!commitMessage.endsWith("\n")) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

