/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.builder;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;

public class IncrementalDotnetBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.acute.builder.IncrementalDotnetBuilder";
    private Process buildProcess;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        IMarker[] errorMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (errorMarkers.length == 0) {
            this.runDotnetSubCommand("build", project, monitor);
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.runDotnetSubCommand("clean", this.getProject(), monitor);
    }

    private void runDotnetSubCommand(String dotnetSubCommand, IProject project, IProgressMonitor monitor) throws CoreException {
        File projectFolder;
        if (this.buildProcess != null && this.buildProcess.isAlive()) {
            this.buildProcess.destroyForcibly();
        }
        if (!(projectFolder = project.getLocation().toFile()).exists() || !projectFolder.isDirectory()) {
            return;
        }
        try {
            String[] commandList = new String[]{AcutePlugin.getDotnetCommand(), dotnetSubCommand};
            this.buildProcess = DebugPlugin.exec((String[])commandList, (File)projectFolder);
            boolean isProcessDone = false;
            while (!isProcessDone) {
                if (monitor.isCanceled()) {
                    this.buildProcess.destroyForcibly();
                }
                isProcessDone = this.buildProcess.waitFor(100L, TimeUnit.MILLISECONDS);
            }
            project.refreshLocal(2, null);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.acute", e.getMessage(), (Throwable)e));
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return null;
    }
}

