/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class Sort
implements PlanNode {
    private final PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Sort(PlanNode parent, ConnectionsGroup connectionsGroup) {
        this.parent = PlanNodeHelper.handleSorting(this, parent, connectionsGroup);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            List<ValidationTuple> sortedTuples;
            Iterator<ValidationTuple> sortedTuplesIterator;
            CloseableIteration<? extends ValidationTuple> iterator;

            @Override
            protected void init() {
                boolean alreadySorted;
                assert (this.sortedTuples == null);
                this.checkClosedOrInterrupted();
                List<ValidationTuple> sortedTuples = new ArrayList<ValidationTuple>(1);
                try (CloseableIteration<? extends ValidationTuple> iterator = Sort.this.parent.iterator();){
                    this.iterator = iterator;
                    alreadySorted = true;
                    ValidationTuple prev = null;
                    while (iterator.hasNext()) {
                        this.checkClosedOrInterrupted();
                        ValidationTuple next = (ValidationTuple)iterator.next();
                        this.checkClosedOrInterrupted();
                        sortedTuples.add(next);
                        if (sortedTuples.size() == 1 && !iterator.hasNext()) {
                            this.sortedTuples = sortedTuples;
                            this.sortedTuplesIterator = sortedTuples.iterator();
                            return;
                        }
                        if (prev != null && prev.compareActiveTarget(next) > 0) {
                            alreadySorted = false;
                        }
                        prev = next;
                        this.checkClosedOrInterrupted();
                    }
                    this.iterator = null;
                    assert (!iterator.hasNext()) : "Iterator: " + String.valueOf(iterator);
                }
                if (!alreadySorted && sortedTuples.size() > 1) {
                    if (sortedTuples.size() > 8192) {
                        ValidationTuple[] objects = sortedTuples.toArray(new ValidationTuple[0]);
                        Arrays.parallelSort(objects, ValidationTuple::compareActiveTarget);
                        sortedTuples = Arrays.asList(objects);
                    } else {
                        sortedTuples.sort(ValidationTuple::compareActiveTarget);
                    }
                }
                this.sortedTuples = sortedTuples;
                this.sortedTuplesIterator = sortedTuples.iterator();
            }

            private void checkClosedOrInterrupted() {
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    Thread.currentThread().interrupt();
                    throw new InterruptedSailException("Thread was interrupted while sorting.");
                }
                if (this.isClosed()) {
                    throw new SailException("Iterator was closed while sorting.");
                }
            }

            @Override
            protected boolean localHasNext() {
                return this.sortedTuplesIterator.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() {
                return this.sortedTuplesIterator.next();
            }

            @Override
            public void localClose() {
                this.sortedTuplesIterator = Collections.emptyIterator();
                this.sortedTuples = null;
                CloseableIteration<? extends ValidationTuple> iterator = this.iterator;
                if (iterator != null) {
                    iterator.close();
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.parent.equals(sort.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public String toString() {
        return "Sort";
    }
}

