/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class JoinIterator
extends LookAheadIteration<BindingSet> {
    private final CloseableIteration<BindingSet> leftIter;
    private CloseableIteration<BindingSet> rightIter;
    private final QueryEvaluationStep preparedRight;

    public JoinIterator(QueryEvaluationStep leftPrepared, QueryEvaluationStep preparedRight, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftPrepared.evaluate(bindings);
        this.preparedRight = preparedRight;
    }

    private JoinIterator(CloseableIteration<BindingSet> leftIter, QueryEvaluationStep preparedRight) throws QueryEvaluationException {
        this.leftIter = leftIter;
        this.preparedRight = preparedRight;
    }

    public static CloseableIteration<BindingSet> getInstance(QueryEvaluationStep leftPrepared, QueryEvaluationStep preparedRight, BindingSet bindings) {
        CloseableIteration<BindingSet> leftIter = leftPrepared.evaluate(bindings);
        if (leftIter == QueryEvaluationStep.EMPTY_ITERATION) {
            return leftIter;
        }
        return new JoinIterator(leftIter, preparedRight);
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.rightIter != null) {
            if (this.rightIter.hasNext()) {
                return (BindingSet)this.rightIter.next();
            }
            this.rightIter.close();
        }
        while (this.leftIter.hasNext()) {
            this.rightIter = this.preparedRight.evaluate((BindingSet)this.leftIter.next());
            if (this.rightIter.hasNext()) {
                return (BindingSet)this.rightIter.next();
            }
            this.rightIter.close();
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            this.leftIter.close();
        }
        finally {
            if (this.rightIter != null) {
                this.rightIter.close();
            }
        }
    }
}

