/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;

public class Prefix
implements QueryElement {
    private static final String PREFIX = "PREFIX";
    private final String label;
    private final Iri iri;

    Prefix(String alias, Iri iri) {
        this.label = alias;
        this.iri = iri;
    }

    Prefix(String alias, IRI iri) {
        this(alias, Rdf.iri(iri));
    }

    Iri getIri() {
        return this.iri;
    }

    String getLabel() {
        return this.label;
    }

    public Iri iri(String localName) {
        return () -> this.label + ":" + localName;
    }

    @Override
    public String getQueryString() {
        return "PREFIX " + this.label + ": " + this.iri.getQueryString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prefix)) {
            return false;
        }
        Prefix other = (Prefix)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.iri == null ? other.iri != null : !this.iri.equals(other.iri));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.iri == null ? 0 : this.iri.hashCode());
        return result;
    }
}

