/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.federation;

import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLFederatedService;

public class SPARQLServiceResolver
extends AbstractFederatedServiceResolver
implements HttpClientDependent,
SessionManagerDependent {
    private volatile HttpClientSessionManager client;
    private volatile SharedHttpClientSessionManager dependentClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientSessionManager getHttpClientSessionManager() {
        HttpClientSessionManager result = this.client;
        if (result == null) {
            SPARQLServiceResolver sPARQLServiceResolver = this;
            synchronized (sPARQLServiceResolver) {
                result = this.client;
                if (result == null) {
                    this.dependentClient = new SharedHttpClientSessionManager();
                    this.client = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        SPARQLServiceResolver sPARQLServiceResolver = this;
        synchronized (sPARQLServiceResolver) {
            this.client = client;
            SharedHttpClientSessionManager toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                toCloseDependentClient.shutDown();
            }
        }
    }

    @Override
    public HttpClient getHttpClient() {
        return this.getHttpClientSessionManager().getHttpClient();
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager toSetDependentClient = this.dependentClient;
        if (toSetDependentClient == null) {
            this.getHttpClientSessionManager();
            toSetDependentClient = this.dependentClient;
        }
        if (toSetDependentClient != null) {
            toSetDependentClient.setHttpClient(httpClient);
        }
    }

    @Override
    protected FederatedService createService(String serviceUrl) throws QueryEvaluationException {
        return new SPARQLFederatedService(serviceUrl, this.getHttpClientSessionManager());
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.dependentClient != null) {
            this.dependentClient.shutDown();
            this.dependentClient = null;
        }
    }
}

