/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unique
implements PlanNode {
    private final Logger logger = LoggerFactory.getLogger(Unique.class);
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Unique(PlanNode parent) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            Set<ValidationTuple> multiCardinalityDedupeSet;
            boolean useMultiCardinalityDedupeSet;
            ValidationTuple next;
            ValidationTuple previous;
            {
                this.parentIterator = Unique.this.parent.iterator();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (temp.getFullChainSize() > 1) {
                        this.useMultiCardinalityDedupeSet = true;
                    }
                    if (this.previous == null) {
                        this.next = temp;
                    } else if (this.useMultiCardinalityDedupeSet) {
                        if (this.multiCardinalityDedupeSet == null || !this.previous.sameTargetAs(temp)) {
                            this.multiCardinalityDedupeSet = new HashSet<ValidationTuple>();
                            if (this.previous.sameTargetAs(temp)) {
                                this.multiCardinalityDedupeSet.add(this.previous);
                            }
                        }
                        if (!this.multiCardinalityDedupeSet.contains(temp)) {
                            this.next = temp;
                            this.multiCardinalityDedupeSet.add(this.next);
                        }
                    } else if (this.previous != temp && !this.previous.equals(temp)) {
                        this.next = temp;
                    }
                    if (this.next != null) {
                        this.previous = this.next;
                        continue;
                    }
                    if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                    Unique.this.validationExecutionLogger.log(Unique.this.depth(), Unique.this.getClass().getSimpleName() + ":IgnoredNotUnique", temp, Unique.this, Unique.this.getId());
                }
            }

            public void close() throws SailException {
                this.multiCardinalityDedupeSet = null;
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                if (this.previous != null && this.next.compareTarget(this.previous) < 0) {
                    throw new AssertionError();
                }
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unique unique = (Unique)o;
        return this.parent.equals(unique.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent, Unique.class);
    }

    public String toString() {
        return "Unique{parent=" + this.parent + '}';
    }
}

