/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.join.JoinExecutorBase;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelJoinTask;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledWorkerJoin
extends JoinExecutorBase<BindingSet> {
    private static final Logger log = LoggerFactory.getLogger(ControlledWorkerJoin.class);
    protected final ControlledWorkerScheduler<BindingSet> scheduler;
    protected final Phaser phaser = new Phaser(1);

    public ControlledWorkerJoin(ControlledWorkerScheduler<BindingSet> scheduler, FederationEvalStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, rightArg, bindings, queryInfo);
        this.scheduler = scheduler;
    }

    @Override
    protected void handleBindings() throws Exception {
        int totalBindings = 0;
        while (!this.closed && this.leftIter.hasNext()) {
            ParallelJoinTask task = new ParallelJoinTask(this, this.strategy, this.rightArg, (BindingSet)this.leftIter.next());
            ++totalBindings;
            this.phaser.register();
            this.scheduler.schedule(task);
        }
        this.scheduler.informFinish(this);
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindings + " results.");
        }
        this.phaser.awaitAdvanceInterruptibly(this.phaser.arrive(), this.queryInfo.getMaxRemainingTimeMS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void done() {
        this.phaser.arriveAndDeregister();
        super.done();
    }

    @Override
    public void toss(Exception e) {
        this.phaser.arriveAndDeregister();
        super.toss(e);
    }
}

