/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.rio.helpers.XMLReaderBasedParser;
import org.eclipse.rdf4j.rio.rdfxml.Att;
import org.eclipse.rdf4j.rio.rdfxml.Atts;
import org.eclipse.rdf4j.rio.rdfxml.SAXFilter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RDFXMLParser
extends XMLReaderBasedParser
implements ErrorHandler {
    private SAXFilter saxFilter;
    private String documentURI;
    private String xmlLang;
    private Stack<Object> elementStack = new Stack();
    private Set<IRI> usedIDs = new HashSet<IRI>();

    public RDFXMLParser() {
        this(SimpleValueFactory.getInstance());
    }

    public RDFXMLParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.saxFilter = new SAXFilter(this);
    }

    @Override
    public final RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    public void setParseStandAloneDocuments(boolean standAloneDocs) {
        this.getParserConfig().set((RioSetting)XMLParserSettings.PARSE_STANDALONE_DOCUMENTS, (Object)standAloneDocs);
    }

    public boolean getParseStandAloneDocuments() {
        return this.getParserConfig().get(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS);
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be 'null'");
        }
        InputSource inputSource = new InputSource((InputStream)new BOMInputStream(in, false));
        inputSource.setSystemId(baseURI);
        this.parse(inputSource);
    }

    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(baseURI);
        this.parse(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputSource) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            this.documentURI = inputSource.getSystemId();
            this.saxFilter.setParseStandAloneDocuments(this.getParserConfig().get(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS));
            this.saxFilter.setDocumentURI(this.documentURI);
            XMLReader xmlReader = this.getXMLReader();
            xmlReader.setContentHandler(this.saxFilter);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(inputSource);
        }
        catch (SAXParseException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e, (long)e.getLineNumber(), (long)e.getColumnNumber());
            } else {
                this.reportFatalError(wrappedExc, (long)e.getLineNumber(), (long)e.getColumnNumber());
            }
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e);
            } else {
                if (wrappedExc instanceof RDFParseException) {
                    throw (RDFParseException)wrappedExc;
                }
                if (wrappedExc instanceof RDFHandlerException) {
                    throw (RDFHandlerException)wrappedExc;
                }
                this.reportFatalError(wrappedExc);
            }
        }
        finally {
            this.saxFilter.clear();
            this.xmlLang = null;
            this.elementStack.clear();
            this.usedIDs.clear();
            this.clear();
        }
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.addAll(this.getCompulsoryXmlPropertySettings());
        results.addAll(this.getCompulsoryXmlFeatureSettings());
        results.addAll(this.getOptionalXmlPropertySettings());
        results.addAll(this.getOptionalXmlFeatureSettings());
        results.add(XMLParserSettings.CUSTOM_XML_READER);
        results.add(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
        results.add(XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        results.add(XMLParserSettings.FAIL_ON_INVALID_QNAME);
        results.add(XMLParserSettings.FAIL_ON_MISMATCHED_TAGS);
        results.add(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
        results.add(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        results.add(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS);
        return results;
    }

    public SAXResult getSAXResult(String baseURI) {
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        this.documentURI = baseURI;
        this.saxFilter.setDocumentURI(baseURI);
        return new SAXResult(this.saxFilter);
    }

    void startDocument() throws RDFParseException, RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
    }

    void endDocument() throws RDFParseException, RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    @Override
    protected void setBaseURI(ParsedIRI baseURI) {
        super.setBaseURI(baseURI);
    }

    @Override
    protected void setBaseURI(String baseURI) {
        super.setBaseURI(baseURI);
    }

    void setXMLLang(String xmlLang) {
        this.xmlLang = "".equals(xmlLang) ? null : xmlLang;
    }

    void startElement(String namespaceURI, String localName, String qName, Atts atts) throws RDFParseException, RDFHandlerException {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, false);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, false);
        }
    }

    void endElement(String namespaceURI, String localName, String qName) throws RDFParseException, RDFHandlerException {
        Object topElement = this.peekStack(0);
        if (topElement instanceof NodeElement) {
            if (((NodeElement)topElement).isVolatile()) {
                this.elementStack.pop();
            }
        } else {
            PropertyElement predicate = (PropertyElement)topElement;
            if (predicate.parseCollection()) {
                Resource lastListResource = predicate.getLastListResource();
                if (lastListResource == null) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.reportStatement(subject.getResource(), predicate.getURI(), RDF.NIL);
                    this.handleReification(RDF.NIL);
                } else {
                    this.reportStatement(lastListResource, RDF.REST, RDF.NIL);
                }
            }
        }
        this.elementStack.pop();
    }

    void emptyElement(String namespaceURI, String localName, String qName, Atts atts) throws RDFParseException, RDFHandlerException {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, true);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, true);
        }
    }

    void text(String text) throws RDFParseException, RDFHandlerException {
        if (!this.topIsProperty()) {
            this.reportError("unexpected literal", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            return;
        }
        PropertyElement propEl = (PropertyElement)this.peekStack(0);
        IRI datatype = propEl.getDatatype();
        Literal lit = this.createLiteral(text, this.xmlLang, datatype);
        NodeElement subject = (NodeElement)this.peekStack(1);
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        this.reportStatement(subject.getResource(), predicate.getURI(), lit);
        this.handleReification(lit);
    }

    private void processNodeElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws RDFParseException, RDFHandlerException {
        Att type;
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkNodeEltName(namespaceURI, localName, qName);
        }
        Resource nodeResource = this.getNodeResource(atts);
        NodeElement nodeElement = new NodeElement(nodeResource);
        if (!this.elementStack.isEmpty()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            PropertyElement predicate = (PropertyElement)this.peekStack(0);
            if (predicate.parseCollection()) {
                Resource lastListRes = predicate.getLastListResource();
                Resource newListRes = this.createNode();
                if (lastListRes == null) {
                    this.reportStatement(subject.getResource(), predicate.getURI(), newListRes);
                    this.handleReification(newListRes);
                } else {
                    this.reportStatement(lastListRes, RDF.REST, newListRes);
                }
                this.reportStatement(newListRes, RDF.FIRST, nodeResource);
                predicate.setLastListResource(newListRes);
            } else {
                this.reportStatement(subject.getResource(), predicate.getURI(), nodeResource);
                this.handleReification(nodeResource);
            }
        }
        if (!localName.equals("Description") || !namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            IRI className = null;
            className = "".equals(namespaceURI) ? this.buildResourceFromLocalName(localName) : this.createURI(namespaceURI + localName);
            this.reportStatement(nodeResource, RDF.TYPE, className);
        }
        if ((type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type")) != null) {
            IRI className = this.resolveURI(type.getValue());
            this.reportStatement(nodeResource, RDF.TYPE, className);
        }
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkRDFAtts(atts);
        }
        this.processSubjectAtts(nodeElement, atts);
        if (!isEmptyElt) {
            this.elementStack.push(nodeElement);
        }
    }

    private Resource getNodeResource(Atts atts) throws RDFParseException {
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        Att about = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            int definedAttsCount = 0;
            if (id != null) {
                ++definedAttsCount;
            }
            if (about != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.reportError("Only one of the attributes rdf:ID, rdf:about or rdf:nodeID can be used here", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            }
        }
        Resource result = null;
        result = id != null ? this.buildURIFromID(id.getValue()) : (about != null ? this.resolveURI(about.getValue()) : (nodeID != null ? this.createNode(nodeID.getValue()) : this.createNode()));
        return result;
    }

    private void processSubjectAtts(NodeElement nodeElt, Atts atts) throws RDFParseException, RDFHandlerException {
        Resource subject = nodeElt.getResource();
        Iterator<Att> iter = atts.iterator();
        while (iter.hasNext()) {
            Att att = iter.next();
            IRI predicate = this.createURI(att.getURI());
            Literal lit = this.createLiteral(att.getValue(), this.xmlLang, null);
            this.reportStatement(subject, predicate, lit);
        }
    }

    private void processPropertyElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws RDFParseException, RDFHandlerException {
        Att parseType;
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkPropertyEltName(namespaceURI, localName, qName, XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
        }
        IRI propURI = null;
        if (namespaceURI.isEmpty()) {
            this.reportError("unqualified property element <" + qName + "> not allowed", XMLParserSettings.FAIL_ON_INVALID_QNAME);
            propURI = this.buildResourceFromLocalName(localName);
        } else {
            propURI = this.createURI(namespaceURI + localName);
        }
        if (propURI.equals(RDF.LI)) {
            NodeElement subject = (NodeElement)this.peekStack(0);
            propURI = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + subject.getNextLiCounter());
        }
        PropertyElement predicate = new PropertyElement(propURI);
        this.elementStack.push(predicate);
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (id != null) {
            IRI reifURI = this.buildURIFromID(id.getValue());
            predicate.setReificationURI(reifURI);
        }
        if ((parseType = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null) {
            String parseTypeValue;
            if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                this.checkNoMoreAtts(atts);
            }
            if ((parseTypeValue = parseType.getValue()).equals("Resource")) {
                Resource objectResource = this.createNode();
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.reportStatement(subject.getResource(), propURI, objectResource);
                if (isEmptyElt) {
                    this.handleReification(objectResource);
                } else {
                    NodeElement object = new NodeElement(objectResource);
                    object.setIsVolatile(true);
                    this.elementStack.push(object);
                }
            } else if (parseTypeValue.equals("Collection")) {
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.reportStatement(subject.getResource(), propURI, RDF.NIL);
                    this.handleReification(RDF.NIL);
                } else {
                    predicate.setParseCollection(true);
                }
            } else {
                if (!parseTypeValue.equals("Literal")) {
                    this.reportWarning("unknown parseType: " + parseType.getValue());
                }
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    Literal lit = this.createLiteral("", null, RDF.XMLLITERAL);
                    this.reportStatement(subject.getResource(), propURI, lit);
                    this.handleReification(lit);
                } else {
                    predicate.setDatatype(RDF.XMLLITERAL);
                    this.saxFilter.setParseLiteralMode();
                }
            }
        } else if (isEmptyElt) {
            Att datatype = atts.getAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (atts.size() == 0 || atts.size() == 1 && datatype != null) {
                NodeElement subject = (NodeElement)this.peekStack(1);
                IRI dtURI = null;
                if (datatype != null) {
                    dtURI = this.createURI(datatype.getValue());
                }
                Literal lit = this.createLiteral("", this.xmlLang, dtURI);
                this.reportStatement(subject.getResource(), propURI, lit);
                this.handleReification(lit);
            } else {
                Resource resourceRes = this.getPropertyResource(atts);
                if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                    this.checkRDFAtts(atts);
                }
                NodeElement resourceElt = new NodeElement(resourceRes);
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.reportStatement(subject.getResource(), propURI, resourceRes);
                this.handleReification(resourceRes);
                Att type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
                if (type != null) {
                    IRI className = this.resolveURI(type.getValue());
                    this.reportStatement(resourceRes, RDF.TYPE, className);
                }
                this.processSubjectAtts(resourceElt, atts);
            }
        } else {
            Att datatype = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (datatype != null) {
                IRI dtURI = this.resolveURI(datatype.getValue());
                predicate.setDatatype(dtURI);
            }
            if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                this.checkNoMoreAtts(atts);
            }
        }
        if (isEmptyElt) {
            this.elementStack.pop();
        }
    }

    private Resource getPropertyResource(Atts atts) throws RDFParseException {
        Att resource = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            int definedAttsCount = 0;
            if (resource != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.reportError("Only one of the attributes rdf:resource or rdf:nodeID can be used here", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            }
        }
        Resource result = null;
        result = resource != null ? this.resolveURI(resource.getValue()) : (nodeID != null ? this.createNode(nodeID.getValue()) : this.createNode());
        return result;
    }

    private void handleReification(Value value) throws RDFParseException, RDFHandlerException {
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        if (predicate.isReified()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            IRI reifRes = predicate.getReificationURI();
            this.reifyStatement(reifRes, subject.getResource(), predicate.getURI(), value);
        }
    }

    private void reifyStatement(Resource reifNode, Resource subj, IRI pred, Value obj) throws RDFParseException, RDFHandlerException {
        this.reportStatement(reifNode, RDF.TYPE, RDF.STATEMENT);
        this.reportStatement(reifNode, RDF.SUBJECT, subj);
        this.reportStatement(reifNode, RDF.PREDICATE, pred);
        this.reportStatement(reifNode, RDF.OBJECT, obj);
    }

    private IRI buildResourceFromLocalName(String localName) throws RDFParseException {
        return this.resolveURI("#" + localName);
    }

    private IRI buildURIFromID(String id) throws RDFParseException {
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_INVALID_NCNAME).booleanValue() && !XMLUtil.isNCName(id)) {
            this.reportError("Not an XML Name: " + id, XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        }
        IRI uri = this.resolveURI("#" + id);
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID).booleanValue() && !this.usedIDs.add(uri)) {
            this.reportError("ID '" + id + "' has already been defined", XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
        }
        return uri;
    }

    @Override
    protected Resource createNode(String nodeID) throws RDFParseException {
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_INVALID_NCNAME).booleanValue() && !XMLUtil.isNCName(nodeID)) {
            this.reportError("Not an XML Name: " + nodeID, XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        }
        return super.createNode(nodeID);
    }

    private Object peekStack(int distFromTop) {
        return this.elementStack.get(this.elementStack.size() - 1 - distFromTop);
    }

    private boolean topIsProperty() {
        return this.elementStack.isEmpty() || this.peekStack(0) instanceof PropertyElement;
    }

    private void checkNodeEltName(String namespaceURI, String localName, String qName) throws RDFParseException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("Description") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("<" + qName + "> not allowed as node element", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(qName + " is no longer a valid RDF name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else {
                this.reportWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void checkPropertyEltName(String namespaceURI, String localName, String qName, RioSetting<Boolean> setting) throws RDFParseException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("li") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("Description") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("<" + qName + "> not allowed as property element", setting);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(qName + " is no longer a valid RDF name", setting);
            } else {
                this.reportWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void checkRDFAtts(Atts atts) throws RDFParseException {
        Iterator<Att> iter = atts.iterator();
        while (iter.hasNext()) {
            String localName;
            Att att = iter.next();
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(att.getNamespace()) || (localName = att.getLocalName()).equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_")) continue;
            if (localName.equals("Description") || localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("'" + att.getQName() + "' not allowed as attribute name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter.remove();
                continue;
            }
            if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(att.getQName() + " is no longer a valid RDF name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                continue;
            }
            this.reportWarning("unknown rdf attribute '" + att.getQName() + "'");
        }
    }

    private void checkNoMoreAtts(Atts atts) throws RDFParseException {
        if (atts.size() > 0) {
            Iterator<Att> iter = atts.iterator();
            while (iter.hasNext()) {
                Att att = iter.next();
                this.reportError("unexpected attribute '" + att.getQName() + "'", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter.remove();
            }
        }
    }

    private void reportStatement(Resource subject, IRI predicate, Value object) throws RDFParseException, RDFHandlerException {
        Statement st = this.createStatement(subject, predicate, object);
        if (this.rdfHandler != null) {
            this.rdfHandler.handleStatement(st);
        }
    }

    @Override
    protected Literal createLiteral(String label, String lang, IRI datatype) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            return this.createLiteral(label, lang, datatype, locator.getLineNumber(), locator.getColumnNumber());
        }
        return this.createLiteral(label, lang, datatype, -1L, -1L);
    }

    @Override
    protected void reportWarning(String msg) {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportWarning(msg, locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.reportWarning(msg, -1L, -1L);
        }
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportError(msg, (long)locator.getLineNumber(), (long)locator.getColumnNumber(), setting);
        } else {
            this.reportError(msg, -1L, -1L, setting);
        }
    }

    @Override
    protected void reportError(Exception e, RioSetting<Boolean> setting) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportError(e, (long)locator.getLineNumber(), (long)locator.getColumnNumber(), setting);
        } else {
            this.reportError(e, -1L, -1L, setting);
        }
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportFatalError(msg, (long)locator.getLineNumber(), (long)locator.getColumnNumber());
        } else {
            this.reportFatalError(msg, -1L, -1L);
        }
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportFatalError(e, (long)locator.getLineNumber(), (long)locator.getColumnNumber());
        } else {
            this.reportFatalError(e, -1L, -1L);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.reportWarning(exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.reportError(exception, XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.reportFatalError(exception);
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    static class PropertyElement {
        private IRI uri;
        private IRI reificationURI;
        private IRI datatype;
        private boolean parseCollection = false;
        private Resource lastListResource;

        public PropertyElement(IRI uri) {
            this.uri = uri;
        }

        public IRI getURI() {
            return this.uri;
        }

        public boolean isReified() {
            return this.reificationURI != null;
        }

        public void setReificationURI(IRI reifURI) {
            this.reificationURI = reifURI;
        }

        public IRI getReificationURI() {
            return this.reificationURI;
        }

        public void setDatatype(IRI datatype) {
            this.datatype = datatype;
        }

        public IRI getDatatype() {
            return this.datatype;
        }

        public boolean parseCollection() {
            return this.parseCollection;
        }

        public void setParseCollection(boolean parseCollection) {
            this.parseCollection = parseCollection;
        }

        public Resource getLastListResource() {
            return this.lastListResource;
        }

        public void setLastListResource(Resource resource) {
            this.lastListResource = resource;
        }
    }

    static class NodeElement {
        private Resource resource;
        private boolean isVolatile = false;
        private int liCounter = 1;

        public NodeElement(Resource resource) {
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setIsVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public int getNextLiCounter() {
            return this.liCounter++;
        }
    }
}

