/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnorderedSelect;

public class InversePath
extends Path {
    private final IRI path;

    public InversePath(Resource id, IRI path) {
        super(id);
        this.path = path;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        return connectionsGroup.getCachedNodeFor(new Sort(new UnorderedSelect(connectionsGroup.getBaseConnection(), null, this.path, null, UnorderedSelect.OutputPattern.ObjectSubject)));
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, this.path, null, UnorderedSelect.OutputPattern.ObjectSubject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, this.path, null, UnorderedSelect.OutputPattern.ObjectSubject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Path> getPaths() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements, Stats stats) {
        if (stats.isEmpty()) {
            return false;
        }
        return addedStatements.hasStatement(null, this.path, null, false, new Resource[0]) || removedStatements.hasStatement(null, this.path, null, false, new Resource[0]);
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        return objectVariable + " <" + this.path + "> " + subjectVariable + " . \n";
    }

    public IRI getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InversePath that = (InversePath)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.path.toString();
    }

    @Override
    public Stream<StatementPattern> getStatementsPatterns(Var start, Var end) {
        return Stream.of(new StatementPattern(end, new Var(UUID.randomUUID().toString(), (Value)this.path), start));
    }
}

