/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.eclipse.rdf4j.federated.endpoint.EndpointType;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.util.Vocabulary;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;

public class RemoteRepositoryRepositoryInformation
extends RepositoryInformation {
    public RemoteRepositoryRepositoryInformation(Model graph, Resource repNode) {
        super(EndpointType.RemoteRepository);
        this.initialize(graph, repNode);
    }

    public RemoteRepositoryRepositoryInformation(String repositoryServer, String repositoryName) {
        super("remote_" + repositoryName, "http://" + repositoryName, repositoryServer + "/" + repositoryName, EndpointType.RemoteRepository);
        this.setProperty("repositoryServer", repositoryServer);
        this.setProperty("repositoryName", repositoryName);
    }

    protected void initialize(Model graph, Resource repNode) {
        this.setProperty("name", repNode.stringValue());
        Model repositoryServer = graph.filter(repNode, Vocabulary.FEDX.REPOSITORY_SERVER, null, new Resource[0]);
        String repoLocation = ((Statement)repositoryServer.iterator().next()).getObject().stringValue();
        this.setProperty("location", repoLocation);
        this.setProperty("repositoryServer", repoLocation);
        Model repositoryName = graph.filter(repNode, Vocabulary.FEDX.REPOSITORY_NAME, null, new Resource[0]);
        String repoName = ((Statement)repositoryName.iterator().next()).getObject().stringValue();
        this.setProperty("repositoryName", repoName);
        String id = repNode.stringValue().replace("http://", "");
        id = "remote_" + id.replace("/", "_");
        this.setProperty("id", id);
    }
}

