/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(UnorderedSelect.class);
    private final SailConnection connection;
    private final Resource subject;
    private final IRI predicate;
    private final Value object;
    private final OutputPattern outputPattern;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public UnorderedSelect(SailConnection connection, Resource subject, IRI predicate, Value object, OutputPattern outputPattern) {
        this.connection = connection;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.outputPattern = outputPattern;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends Statement, SailException> statements;
            {
                this.statements = UnorderedSelect.this.connection.getStatements(UnorderedSelect.this.subject, UnorderedSelect.this.predicate, UnorderedSelect.this.object, true, new Resource[0]);
            }

            @Override
            public void close() throws SailException {
                this.statements.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.statements.hasNext();
            }

            @Override
            Tuple loggingNext() throws SailException {
                Statement next = (Statement)this.statements.next();
                if (UnorderedSelect.this.outputPattern == OutputPattern.SubjectObject) {
                    return new Tuple(next.getSubject(), next.getObject());
                }
                if (UnorderedSelect.this.outputPattern == OutputPattern.ObjectSubject) {
                    return new Tuple(next.getObject(), next.getSubject());
                }
                if (UnorderedSelect.this.outputPattern == OutputPattern.SubjectPredicateObject) {
                    return new Tuple(next.getSubject(), next.getPredicate(), next.getObject());
                }
                if (UnorderedSelect.this.outputPattern == OutputPattern.ObjectPredicateSubject) {
                    return new Tuple(next.getObject(), next.getPredicate(), next.getSubject());
                }
                throw new IllegalStateException("Unkown output pattern: " + (Object)((Object)UnorderedSelect.this.outputPattern));
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.tripleBased;
    }

    public String toString() {
        return "UnorderedSelect{subject=" + Formatter.prefix(this.subject) + ", predicate=" + Formatter.prefix(this.predicate) + ", object=" + Formatter.prefix(this.object) + ", outputPattern=" + (Object)((Object)this.outputPattern) + '}';
    }

    public boolean equals(Object o) {
        Object thatConnection;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnorderedSelect that = (UnorderedSelect)o;
        Object connection = this.connection;
        if (connection instanceof MemoryStoreConnection) {
            connection = ((MemoryStoreConnection)connection).getSail();
        }
        if ((thatConnection = that.connection) instanceof MemoryStoreConnection) {
            thatConnection = ((MemoryStoreConnection)thatConnection).getSail();
        }
        return connection.equals(thatConnection) && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        Object connection = this.connection;
        if (connection instanceof MemoryStoreConnection) {
            connection = ((MemoryStoreConnection)connection).getSail();
        }
        return Objects.hash(connection, this.subject, this.predicate, this.object);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    public static enum OutputPattern {
        SubjectObject,
        ObjectSubject,
        ObjectPredicateSubject,
        SubjectPredicateObject;

    }
}

